/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.expd.jdbc;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.TimeZone;
import org.mbari.sql.DBException;
import org.mbari.sql.QueryableImpl;

public class BaseDAOImpl
extends QueryableImpl {
    private static final ResourceBundle bundle = ResourceBundle.getBundle("expd-jdbc");
    public static final DateFormat DATE_FORMAT_UTC = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"){
        {
            this.setTimeZone(TimeZone.getTimeZone("UTC"));
        }
    };
    public static final String VENTANA = "Ventana";
    public static final String TIBURON = "Tiburon";
    public static final String DOC_RICKETTS = "Doc Ricketts";
    public static final String WESTERN_FLYER = "Western Flyer";
    public static final String POINT_LOBOS = "Point Lobos";
    public static final String RACHEL_CARSON = "Rachel Carson";
    public static final Integer OFFSET_SECONDS = 7;

    public BaseDAOImpl() {
        super(bundle.getString("jdbc.url"), bundle.getString("jdbc.username"), bundle.getString("jdbc.password"), bundle.getString("jdbc.driver"));
        try {
            Class.forName(bundle.getString("jdbc.driver"));
        }
        catch (ClassNotFoundException ex) {
            throw new DBException("Failed to initialize driver class:" + bundle.getString("jdbc.driver"), (Throwable)ex);
        }
    }

    public static String resolveShipTablePrefix(String ship) {
        String prefix = "";
        String fullname = BaseDAOImpl.resolveFullShipName(ship);
        if (fullname.equals(WESTERN_FLYER)) {
            prefix = "WesternFlyer";
        } else if (fullname.equals(POINT_LOBOS)) {
            prefix = "PointLobos";
        } else if (fullname.equalsIgnoreCase(RACHEL_CARSON)) {
            prefix = "RachelCarson";
        }
        return prefix;
    }

    public static String resolveFullShipName(String ship) {
        String fullname = ship;
        if (ship != null) {
            if (ship.toUpperCase().startsWith("W")) {
                fullname = WESTERN_FLYER;
            } else if (ship.toUpperCase().startsWith("P")) {
                fullname = POINT_LOBOS;
            } else if (ship.toUpperCase().startsWith("R")) {
                fullname = RACHEL_CARSON;
            }
        }
        return fullname;
    }

    public static String resolveRovTablePrefix(String platform) {
        String prefix = "";
        String fullName = BaseDAOImpl.resolveFullRovName(platform);
        if (fullName.equals(DOC_RICKETTS)) {
            prefix = "DocRicketts";
        } else if (fullName.equals(TIBURON) || fullName.equals(VENTANA)) {
            prefix = fullName;
        }
        return prefix;
    }

    public static String resolveFullRovName(String platform) {
        String fullName = platform;
        if (platform != null) {
            if (platform.toUpperCase().startsWith("VENT") || platform.equalsIgnoreCase("vnta")) {
                fullName = VENTANA;
            } else if (platform.toUpperCase().startsWith("DOC")) {
                fullName = DOC_RICKETTS;
            } else if (platform.toUpperCase().startsWith("TIB")) {
                fullName = TIBURON;
            }
        }
        return fullName;
    }

    public static String toShortRovName(String platform) {
        String shortName = platform;
        String fullName = BaseDAOImpl.resolveFullRovName(platform);
        if (fullName.equals(VENTANA)) {
            shortName = "vnta";
        } else if (fullName.equals(TIBURON)) {
            shortName = "tibr";
        } else if (fullName.equals(DOC_RICKETTS)) {
            shortName = "docr";
        }
        return shortName;
    }

    public static Collection<String> resolveRovByShip(String shipName) {
        ArrayList<String> rovNames = new ArrayList<String>();
        String fullShipName = BaseDAOImpl.resolveFullShipName(shipName);
        if (fullShipName.equals(POINT_LOBOS)) {
            rovNames.add(VENTANA);
        } else if (fullShipName.equals(WESTERN_FLYER)) {
            rovNames.add(TIBURON);
            rovNames.add(DOC_RICKETTS);
        } else if (fullShipName.equals(RACHEL_CARSON)) {
            rovNames.add(VENTANA);
        }
        return rovNames;
    }

    public static Collection<String> resolveShipByRov(String rovName) {
        ArrayList<String> shipNames = new ArrayList<String>();
        String fullRovName = BaseDAOImpl.resolveFullRovName(rovName);
        if (fullRovName.equals(VENTANA)) {
            shipNames.add(POINT_LOBOS);
            shipNames.add(RACHEL_CARSON);
        } else if (fullRovName.equals(TIBURON)) {
            shipNames.add(WESTERN_FLYER);
        } else if (fullRovName.equals(DOC_RICKETTS)) {
            shipNames.add(WESTERN_FLYER);
            shipNames.add(DOC_RICKETTS);
        }
        return shipNames;
    }

    public static List<String> getAllRovNames() {
        return new ArrayList<String>(){
            {
                this.add(BaseDAOImpl.VENTANA);
                this.add(BaseDAOImpl.TIBURON);
                this.add(BaseDAOImpl.DOC_RICKETTS);
            }
        };
    }
}

