/*
 * Decompiled with CFR 0.152.
 */
package vars.query.util;

import com.google.common.collect.Maps;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import vars.query.util.Dataset;
import vars.query.util.MutableSimpleDataset;

public class QueryResultsReader {
    public static Dataset read(File file) throws IOException {
        FileInputStream in = new FileInputStream(file);
        Dataset dataset = QueryResultsReader.read(in);
        ((InputStream)in).close();
        return dataset;
    }

    public static Dataset read(InputStream in) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        MutableSimpleDataset dataset = null;
        String[] headers = null;
        while ((line = reader.readLine()) != null) {
            if (line.trim().startsWith("#")) continue;
            if (dataset != null) {
                String[] parts = line.split("\t");
                HashMap map = Maps.newHashMap();
                for (int i = 0; i < headers.length; ++i) {
                    map.put(headers[i], parts[i]);
                }
                dataset.addRow(map);
                continue;
            }
            headers = line.split("\t");
            dataset = new MutableSimpleDataset(headers);
        }
        reader.close();
        return dataset;
    }
}

