/*
 * Decompiled with CFR 0.152.
 */
package vars;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.prefs.Preferences;
import org.mbari.expd.DAOFactory;
import vars.ScriptingModule;
import vars.VarsUserPreferencesFactory;
import vars.annotation.ui.ToolBelt;
import vars.integration.MergeHistoryDAO;
import vars.integration.MergeStatusDAO;

public class ToolBox {
    private final ToolBelt toolBelt;
    private final Injector injector = Guice.createInjector((Module[])new Module[]{new ScriptingModule()});

    public ToolBox() {
        this.toolBelt = (ToolBelt)this.injector.getInstance(ToolBelt.class);
    }

    public Injector getInjector() {
        return this.injector;
    }

    public ToolBelt getToolBelt() {
        return this.toolBelt;
    }

    public DAOFactory getDaoFactory() {
        return (DAOFactory)this.injector.getInstance(DAOFactory.class);
    }

    public MergeHistoryDAO getMergeHistoryDAO() {
        return (MergeHistoryDAO)this.injector.getInstance(MergeHistoryDAO.class);
    }

    public MergeStatusDAO getMergeStatusDAO() {
        return (MergeStatusDAO)this.injector.getInstance(MergeStatusDAO.class);
    }

    public Preferences getPreferences(String username) {
        VarsUserPreferencesFactory factory = (VarsUserPreferencesFactory)this.injector.getInstance(VarsUserPreferencesFactory.class);
        return factory.userRoot(username);
    }
}

