/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vars.varspub;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageOutputStream;
import org.apache.commons.imaging.Imaging;
import org.apache.commons.imaging.formats.jpeg.JpegImageMetadata;
import org.apache.commons.imaging.formats.jpeg.exif.ExifRewriter;
import org.apache.commons.imaging.formats.tiff.write.TiffOutputSet;
import org.imgscalr.Scalr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;

public final class WatermarkUtilities$ {
    public static WatermarkUtilities$ MODULE$;
    private AlphaComposite alphaComposite;
    private final Logger log;
    private volatile boolean bitmap$0;

    static {
        new WatermarkUtilities$();
    }

    private AlphaComposite alphaComposite$lzycompute() {
        WatermarkUtilities$ watermarkUtilities$ = this;
        synchronized (watermarkUtilities$) {
            if (!this.bitmap$0) {
                this.alphaComposite = AlphaComposite.getInstance(3, 0.5f);
                this.bitmap$0 = true;
            }
        }
        return this.alphaComposite;
    }

    private AlphaComposite alphaComposite() {
        return !this.bitmap$0 ? this.alphaComposite$lzycompute() : this.alphaComposite;
    }

    public BufferedImage scaleOverlay(double scaleValue, BufferedImage overlay) {
        int w = (int)package$.MODULE$.ceil((double)overlay.getWidth() * scaleValue);
        int h = (int)package$.MODULE$.ceil((double)overlay.getHeight() * scaleValue);
        return Scalr.resize((BufferedImage)overlay, (Scalr.Method)Scalr.Method.ULTRA_QUALITY, (int)w, (BufferedImageOp[])new BufferedImageOp[0]);
    }

    public boolean canUseExiftool() {
        return scala.sys.process.package$.MODULE$.stringToProcess("which exiftool").$bang() == 0;
    }

    public void saveImage(RenderedImage image, File target, Function0<BoxedUnit> postSave) throws IOException {
        String path = target.getAbsolutePath();
        int dotIdx = path.lastIndexOf(".");
        String ext = path.substring(dotIdx + 1);
        ImageIO.write(image, ext, target);
        postSave.apply$mcV$sp();
    }

    public Function0<BoxedUnit> saveImage$default$3() {
        return (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {};
    }

    public BufferedImage addWatermarkImage(BufferedImage image, BufferedImage overlay, double overlayPercentWidth) {
        Graphics2D g2 = (Graphics2D)image.getGraphics();
        double v = (double)image.getWidth() * overlayPercentWidth / (double)overlay.getWidth();
        BufferedImage so = this.scaleOverlay(v, overlay);
        int x = (int)package$.MODULE$.round((double)image.getWidth() * 0.05);
        int y = (int)package$.MODULE$.round((double)image.getHeight() * 0.85 - (double)so.getHeight());
        g2.setComposite(this.alphaComposite());
        g2.drawImage((Image)so, x, y, null);
        g2.dispose();
        return image;
    }

    public double addWatermarkImage$default$3() {
        return 0.4;
    }

    public boolean imageExistsAt(URL url) {
        this.log.debug("Attempting to read image at {}", new Object[]{url});
        return BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            InputStream inputStream = url.openStream();
            byte[] buf = (byte[])Array$.MODULE$.ofDim(6, ClassTag$.MODULE$.Byte());
            inputStream.read(buf);
            inputStream.close();
            return true;
        }).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            WatermarkUtilities$.MODULE$.log.debug("Failed to read {}", new Object[]{url});
            return false;
        }));
    }

    public byte[] toJpegByteArray(BufferedImage image) {
        return this.toImageByteArray(image, "jpg");
    }

    public byte[] toPngByteArray(BufferedImage image) {
        return this.toImageByteArray(image, "png");
    }

    public byte[] toImageByteArray(BufferedImage image, String format) {
        ByteArrayOutputStream os0 = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)image, format, os0);
        byte[] imageBytes = os0.toByteArray();
        os0.close();
        return imageBytes;
    }

    public TiffOutputSet getOrCreateOutputSet(byte[] jpegBytes) {
        ByteArrayInputStream is0 = new ByteArrayInputStream(jpegBytes);
        Option metadata = Option$.MODULE$.apply((Object)((JpegImageMetadata)Imaging.getMetadata((InputStream)is0, (String)"")));
        TiffOutputSet outputSet = (TiffOutputSet)metadata.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getExif()).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getOutputSet()).getOrElse((Function0 & Serializable & scala.Serializable)() -> new TiffOutputSet());
        is0.close();
        return outputSet;
    }

    public byte[] addExifAsJPG(byte[] jpegBytes, TiffOutputSet outputSet) {
        ByteArrayOutputStream os1 = new ByteArrayOutputStream();
        ByteArrayInputStream is1 = new ByteArrayInputStream(jpegBytes);
        new ExifRewriter().updateExifMetadataLossless((InputStream)is1, (OutputStream)os1, outputSet);
        byte[] jpegWithExifBytes = os1.toByteArray();
        os1.close();
        is1.close();
        return jpegWithExifBytes;
    }

    public byte[] addMetadataAsPNG(BufferedImage image, Map<String, String> txt) {
        ImageWriter writer = ImageIO.getImageWritersByFormatName("png").next();
        ImageWriteParam writeParam = writer.getDefaultWriteParam();
        ImageTypeSpecifier typeSpecifier = ImageTypeSpecifier.createFromBufferedImageType(1);
        IIOMetadata metadata = writer.getDefaultImageMetadata(typeSpecifier, writeParam);
        IIOMetadataNode text = new IIOMetadataNode("iTXt");
        txt.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)WatermarkUtilities$.$anonfun$addMetadataAsPNG$1(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            Tuple2 tuple2 = x$3;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String key = (String)tuple2._1();
            String value = (String)tuple2._2();
            IIOMetadataNode textEntry = new IIOMetadataNode("iTXtEntry");
            textEntry.setAttribute("keyword", key);
            textEntry.setAttribute("text", value);
            textEntry.setAttribute("compressionFlag", "FALSE");
            textEntry.setAttribute("compressionMethod", "0");
            textEntry.setAttribute("languageTag", "en-US");
            textEntry.setAttribute("translatedKeyword", key);
            Node node = text.appendChild(textEntry);
            return node;
        });
        IIOMetadataNode root = new IIOMetadataNode("javax_imageio_png_1.0");
        root.appendChild(text);
        metadata.mergeTree("javax_imageio_png_1.0", root);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        ImageOutputStream stream = ImageIO.createImageOutputStream(os);
        writer.setOutput(stream);
        writer.write(metadata, new IIOImage(image, null, metadata), writeParam);
        return os.toByteArray();
    }

    public static final /* synthetic */ boolean $anonfun$addMetadataAsPNG$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    private WatermarkUtilities$() {
        MODULE$ = this;
        this.log = LoggerFactory.getLogger(this.getClass());
    }
}

