/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vars.varspub;

import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.Serializable;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.imageio.ImageIO;
import org.apache.commons.imaging.formats.tiff.constants.ExifTagConstants;
import org.apache.commons.imaging.formats.tiff.constants.TiffTagConstants;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfo;
import org.apache.commons.imaging.formats.tiff.write.TiffOutputDirectory;
import org.apache.commons.imaging.formats.tiff.write.TiffOutputSet;
import org.mbari.vars.varspub.KBImageMigrator2$;
import org.mbari.vars.varspub.WatermarkUtilities$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.MapLike;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Try$;
import vars.knowledgebase.Concept;
import vars.knowledgebase.ConceptDAO;
import vars.knowledgebase.Media;
import vars.knowledgebase.ui.ToolBelt;

@ScalaSignature(bytes="\u0006\u0001\u0005]e\u0001B\u0001\u0003\u0001-\u0011\u0001c\u0013\"J[\u0006<W-T5he\u0006$xN\u001d\u001a\u000b\u0005\r!\u0011a\u0002<beN\u0004XO\u0019\u0006\u0003\u000b\u0019\tAA^1sg*\u0011q\u0001C\u0001\u0006[\n\f'/\u001b\u0006\u0002\u0013\u0005\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\u0004\t\u0003\u001bAi\u0011A\u0004\u0006\u0002\u001f\u0005)1oY1mC&\u0011\u0011C\u0004\u0002\u0007\u0003:L(+\u001a4\t\u0011M\u0001!\u0011!Q\u0001\nQ\ta\u0001^1sO\u0016$\bCA\u000b\u001d\u001b\u00051\"BA\f\u0019\u0003\u00111\u0017\u000e\\3\u000b\u0005eQ\u0012a\u00018j_*\t1$\u0001\u0003kCZ\f\u0017BA\u000f\u0017\u0005\u0011\u0001\u0016\r\u001e5\t\u0011}\u0001!\u0011!Q\u0001\n\u0001\nqb\u001c<fe2\f\u00170S7bO\u0016,&\u000b\u0014\t\u0003C\u0011j\u0011A\t\u0006\u0003Gi\t1A\\3u\u0013\t)#EA\u0002V%2C\u0001b\n\u0001\u0003\u0002\u0003\u0006I\u0001K\u0001\bo\u0016\u0014\u0007/\u0019;i!\tI\u0003G\u0004\u0002+]A\u00111FD\u0007\u0002Y)\u0011QFC\u0001\u0007yI|w\u000e\u001e \n\u0005=r\u0011A\u0002)sK\u0012,g-\u0003\u00022e\t11\u000b\u001e:j]\u001eT!a\f\b\t\u0011Q\u0002!\u0011!Q\u0001\nU\n1c\u001c<fe2\f\u0017\u0010U3sG\u0016tGoV5ei\"\u0004\"!\u0004\u001c\n\u0005]r!A\u0002#pk\ndW\r\u0003\u0005:\u0001\t\u0005\t\u0015a\u0003;\u0003!!xn\u001c7CK2$\bCA\u001eB\u001b\u0005a$BA\u001f?\u0003\t)\u0018N\u0003\u0002@\u0001\u0006i1N\\8xY\u0016$w-\u001a2bg\u0016T\u0011!B\u0005\u0003\u0005r\u0012\u0001\u0002V8pY\n+G\u000e\u001e\u0005\u0006\t\u0002!\t!R\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000b\u0019S5\nT'\u0015\u0005\u001dK\u0005C\u0001%\u0001\u001b\u0005\u0011\u0001\"B\u001dD\u0001\bQ\u0004\"B\nD\u0001\u0004!\u0002\"B\u0010D\u0001\u0004\u0001\u0003bB\u0014D!\u0003\u0005\r\u0001\u000b\u0005\bi\r\u0003\n\u00111\u00016\u0011\u0019y\u0005\u0001)A\u0005!\u0006\u0019An\\4\u0011\u0005E#V\"\u0001*\u000b\u0005MC\u0011!B:mMRR\u0017BA+S\u0005\u0019aunZ4fe\"1q\u000b\u0001Q\u0001\na\u000b!bY8oG\u0016\u0004H\u000fR1p!\tI&,D\u0001?\u0013\tYfH\u0001\u0006D_:\u001cW\r\u001d;E\u0003>Ca!\u0018\u0001!\u0002\u0013q\u0016AC=fCJ4uN]7biB\u0011qLY\u0007\u0002A*\u0011\u0011MG\u0001\u0005i\u0016DH/\u0003\u0002dA\n\u00012+[7qY\u0016$\u0015\r^3G_Jl\u0017\r\u001e\u0005\u0007K\u0002\u0001\u000b\u0011\u00024\u0002\u00079|w\u000f\u0005\u0002hU6\t\u0001N\u0003\u0002j5\u0005!Q\u000f^5m\u0013\tY\u0007N\u0001\u0003ECR,\u0007BB7\u0001A\u0003%a.\u0001\u0007pm\u0016\u0014H.Y=J[\u0006<W\r\u0005\u0002pi6\t\u0001O\u0003\u0002re\u0006)\u0011.\\1hK*\u00111OG\u0001\u0004C^$\u0018BA;q\u00055\u0011UO\u001a4fe\u0016$\u0017*\\1hK\")q\u000f\u0001C\u0001q\u0006q\u0001O]8dKN\u001c8i\u001c8dKB$HCA=}!\ti!0\u0003\u0002|\u001d\t!QK\\5u\u0011\u0015ih\u000f1\u0001\u007f\u0003\u001d\u0019wN\\2faR\u0004\"!W@\n\u0007\u0005\u0005aHA\u0004D_:\u001cW\r\u001d;\t\u000f\u0005\u0015\u0001\u0001\"\u0001\u0002\b\u0005aAo\u001c+be\u001e,G\u000fU1uQR!\u0011\u0011BA\b!\u0011i\u00111\u0002\u000b\n\u0007\u00055aB\u0001\u0004PaRLwN\u001c\u0005\t\u0003#\t\u0019\u00011\u0001\u0002\u0014\u0005)Q.\u001a3jCB\u0019\u0011,!\u0006\n\u0007\u0005]aHA\u0003NK\u0012L\u0017\rC\u0004\u0002\u001c\u0001!\t!!\b\u0002\u0013]\fG/\u001a:xCJ\\GCBA\u0010\u0003C\t\u0019\u0003\u0005\u0003\u000e\u0003\u0017q\u0007\u0002CA\t\u00033\u0001\r!a\u0005\t\u000f\u0005\u0015\u0012\u0011\u0004a\u0001]\u00069qN^3sY\u0006L\bbBA\u0015\u0001\u0011\u0005\u00111F\u0001\bC\u0012$W\t_5g)!\ti#!\u000f\u0002<\u0005u\u0002#B\u0007\u00020\u0005M\u0012bAA\u0019\u001d\t)\u0011I\u001d:bsB\u0019Q\"!\u000e\n\u0007\u0005]bB\u0001\u0003CsR,\u0007BB?\u0002(\u0001\u0007a\u0010\u0003\u0004r\u0003O\u0001\rA\u001c\u0005\t\u0003\u007f\t9\u00031\u0001\u0002B\u000511M]3eSR\u0004B!DA\u0006Q!9\u0011Q\t\u0001\u0005\u0002\u0005\u001d\u0013aB1eIR+\u0007\u0010\u001e\u000b\t\u0003[\tI%a\u0013\u0002N!1Q0a\u0011A\u0002yDa!]A\"\u0001\u0004q\u0007\u0002CA \u0003\u0007\u0002\r!!\u0011\b\u000f\u0005E#\u0001#\u0001\u0002T\u0005\u00012JQ%nC\u001e,W*[4sCR|'O\r\t\u0004\u0011\u0006UcAB\u0001\u0003\u0011\u0003\t9fE\u0002\u0002V1Aq\u0001RA+\t\u0003\tY\u0006\u0006\u0002\u0002T!A\u0011qLA+\t\u0003\t\t'\u0001\u0003nC&tGcA=\u0002d!A\u0011QMA/\u0001\u0004\t9'\u0001\u0003be\u001e\u001c\b\u0003B\u0007\u00020!B\u0001\"a\u001b\u0002V\u0011%\u0011QN\u0001\u0004eVtG#B=\u0002p\u0005M\u0004bBA9\u0003S\u0002\raR\u0001\u000eS6\fw-Z'jOJ\fGo\u001c:\t\ru\fI\u00071\u0001\u007f\u0011)\t9(!\u0016\u0012\u0002\u0013\u0005\u0011\u0011P\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005m$f\u0001\u0015\u0002~-\u0012\u0011q\u0010\t\u0005\u0003\u0003\u000bY)\u0004\u0002\u0002\u0004*!\u0011QQAD\u0003%)hn\u00195fG.,GMC\u0002\u0002\n:\t!\"\u00198o_R\fG/[8o\u0013\u0011\ti)a!\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r\u0003\u0006\u0002\u0012\u0006U\u0013\u0013!C\u0001\u0003'\u000b1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\"TCAAKU\r)\u0014Q\u0010")
public class KBImageMigrator2 {
    private final Path target;
    private final String webpath;
    private final double overlayPercentWidth;
    private final Logger log;
    private final ConceptDAO conceptDao;
    private final SimpleDateFormat yearFormat;
    private final Date now;
    private final BufferedImage overlayImage;

    public static double $lessinit$greater$default$4() {
        return KBImageMigrator2$.MODULE$.$lessinit$greater$default$4();
    }

    public static String $lessinit$greater$default$3() {
        return KBImageMigrator2$.MODULE$.$lessinit$greater$default$3();
    }

    public static void main(String[] stringArray) {
        KBImageMigrator2$.MODULE$.main(stringArray);
    }

    public void processConcept(Concept concept) {
        this.conceptDao.startTransaction();
        Concept c = (Concept)this.conceptDao.find((Object)concept);
        Iterable medias = (Iterable)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(c.getConceptMetadata().getMedias()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)KBImageMigrator2.$anonfun$processConcept$1(x$1)));
        medias.foreach((Function1 & Serializable & scala.Serializable)media -> {
            KBImageMigrator2.$anonfun$processConcept$2(this, c, media);
            return BoxedUnit.UNIT;
        });
    }

    public Option<Path> toTargetPath(Media media) {
        String source = media.getUrl();
        int idx = source.indexOf(this.webpath);
        None$ subpath = idx >= 0 ? new Some((Object)source.substring(this.webpath.length())) : None$.MODULE$;
        return subpath.map((Function1 & Serializable & scala.Serializable)s -> $this.target.resolve((String)s));
    }

    public Option<BufferedImage> waterwark(Media media, BufferedImage overlay) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            BufferedImage image = ImageIO.read(new URL(media.getUrl()));
            return WatermarkUtilities$.MODULE$.addWatermarkImage(image, $this.overlayImage, $this.overlayPercentWidth);
        }).toOption();
    }

    public byte[] addExif(Concept concept, BufferedImage image, Option<String> credit) {
        byte[] jpegBytes = WatermarkUtilities$.MODULE$.toJpegByteArray(image);
        TiffOutputSet outputSet = WatermarkUtilities$.MODULE$.getOrCreateOutputSet(jpegBytes);
        credit.foreach((Function1 & Serializable & scala.Serializable)s -> {
            KBImageMigrator2.$anonfun$addExif$1(outputSet, s);
            return BoxedUnit.UNIT;
        });
        TiffOutputDirectory rootDirectory = outputSet.getOrCreateRootDirectory();
        rootDirectory.removeField((TagInfo)TiffTagConstants.TIFF_TAG_COPYRIGHT);
        rootDirectory.add(TiffTagConstants.TIFF_TAG_COPYRIGHT, new String[]{new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Copyright ", " Monterey Bay Aquarium Research Institute"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.yearFormat.format(this.now)}))});
        rootDirectory.removeField((TagInfo)TiffTagConstants.TIFF_TAG_IMAGE_DESCRIPTION);
        rootDirectory.add(TiffTagConstants.TIFF_TAG_IMAGE_DESCRIPTION, new String[]{new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Representative image for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{concept.getPrimaryConceptName().getName()}))});
        return WatermarkUtilities$.MODULE$.addExifAsJPG(jpegBytes, outputSet);
    }

    public byte[] addText(Concept concept, BufferedImage image, Option<String> credit) {
        Map text = ((MapLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Description"), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Representative image for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{concept.getPrimaryConceptName().getName()}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Copyright"), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Copyright ", " Monterey Bay Aquarium Research Institute"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.yearFormat.format(this.now)})))}))).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(credit.map((Function1 & Serializable & scala.Serializable)x$2 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Source"), x$2))));
        return WatermarkUtilities$.MODULE$.addMetadataAsPNG(image, (Map<String, String>)text);
    }

    public static final /* synthetic */ boolean $anonfun$processConcept$1(Media x$1) {
        String string = x$1.getType();
        String string2 = "Image";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$processConcept$4(KBImageMigrator2 $this, Concept c$1, Media media$2, Path path$1, BufferedImage image) {
        Object object = !Files.exists(path$1.getParent(), new LinkOption[0]) ? Files.createDirectories(path$1.getParent(), new FileAttribute[0]) : BoxedUnit.UNIT;
        try {
            byte[] bytes = ((Object)path$1.getFileName()).toString().toLowerCase().endsWith(".png") ? $this.addText(c$1, image, (Option<String>)Option$.MODULE$.apply((Object)media$2.getCredit())) : $this.addExif(c$1, image, (Option<String>)Option$.MODULE$.apply((Object)media$2.getCredit()));
            BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(path$1.toFile()));
            os.write(bytes);
            os.close();
        }
        catch (Exception e) {
            $this.log.info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to write ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path$1})), (Throwable)e);
        }
    }

    public static final /* synthetic */ void $anonfun$processConcept$3(KBImageMigrator2 $this, Concept c$1, Media media$2, Path path) {
        $this.waterwark(media$2, $this.overlayImage).foreach((Function1 & Serializable & scala.Serializable)image -> {
            KBImageMigrator2.$anonfun$processConcept$4($this, c$1, media$2, path, image);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$processConcept$2(KBImageMigrator2 $this, Concept c$1, Media media) {
        $this.toTargetPath(media).foreach((Function1 & Serializable & scala.Serializable)path -> {
            KBImageMigrator2.$anonfun$processConcept$3($this, c$1, media, path);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$addExif$1(TiffOutputSet outputSet$1, String s) {
        TiffOutputDirectory exifDirectory = outputSet$1.getOrCreateExifDirectory();
        exifDirectory.removeField((TagInfo)ExifTagConstants.EXIF_TAG_USER_COMMENT);
        exifDirectory.add(ExifTagConstants.EXIF_TAG_USER_COMMENT, s);
    }

    public KBImageMigrator2(Path target, URL overlayImageURL, String webpath, double overlayPercentWidth, ToolBelt toolBelt) {
        this.target = target;
        this.webpath = webpath;
        this.overlayPercentWidth = overlayPercentWidth;
        this.log = LoggerFactory.getLogger(this.getClass());
        this.conceptDao = toolBelt.getKnowledgebaseDAOFactory().newConceptDAO();
        this.yearFormat = new SimpleDateFormat("yyyy");
        this.now = new Date();
        this.overlayImage = ImageIO.read(overlayImageURL);
    }
}

