/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vars.varspub;

import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.Serializable;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import javax.imageio.ImageIO;
import org.apache.commons.imaging.common.RationalNumber;
import org.apache.commons.imaging.formats.tiff.constants.ExifTagConstants;
import org.apache.commons.imaging.formats.tiff.constants.GpsTagConstants;
import org.apache.commons.imaging.formats.tiff.constants.TiffEpTagConstants;
import org.apache.commons.imaging.formats.tiff.constants.TiffTagConstants;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfo;
import org.apache.commons.imaging.formats.tiff.write.TiffOutputDirectory;
import org.apache.commons.imaging.formats.tiff.write.TiffOutputSet;
import org.mbari.vars.varspub.AnnoImageMigrator2$;
import org.mbari.vars.varspub.ExifInfo;
import org.mbari.vars.varspub.WatermarkUtilities$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Set$;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import vars.annotation.CameraData;
import vars.annotation.CameraDataDAO;
import vars.annotation.PhysicalData;
import vars.annotation.VideoArchive;
import vars.annotation.VideoArchiveSet;
import vars.annotation.VideoFrame;
import vars.annotation.ui.ToolBelt;

@ScalaSignature(bytes="\u0006\u0001\u0005uf\u0001B\u0001\u0003\u0001-\u0011!#\u00118o_&k\u0017mZ3NS\u001e\u0014\u0018\r^8se)\u00111\u0001B\u0001\bm\u0006\u00148\u000f];c\u0015\t)a!\u0001\u0003wCJ\u001c(BA\u0004\t\u0003\u0015i'-\u0019:j\u0015\u0005I\u0011aA8sO\u000e\u00011c\u0001\u0001\r)A\u0011QBE\u0007\u0002\u001d)\u0011q\u0002E\u0001\u0005Y\u0006twMC\u0001\u0012\u0003\u0011Q\u0017M^1\n\u0005Mq!AB(cU\u0016\u001cG\u000f\u0005\u0002\u000e+%\u0011aC\u0004\u0002\t%Vtg.\u00192mK\"A\u0001\u0004\u0001B\u0001B\u0003%\u0011$\u0001\u0004uCJ<W\r\u001e\t\u00035}i\u0011a\u0007\u0006\u00039u\tAAZ5mK*\u0011a\u0004E\u0001\u0004]&|\u0017B\u0001\u0011\u001c\u0005\u0011\u0001\u0016\r\u001e5\t\u0011\t\u0002!\u0011!Q\u0001\n\r\nqb\u001c<fe2\f\u00170S7bO\u0016,&\u000b\u0014\t\u0003I\u001dj\u0011!\n\u0006\u0003MA\t1A\\3u\u0013\tASEA\u0002V%2C\u0001B\u000b\u0001\u0003\u0002\u0003\u0006IaK\u0001\ba\u0006$\bnS3z!\taSG\u0004\u0002.gA\u0011a&M\u0007\u0002_)\u0011\u0001GC\u0001\u0007yI|w\u000e\u001e \u000b\u0003I\nQa]2bY\u0006L!\u0001N\u0019\u0002\rA\u0013X\rZ3g\u0013\t1tG\u0001\u0004TiJLgn\u001a\u0006\u0003iEB\u0001\"\u000f\u0001\u0003\u0002\u0003\u0006IAO\u0001\u0014_Z,'\u000f\\1z!\u0016\u00148-\u001a8u/&$G\u000f\u001b\t\u0003wqj\u0011!M\u0005\u0003{E\u0012a\u0001R8vE2,\u0007\u0002C \u0001\u0005\u0003\u0005\u000b1\u0002!\u0002\u0011Q|w\u000e\u001c\"fYR\u0004\"!Q$\u000e\u0003\tS!a\u0011#\u0002\u0005UL'BA#G\u0003)\tgN\\8uCRLwN\u001c\u0006\u0002\u000b%\u0011\u0001J\u0011\u0002\t)>|GNQ3mi\")!\n\u0001C\u0001\u0017\u00061A(\u001b8jiz\"R\u0001\u0014)R%N#\"!T(\u0011\u00059\u0003Q\"\u0001\u0002\t\u000b}J\u00059\u0001!\t\u000baI\u0005\u0019A\r\t\u000b\tJ\u0005\u0019A\u0012\t\u000f)J\u0005\u0013!a\u0001W!9\u0011(\u0013I\u0001\u0002\u0004Q\u0004BB+\u0001A\u0003%a+A\u0002o_^\u0004\"a\u0016.\u000e\u0003aS!!\u0017\t\u0002\tU$\u0018\u000e\\\u0005\u00037b\u0013A\u0001R1uK\"1Q\f\u0001Q\u0001\ny\u000b1\u0001\\8h!\ty&-D\u0001a\u0015\t\t\u0007\"A\u0003tY\u001a$$.\u0003\u0002dA\n1Aj\\4hKJDa!\u001a\u0001!\u0002\u00131\u0017a\u0004;j[\u0016\u001cH/Y7q\r>\u0014X.\u0019;\u0011\u0005\u001dTW\"\u00015\u000b\u0005%\u0004\u0012\u0001\u0002;fqRL!a\u001b5\u0003!MKW\u000e\u001d7f\t\u0006$XMR8s[\u0006$\bBB7\u0001A\u0003%a-\u0001\u0006zK\u0006\u0014hi\u001c:nCRDaa\u001c\u0001!\u0002\u0013\u0001\u0018\u0001D8wKJd\u0017-_%nC\u001e,\u0007CA9w\u001b\u0005\u0011(BA:u\u0003\u0015IW.Y4f\u0015\t)\b#A\u0002boRL!a\u001e:\u0003\u001b\t+hMZ3sK\u0012LU.Y4f\u0011\u0019I\b\u0001)A\u0005u\u0006\u0011\u0012N\u001c;fe:\fGnQ8o]\u0016\u001cG/[8o!\tYh0D\u0001}\u0015\ti\b#A\u0002tc2L!a ?\u0003\u0015\r{gN\\3di&|g\u000eC\u0004\u0002\u0004\u0001\u0001\u000b\u0011\u0002>\u0002%\u0015DH/\u001a:oC2\u001cuN\u001c8fGRLwN\u001c\u0005\b\u0003\u000f\u0001A\u0011AA\u0005\u0003\r\u0011XO\u001c\u000b\u0003\u0003\u0017\u00012aOA\u0007\u0013\r\ty!\r\u0002\u0005+:LG\u000fC\u0004\u0002\u0014\u0001!I!!\u0006\u0002\u0019Q|G+\u0019:hKR\u0004\u0016\r\u001e5\u0015\r\u0005]\u0011QDA\u0011!\u0011Y\u0014\u0011D\r\n\u0007\u0005m\u0011G\u0001\u0004PaRLwN\u001c\u0005\b\u0003?\t\t\u00021\u0001,\u0003!)\u0007\u0010^3s]\u0006d\u0007bBA\u0012\u0003#\u0001\raK\u0001\tS:$XM\u001d8bY\"9\u0011q\u0005\u0001\u0005\n\u0005%\u0012aB1eI\u0016C\u0018N\u001a\u000b\u0007\u0003W\t9$a\u000f\u0011\u000bm\ni#!\r\n\u0007\u0005=\u0012GA\u0003BeJ\f\u0017\u0010E\u0002<\u0003gI1!!\u000e2\u0005\u0011\u0011\u0015\u0010^3\t\u000f\u0005e\u0012Q\u0005a\u0001W\u0005Y\u0011N\u001c;fe:\fG.\u0016:m\u0011\u0019\u0019\u0018Q\u0005a\u0001a\"9\u0011q\b\u0001\u0005\n\u0005\u0005\u0013A\u00077p_.,\b/T3uC\u0012\fG/\u0019$s_6$\u0015\r^1cCN,G\u0003BA\"\u0003\u0017\u0002RaOA\r\u0003\u000b\u00022ATA$\u0013\r\tIE\u0001\u0002\t\u000bbLg-\u00138g_\"9\u0011\u0011HA\u001f\u0001\u0004Y\u0003bBA(\u0001\u0011%\u0011\u0011K\u0001\b[\u0006\u0004XK\u0015't)\t\t\u0019\u0006\u0005\u0004\u0002V\u0005}\u0013Q\r\b\u0005\u0003/\nYFD\u0002/\u00033J\u0011AM\u0005\u0004\u0003;\n\u0014a\u00029bG.\fw-Z\u0005\u0005\u0003C\n\u0019GA\u0002TKFT1!!\u00182!\u0015Y\u0014qM\u0016,\u0013\r\tI'\r\u0002\u0007)V\u0004H.\u001a\u001a\t\u000f\u00055\u0004\u0001\"\u0003\u0002p\u0005Iq/\u0019;fe6\f'o\u001b\u000b\u0007\u0003c\n\u0019(!\u001e\u0011\tm\nI\u0002\u001d\u0005\u0007g\u0006-\u0004\u0019\u00019\t\u000f\u0005]\u00141\u000ea\u0001a\u00069qN^3sY\u0006LxaBA>\u0005!\u0005\u0011QP\u0001\u0013\u0003:tw.S7bO\u0016l\u0015n\u001a:bi>\u0014(\u0007E\u0002O\u0003\u007f2a!\u0001\u0002\t\u0002\u0005\u00055\u0003BA@\u0003\u0007\u00032aOAC\u0013\r\t9)\r\u0002\u0007\u0003:L(+\u001a4\t\u000f)\u000by\b\"\u0001\u0002\fR\u0011\u0011Q\u0010\u0005\t\u0003\u001f\u000by\b)A\u0005=\u00061An\\4hKJD\u0001\"a%\u0002\u0000\u0011\u0005\u0011QS\u0001\u0005[\u0006Lg\u000e\u0006\u0003\u0002\f\u0005]\u0005\u0002CAM\u0003#\u0003\r!a'\u0002\t\u0005\u0014xm\u001d\t\u0005w\u000552\u0006\u0003\u0006\u0002 \u0006}\u0014\u0013!C\u0001\u0003C\u000b1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u001aTCAARU\rY\u0013QU\u0016\u0003\u0003O\u0003B!!+\u000226\u0011\u00111\u0016\u0006\u0005\u0003[\u000by+A\u0005v]\u000eDWmY6fI*\u0011Q)M\u0005\u0005\u0003g\u000bYKA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D!\"a.\u0002\u0000E\u0005I\u0011AA]\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%iU\u0011\u00111\u0018\u0016\u0004u\u0005\u0015\u0006")
public class AnnoImageMigrator2
implements Runnable {
    private final Path target;
    private final String pathKey;
    private final double overlayPercentWidth;
    private final ToolBelt toolBelt;
    private final Date now;
    private final Logger log;
    private final SimpleDateFormat timestampFormat;
    private final SimpleDateFormat yearFormat;
    private final BufferedImage overlayImage;
    private final Connection internalConnection;
    private final Connection externalConnection;

    public static double $lessinit$greater$default$4() {
        return AnnoImageMigrator2$.MODULE$.$lessinit$greater$default$4();
    }

    public static String $lessinit$greater$default$3() {
        return AnnoImageMigrator2$.MODULE$.$lessinit$greater$default$3();
    }

    public static void main(String[] stringArray) {
        AnnoImageMigrator2$.MODULE$.main(stringArray);
    }

    @Override
    public void run() {
        this.mapURLs().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)AnnoImageMigrator2.$anonfun$run$1(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            AnnoImageMigrator2.$anonfun$run$2(this, x$1);
            return BoxedUnit.UNIT;
        });
    }

    private Option<Path> toTargetPath(String external, String internal) {
        boolean bl;
        Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            URL externalURL = new URL(external);
            return WatermarkUtilities$.MODULE$.imageExistsAt(externalURL);
        });
        if (try_ instanceof Success) {
            boolean a;
            Success success = (Success)try_;
            bl = a = BoxesRunTime.unboxToBoolean((Object)success.value());
        } else if (try_ instanceof Failure) {
            bl = true;
        } else {
            throw new MatchError((Object)try_);
        }
        boolean externalImageExists = bl;
        return externalImageExists ? None$.MODULE$ : (Option)Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Object object;
            int idx = internal.toLowerCase().indexOf($this.pathKey.toLowerCase());
            String[] parts = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])internal.substring(idx + new StringOps(Predef$.MODULE$.augmentString($this.pathKey)).size()).split("/"))).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.replace("%20", " "), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
            Path externalTarget = Paths.get(((Object)$this.target).toString(), parts);
            Path externalDir = externalTarget.getParent();
            if (Files.notExists(externalDir, new LinkOption[0])) {
                $this.log.info("Creating {}", new Object[]{externalDir});
                object = Files.createDirectories(externalDir, new FileAttribute[0]);
            } else {
                object = BoxedUnit.UNIT;
            }
            return new Some((Object)externalTarget);
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> None$.MODULE$);
    }

    private byte[] addExif(String internalUrl, BufferedImage image) {
        byte[] jpegBytes = WatermarkUtilities$.MODULE$.toJpegByteArray(image);
        TiffOutputSet outputSet = WatermarkUtilities$.MODULE$.getOrCreateOutputSet(jpegBytes);
        ExifInfo exifInfo = (ExifInfo)this.lookupMetadataFromDatabase(internalUrl).getOrElse((Function0 & Serializable & scala.Serializable)() -> new ExifInfo("No annotation information is available for this image", $this.now, $this.now, 0.0f, 0.0, 0.0));
        TiffOutputDirectory exifDirectory = outputSet.getOrCreateExifDirectory();
        exifDirectory.removeField((TagInfo)ExifTagConstants.EXIF_TAG_DATE_TIME_ORIGINAL);
        exifDirectory.add(ExifTagConstants.EXIF_TAG_DATE_TIME_ORIGINAL, new String[]{this.timestampFormat.format(exifInfo.dateTimeOriginal())});
        exifDirectory.removeField((TagInfo)ExifTagConstants.EXIF_TAG_DATE_TIME_DIGITIZED);
        exifDirectory.add(ExifTagConstants.EXIF_TAG_DATE_TIME_DIGITIZED, new String[]{this.timestampFormat.format(exifInfo.createDate())});
        exifDirectory.removeField((TagInfo)TiffEpTagConstants.EXIF_TAG_TIME_ZONE_OFFSET);
        exifDirectory.add(TiffEpTagConstants.EXIF_TAG_TIME_ZONE_OFFSET, new short[]{Predef$.MODULE$.int2Integer(0).shortValue()});
        exifDirectory.removeField((TagInfo)ExifTagConstants.EXIF_TAG_USER_COMMENT);
        exifDirectory.add(ExifTagConstants.EXIF_TAG_USER_COMMENT, exifInfo.userComment());
        TiffOutputDirectory rootDirectory = outputSet.getOrCreateRootDirectory();
        rootDirectory.removeField((TagInfo)TiffTagConstants.TIFF_TAG_COPYRIGHT);
        rootDirectory.add(TiffTagConstants.TIFF_TAG_COPYRIGHT, new String[]{new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Copyright ", " Monterey Bay Aquarium Research Institute"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.yearFormat.format(exifInfo.dateTimeOriginal())}))});
        TiffOutputDirectory gpsDirectory = outputSet.getOrCreateGPSDirectory();
        int altAsInt = package$.MODULE$.round(exifInfo.gpsAltitude() * (float)10);
        gpsDirectory.removeField((TagInfo)GpsTagConstants.GPS_TAG_GPS_ALTITUDE);
        gpsDirectory.add(GpsTagConstants.GPS_TAG_GPS_ALTITUDE, new RationalNumber(altAsInt, 10));
        gpsDirectory.removeField((TagInfo)GpsTagConstants.GPS_TAG_GPS_ALTITUDE_REF);
        gpsDirectory.add(GpsTagConstants.GPS_TAG_GPS_ALTITUDE_REF, Predef$.MODULE$.int2Integer(1).byteValue());
        outputSet.setGPSInDegrees(exifInfo.gpsLongitude(), exifInfo.gpsLatitude());
        gpsDirectory.removeField((TagInfo)GpsTagConstants.GPS_TAG_GPS_PROCESSING_METHOD);
        gpsDirectory.add(GpsTagConstants.GPS_TAG_GPS_PROCESSING_METHOD, "MANUAL");
        return WatermarkUtilities$.MODULE$.addExifAsJPG(jpegBytes, outputSet);
    }

    private Option<ExifInfo> lookupMetadataFromDatabase(String internalUrl) {
        CameraDataDAO dao = this.toolBelt.getAnnotationDAOFactory().newCameraDataDAO();
        dao.startTransaction();
        CameraData cd = dao.findByImageReference(internalUrl);
        if (cd == null) {
            dao.endTransaction();
            return None$.MODULE$;
        }
        VideoFrame vf = cd.getVideoFrame();
        PhysicalData pd = vf.getPhysicalData();
        VideoArchive va = vf.getVideoArchive();
        VideoArchiveSet vas = va.getVideoArchiveSet();
        String dives = ((TraversableOnce)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(vas.getCameraDeployments()).asScala()).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.getSequenceNumber(), Set$.MODULE$.canBuildFrom())).mkString(", ");
        Buffer obs = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(vf.getObservations()).asScala();
        dao.endTransaction();
        Date createDate = (Date)Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (Date)((IterableLike)((SeqLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(vf.getObservations()).asScala()).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.getObservationDate(), Buffer$.MODULE$.canBuildFrom())).sortBy((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToLong((long)x$5.getTime()), (Ordering)Ordering.Long$.MODULE$)).head()).getOrElse((Function0 & Serializable & scala.Serializable)() -> $this.now);
        Date dateTimeOriginal = (Date)Option$.MODULE$.apply((Object)vf.getRecordedDate()).getOrElse((Function0 & Serializable & scala.Serializable)() -> $this.now);
        float altitude = BoxesRunTime.unboxToFloat((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcF.sp & Serializable & scala.Serializable)() -> pd.getDepth().floatValue()).getOrElse((Function0)(JFunction0.mcF.sp & Serializable & scala.Serializable)() -> 0.0f));
        double latitude = BoxesRunTime.unboxToDouble((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> pd.getLatitude()).getOrElse((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 0.0));
        double longitude = BoxesRunTime.unboxToDouble((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> pd.getLongitude()).getOrElse((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 0.0));
        float temperature = BoxesRunTime.unboxToFloat((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcF.sp & Serializable & scala.Serializable)() -> pd.getTemperature().floatValue()).getOrElse((Function0)(JFunction0.mcF.sp & Serializable & scala.Serializable)() -> -999.0f));
        float salinity = BoxesRunTime.unboxToFloat((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcF.sp & Serializable & scala.Serializable)() -> pd.getSalinity().floatValue()).getOrElse((Function0)(JFunction0.mcF.sp & Serializable & scala.Serializable)() -> -999.0f));
        float oxygen = BoxesRunTime.unboxToFloat((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcF.sp & Serializable & scala.Serializable)() -> pd.getOxygen().floatValue()).getOrElse((Function0)(JFunction0.mcF.sp & Serializable & scala.Serializable)() -> -999.0f));
        String dateTimeStrForComment = (String)Option$.MODULE$.apply((Object)vf.getRecordedDate()).map((Function1 & Serializable & scala.Serializable)x$6 -> "and time " + $this.timestampFormat.format((Date)x$6)).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        String yearsString = this.yearFormat.format(dateTimeOriginal);
        String createDateStr = this.timestampFormat.format(createDate);
        String dateTimeOriginalStr = this.timestampFormat.format(dateTimeOriginal);
        String conceptStr = ((TraversableOnce)obs.map((Function1 & Serializable & scala.Serializable)o -> {
            String ass = ((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(o.getAssociations()).asScala()).mkString(", ");
            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{o.getConceptName(), ass}));
        }, Buffer$.MODULE$.canBuildFrom())).mkString("'", ",", "'");
        double arg$macro$16 = latitude;
        double arg$macro$17 = longitude;
        float arg$macro$18 = altitude;
        float arg$macro$19 = temperature;
        float arg$macro$20 = salinity;
        float arg$macro$21 = oxygen;
        return Option$.MODULE$.apply((Object)new ExifInfo("Image captured from a video camera mounted on underwater remotely operated " + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"vehicle ", " on dive number ", ". The original MBARI video "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{vas.getPlatformName(), dives})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tape number is ", ". This image is from timecode ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{va.getName(), vf.getTimecode()})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ". The recorded edited location and environmental "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dateTimeStrForComment})) + new StringOps("measurements at time of capture are Lat=%.7f  Lon=%.7f  ").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)arg$macro$16), BoxesRunTime.boxToDouble((double)arg$macro$17)})) + new StringOps("Depth=%.1f m  Temp=%.3f C  Sal=%.3f PSU  ").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToFloat((float)arg$macro$18), BoxesRunTime.boxToFloat((float)arg$macro$19), BoxesRunTime.boxToFloat((float)arg$macro$20)})) + new StringOps("Oxy=%.3f ml/l. The Video Annotation and Reference system annotations for").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToFloat((float)arg$macro$21)})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" this image is/are ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{conceptStr})), createDate, dateTimeOriginal, altitude, latitude, longitude));
    }

    /*
     * WARNING - void declaration
     */
    private Seq<Tuple2<String, String>> mapURLs() {
        void var2_1;
        this.log.info("Starting database lookup");
        ArrayBuffer urls = new ArrayBuffer();
        Statement external = this.externalConnection.createStatement(1003, 1007);
        Statement internal = this.internalConnection.createStatement(1003, 1007);
        ResultSet ers = external.executeQuery(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  id,\n        |  StillImageURL\n        |FROM\n        |  CameraData\n        |WHERE\n        |  StillImageURL LIKE 'http%'\n        |ORDER BY\n        |  id DESC\n      ")).stripMargin());
        while (ers.next()) {
            Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToLong((long)ers.getLong(1)), (Object)ers.getString(2));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            long id = tuple2._1$mcJ$sp();
            String externalURL = (String)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)id), (Object)externalURL);
            Tuple2 tuple23 = tuple22;
            long id2 = tuple23._1$mcJ$sp();
            String externalURL2 = (String)tuple23._2();
            ResultSet irs = internal.executeQuery(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |SELECT\n           |  id,\n           |  StillImageURL\n           |FROM\n           |  CameraData\n           |WHERE\n           |  id = ", "\n        "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)id2)})))).stripMargin());
            Object object = irs.next() ? urls.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)externalURL2), (Object)irs.getString(2))) : BoxedUnit.UNIT;
            irs.close();
        }
        external.close();
        internal.close();
        this.log.info("Finished database lookup");
        return var2_1;
    }

    private Option<BufferedImage> watermark(BufferedImage image, BufferedImage overlay) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> WatermarkUtilities$.MODULE$.addWatermarkImage(image, overlay, $this.overlayPercentWidth)).toOption();
    }

    public static final /* synthetic */ boolean $anonfun$run$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$run$3(String i$1, Path p) {
        return i$1 != null;
    }

    public static final /* synthetic */ void $anonfun$run$5(AnnoImageMigrator2 $this, String i$1, Path p$1, BufferedImage image) {
        byte[] jpegBytes = $this.addExif(i$1, image);
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(p$1.toFile()));
        os.write(jpegBytes);
        os.close();
    }

    public static final /* synthetic */ void $anonfun$run$4(AnnoImageMigrator2 $this, String e$1, String i$1, Path p) {
        try {
            BufferedImage image2 = ImageIO.read(new URL(i$1));
            $this.watermark(image2, $this.overlayImage).foreach((Function1 & Serializable & scala.Serializable)image -> {
                AnnoImageMigrator2.$anonfun$run$5($this, i$1, p, image);
                return BoxedUnit.UNIT;
            });
            $this.log.debug(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Prepped image for external release:\n          | \\tInternal: ", "\n          | \\tExternal: ", "\n          | \\tTarget  : ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{i$1, e$1, p})))).stripMargin());
        }
        catch (Exception e) {
            $this.log.debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to watermark ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{i$1})), (Throwable)e);
        }
    }

    public static final /* synthetic */ void $anonfun$run$2(AnnoImageMigrator2 $this, Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String e = (String)tuple2._1();
        String i = (String)tuple2._2();
        $this.toTargetPath(e, i).withFilter((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)AnnoImageMigrator2.$anonfun$run$3(i, p))).foreach((Function1 & Serializable & scala.Serializable)p -> {
            AnnoImageMigrator2.$anonfun$run$4($this, e, i, p);
            return BoxedUnit.UNIT;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public AnnoImageMigrator2(Path target, URL overlayImageURL, String pathKey, double overlayPercentWidth, ToolBelt toolBelt) {
        this.target = target;
        this.pathKey = pathKey;
        this.overlayPercentWidth = overlayPercentWidth;
        this.toolBelt = toolBelt;
        this.now = new Date();
        this.log = LoggerFactory.getLogger(this.getClass());
        SimpleDateFormat f = new SimpleDateFormat("yyyy:MM:dd HH:mm:ss");
        f.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.timestampFormat = f;
        this.yearFormat = new SimpleDateFormat("yyyy");
        this.overlayImage = ImageIO.read(overlayImageURL);
        this.internalConnection = DriverManager.getConnection("jdbc:jtds:sqlserver://perseus.shore.mbari.org:1433/VARS", "everyone", "guest");
        this.externalConnection = DriverManager.getConnection("jdbc:jtds:sqlserver://dione.mbari.org:1433/VARS", "everyone", "NeWW1stLst");
    }
}

