/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vars.integration;

import com.google.inject.Injector;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vars.ToolBelt;
import vars.annotation.CameraData;
import vars.annotation.CameraDataDAO;
import vars.knowledgebase.ui.StateLookup;

public class UpdateStillImageUrlTool {
    public static final String FILE_PREFIX = "file:";
    public static final byte[] GIF_KEY = new byte[]{71, 73, 70};
    public static final byte[] JPG_KEY = new byte[]{-119, 80, 78};
    public static final byte[] PNG_KEY = new byte[]{-1, -40, -1};
    public static final String SEARCH_KEY = "VARS/data";
    private static final Logger log = LoggerFactory.getLogger(UpdateStillImageUrlTool.class);
    public static String HTTP_PREFIX = "http://search.mbari.org/ARCHIVE/frameGrabs/";
    private static ToolBelt toolBelt;

    private UpdateStillImageUrlTool() {
    }

    public static URL fileUrlToHttpUrl(String fileUrl) throws MalformedURLException {
        int idx;
        URL httpUrl = null;
        if (fileUrl != null && fileUrl.toLowerCase().startsWith(FILE_PREFIX) && (idx = fileUrl.indexOf(SEARCH_KEY)) > -1) {
            idx = idx + SEARCH_KEY.length() + 1;
            String httpString = HTTP_PREFIX + fileUrl.substring(idx);
            httpString = httpString.replaceAll(" ", "%20");
            httpUrl = new URL(httpString);
        }
        return httpUrl;
    }

    public static Collection findFileUrls() {
        CameraDataDAO dao = toolBelt.getAnnotationDAOFactory().newCameraDataDAO();
        List cameraData = dao.findByImageReferencePrefix(FILE_PREFIX);
        dao.close();
        return cameraData;
    }

    public static boolean isImageOnWebServer(URL url) {
        boolean onServer = false;
        if (url != null) {
            byte[] b;
            block4: {
                b = new byte[3];
                try {
                    InputStream in = url.openStream();
                    in.read(b);
                    in.close();
                }
                catch (Exception e) {
                    if (!log.isInfoEnabled()) break block4;
                    log.info("Unable to open the URL, " + url, (Throwable)e);
                }
            }
            if (Arrays.equals(b, PNG_KEY) || Arrays.equals(b, GIF_KEY) || Arrays.equals(b, JPG_KEY)) {
                onServer = true;
            }
        }
        return onServer;
    }

    public static void main(String[] args) {
        try {
            UpdateStillImageUrlTool.updateStillImageUrls();
        }
        catch (Exception e) {
            log.error("Unable to update the still image URLS.", (Throwable)e);
        }
    }

    public static void updateStillImageUrls() {
        Collection cameraDatums = UpdateStillImageUrlTool.findFileUrls();
        for (CameraData cd : cameraDatums) {
            try {
                UpdateStillImageUrlTool.updateUrl(cd);
            }
            catch (MalformedURLException e) {
                log.warn("Failed to update " + cd, (Throwable)e);
            }
        }
    }

    public static void updateUrl(CameraData cameraData) throws MalformedURLException {
        if (cameraData != null) {
            URL newUrl = UpdateStillImageUrlTool.fileUrlToHttpUrl(cameraData.getImageReference());
            if (log.isDebugEnabled()) {
                log.debug("Attempting to update " + cameraData.getImageReference() + " to " + newUrl);
            }
            if (UpdateStillImageUrlTool.isImageOnWebServer(newUrl)) {
                CameraDataDAO dao = toolBelt.getAnnotationDAOFactory().newCameraDataDAO();
                cameraData = (CameraData)dao.find((Object)cameraData);
                dao.startTransaction();
                cameraData.setImageReference(newUrl.toExternalForm());
                dao.endTransaction();
                dao.close();
            }
        }
    }

    static {
        Injector injector = StateLookup.GUICE_INJECTOR;
        toolBelt = (ToolBelt)injector.getInstance(ToolBelt.class);
    }
}

