/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vars.integration;

import com.google.inject.Inject;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.TimeZone;
import org.mbari.expd.Dive;
import org.mbari.expd.DiveDAO;
import org.mbari.sql.DBException;
import org.mbari.sql.QueryFunction;
import org.mbari.sql.QueryableImpl;
import vars.annotation.AnnotationDAOFactory;
import vars.annotation.CameraDeployment;
import vars.annotation.VideoArchiveSet;
import vars.annotation.VideoArchiveSetDAO;
import vars.integration.MergeStatus;
import vars.integration.MergeStatusDAO;

public class MergeStatusDAOImpl
extends QueryableImpl
implements MergeStatusDAO {
    private static final ResourceBundle bundle = ResourceBundle.getBundle("annotation-jdbc", Locale.US);
    public static final DateFormat DATE_FORMAT_UTC = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"){
        {
            this.setTimeZone(TimeZone.getTimeZone("UTC"));
        }
    };
    private static final DateFormat DATE_FORMAT_TRACKINGNUMBER = new SimpleDateFormat("yyyyDDD"){
        {
            this.setTimeZone(TimeZone.getTimeZone("UTC"));
        }
    };
    public static final Calendar CALENDAR = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
    public final QueryFunction<List<Long>> ID_FUNCTION = new QueryFunction<List<Long>>(){

        public List<Long> apply(ResultSet resultSet) throws SQLException {
            ArrayList<Long> ids = new ArrayList<Long>();
            while (resultSet.next()) {
                ids.add(resultSet.getLong(1));
            }
            Collections.sort(ids);
            return ids;
        }
    };
    private final AnnotationDAOFactory annotationDAOFactory;
    private final DiveDAO diveDAO;

    @Inject
    public MergeStatusDAOImpl(AnnotationDAOFactory annotationDAOFactory, DiveDAO diveDAO) {
        super(bundle.getString("jdbc.url"), bundle.getString("jdbc.username"), bundle.getString("jdbc.password"), bundle.getString("jdbc.driver"));
        try {
            Class.forName(bundle.getString("jdbc.driver"));
        }
        catch (ClassNotFoundException ex) {
            throw new DBException("Failed to initialize driver class:" + bundle.getString("jdbc.driver"), (Throwable)ex);
        }
        this.annotationDAOFactory = annotationDAOFactory;
        this.diveDAO = diveDAO;
    }

    @Override
    public MergeStatus find(final Long id) {
        MergeStatus mergeStatus = null;
        if (id != null) {
            String sql = "SELECT ms.MergeDate, ms.IsNavigationEdited, ms.StatusMessage, ms.VideoFrameCount, ms.IsMerged, ms.DateSource FROM EXPDMergeStatus as ms WHERE ms.VideoArchiveSetID_FK = " + id;
            QueryFunction<MergeStatus> queryFunction = new QueryFunction<MergeStatus>(){

                public MergeStatus apply(ResultSet resultSet) throws SQLException {
                    MergeStatus mergeStatus = null;
                    if (resultSet.next()) {
                        mergeStatus = new MergeStatus();
                        mergeStatus.setVideoArchiveSetID(id);
                        mergeStatus.setMergeDate(resultSet.getTimestamp(1, CALENDAR));
                        mergeStatus.setNavigationEdited(resultSet.getInt(2));
                        mergeStatus.setStatusMessage(resultSet.getString(3));
                        mergeStatus.setVideoFrameCount(Long.valueOf(resultSet.getInt(4)));
                        mergeStatus.setMerged(resultSet.getInt(5));
                        mergeStatus.setDateSource(resultSet.getString(6));
                    }
                    return mergeStatus;
                }
            };
            mergeStatus = (MergeStatus)this.executeQueryFunction(sql, (QueryFunction)queryFunction);
        }
        return mergeStatus;
    }

    @Override
    public List<MergeStatus> findAll() {
        String sql = "SELECT ms.VideoArchiveSetID_FK, ms.MergeDate, ms.IsNavigationEdited, ms.StatusMessage, ms.VideoFrameCount, ms.IsMerged, ms.DateSource FROM EXPDMergeStatus AS ms";
        QueryFunction<List<MergeStatus>> queryFunction = new QueryFunction<List<MergeStatus>>(){
            List<MergeStatus> results = new ArrayList<MergeStatus>();

            public List<MergeStatus> apply(ResultSet resultSet) throws SQLException {
                while (resultSet.next()) {
                    MergeStatus mergeStatus = new MergeStatus();
                    mergeStatus.setVideoArchiveSetID(resultSet.getLong(1));
                    mergeStatus.setMergeDate(resultSet.getTimestamp(2, CALENDAR));
                    mergeStatus.setNavigationEdited(resultSet.getInt(3));
                    mergeStatus.setStatusMessage(resultSet.getString(4));
                    mergeStatus.setVideoFrameCount(Long.valueOf(resultSet.getInt(5)));
                    mergeStatus.setMerged(resultSet.getInt(6));
                    mergeStatus.setDateSource(resultSet.getString(7));
                    this.results.add(mergeStatus);
                }
                return this.results;
            }
        };
        return (List)this.executeQueryFunction(sql, (QueryFunction)queryFunction);
    }

    @Override
    public MergeStatus findByPlatformAndSequenceNumber(String platform, Number sequenceNumber) {
        String sql = "SELECT ms.VideoArchiveSetID_FK FROM VideoArchiveSet as vas LEFT OUTER JOIN EXPDMergeStatus as ms ON ms.VideoArchiveSetID_FK = vas.id LEFT OUTER JOIN CameraPlatformDeployment as cpd ON cpd.VideoArchiveSetID_FK = vas.id WHERE vas.PlatformName = '" + platform + "' AND cpd.SeqNumber = " + sequenceNumber;
        List ids = (List)this.executeQueryFunction(sql, this.ID_FUNCTION);
        Long id = ids.size() > 0 ? (Long)ids.get(0) : null;
        MergeStatus mergeStatus = null;
        if (id != null) {
            mergeStatus = this.find(id);
        }
        return mergeStatus;
    }

    @Override
    public List<MergeStatus> findByStatusMessage(String msg) {
        List ids = (List)this.executeQueryFunction("SELECT VideoArchiveSetID_FK FROM EXPDMergeStatus WHERE StatusMessage LIKE '" + msg + "' ORDER BY MergeDate", this.ID_FUNCTION);
        ArrayList<MergeStatus> mergeStatuses = new ArrayList<MergeStatus>(ids.size());
        for (Long id : ids) {
            MergeStatus mergeStatus = this.find(id);
            if (mergeStatus == null) continue;
            mergeStatuses.add(mergeStatus);
        }
        return mergeStatuses;
    }

    @Override
    public List<Long> findFailedSets() {
        return (List)this.executeQueryFunction("SELECT VideoArchiveSetID_FK FROM EXPDMergeStatus WHERE IsMerged = 0", this.ID_FUNCTION);
    }

    @Override
    public List<Long> findSetsWithEditedNav() {
        List mergedWithRawNav = (List)this.executeQueryFunction("SELECT VideoArchiveSetID_FK FROM EXPDMergeStatus WHERE isNavigationEdited = 0", this.ID_FUNCTION);
        ArrayList<Long> good = new ArrayList<Long>();
        VideoArchiveSetDAO dao = this.annotationDAOFactory.newVideoArchiveSetDAO();
        dao.startTransaction();
        for (Long id : mergedWithRawNav) {
            VideoArchiveSet videoArchiveSet = dao.findByPrimaryKey((Object)id);
            if (videoArchiveSet == null) {
                this.log.info("Unable to find VideoArchiveSet with id = " + id + " in the database");
                continue;
            }
            String platform = videoArchiveSet.getPlatformName();
            Integer sequenceNumber = null;
            if (videoArchiveSet.getCameraDeployments().size() != 1) {
                this.log.info(videoArchiveSet + " represents more than one CameraDeployment. Unable to merge it");
                continue;
            }
            sequenceNumber = ((CameraDeployment)videoArchiveSet.getCameraDeployments().iterator().next()).getSequenceNumber();
            Dive dive = this.diveDAO.findByPlatformAndDiveNumber(platform, sequenceNumber);
            if (dive == null || dive.getStartDate() == null || dive.getEndDate() == null) {
                this.log.info("Dive info is not available in EXPD for " + platform + " #" + sequenceNumber);
                continue;
            }
            String sql = "SELECT id FROM CleanRovNavLoad WHERE fileName LIKE '%" + DATE_FORMAT_TRACKINGNUMBER.format(dive.getStartDate()) + platform.substring(0, 1) + "%' AND isLoaded > 0";
            List r = (List)((QueryableImpl)this.diveDAO).executeQueryFunction(sql, this.ID_FUNCTION);
            if (r.size() <= 0) continue;
            good.add(id);
        }
        dao.endTransaction();
        dao.close();
        return good;
    }

    @Override
    public List<Long> findUnmergedSets() {
        return (List)this.executeQueryFunction("SELECT id FROM VideoArchiveSet WHERE id NOT IN (SELECT VideoArchiveSetID_FK FROM EXPDMergeStatus)", this.ID_FUNCTION);
    }

    @Override
    public List<Long> findUpdatedSets() {
        ArrayList<Long> updatedSets = new ArrayList<Long>();
        QueryFunction<Integer> countFunction = new QueryFunction<Integer>(){

            public Integer apply(ResultSet resultSet) throws SQLException {
                return resultSet.next() ? resultSet.getInt(1) : 0;
            }
        };
        List allInMergeStatusTable = (List)this.executeQueryFunction("SELECT VideoArchiveSetID_FK FROM EXPDMergeStatus", this.ID_FUNCTION);
        for (Long id : allInMergeStatusTable) {
            String sql = "SELECT COUNT(VideoArchiveSetID_FK) FROM Annotations WHERE VideoArchiveSetID_FK = " + id + " AND ObservationDate > (SELECT MergeDate FROM EXPDMergeStatus WHERE VideoArchiveSetID_FK = " + id + ")";
            Integer count = (Integer)this.executeQueryFunction(sql, (QueryFunction)countFunction);
            if (count <= 0) continue;
            updatedSets.add(id);
        }
        return updatedSets;
    }

    @Override
    public void update(MergeStatus mergeStatus) {
        if (mergeStatus.getMerged() == null) {
            mergeStatus.setMerged(0);
        }
        MergeStatus storedMergeStatus = mergeStatus.getVideoArchiveSetID() == null ? null : this.find(mergeStatus.getVideoArchiveSetID());
        String sql = null;
        sql = storedMergeStatus != null ? "UPDATE EXPDMergeStatus SET MergeDate = CONVERT(DATETIME, '" + DATE_FORMAT_UTC.format(mergeStatus.getMergeDate()) + "', 120), IsNavigationEdited = " + mergeStatus.getNavigationEdited() + ", StatusMessage = '" + mergeStatus.getStatusMessage() + "', VideoFrameCount = " + mergeStatus.getVideoFrameCount() + ", IsMerged = " + mergeStatus.getMerged() + ", DateSource = '" + mergeStatus.getDateSource() + "' WHERE VideoArchiveSetID_FK = " + mergeStatus.getVideoArchiveSetID() : "INSERT INTO EXPDMergeStatus (VideoArchiveSetID_FK, MergeDate, IsNavigationEdited, StatusMessage, VideoFrameCount, IsMerged, DateSource) VALUES (" + mergeStatus.getVideoArchiveSetID() + ", CONVERT(DATETIME, '" + DATE_FORMAT_UTC.format(mergeStatus.getMergeDate()) + "', 120), " + mergeStatus.getNavigationEdited() + ", '" + mergeStatus.getStatusMessage() + "', " + mergeStatus.getVideoFrameCount() + ", " + mergeStatus.getMerged() + ", '" + mergeStatus.getDateSource() + "')";
        this.executeUpdate(sql);
    }
}

