/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vars.integration;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.TimeZone;
import javax.inject.Inject;
import org.mbari.expd.Dive;
import org.mbari.expd.DiveDAO;
import org.mbari.sql.DBException;
import org.mbari.sql.QueryFunction;
import org.mbari.sql.QueryableImpl;
import vars.annotation.AnnotationDAOFactory;
import vars.annotation.CameraDeployment;
import vars.annotation.VideoArchiveSet;
import vars.annotation.VideoArchiveSetDAO;
import vars.integration.MergeHistory;
import vars.integration.MergeHistoryDAO;

public class MergeHistoryDAOImpl
extends QueryableImpl
implements MergeHistoryDAO {
    private static final String SQL_SELECT_FROM = "SELECT ms.id, ms.VideoArchiveSetID_FK, ms.MergeDate, ms.MergeType, ms.IsNavigationEdited, ms.StatusMessage, ms.VideoFrameCount, ms.DateSource, ms.IsHD FROM EXPDMergeHistory as ms";
    private static final ResourceBundle bundle = ResourceBundle.getBundle("annotation-jdbc", Locale.US);
    private static final QueryFunction<List<MergeHistory>> QUERY_FUNCTION = new QueryFunction<List<MergeHistory>>(){

        public List<MergeHistory> apply(ResultSet resultSet) throws SQLException {
            ArrayList<MergeHistory> mergeHistories = new ArrayList<MergeHistory>();
            while (resultSet.next()) {
                Long id = resultSet.getLong(1);
                Long videoArchiveSetId = resultSet.getLong(2);
                Timestamp mergeDate = resultSet.getTimestamp(3, CALENDAR);
                String mergeType = resultSet.getString(4);
                Boolean navigationEdited = resultSet.getInt(5) != 0;
                String statusMessage = resultSet.getString(6);
                Integer videoFrameCount = resultSet.getInt(7);
                String dateSource = resultSet.getString(8);
                Boolean hd = resultSet.getInt(9) != 0;
                MergeHistory mergeHistory = new MergeHistory(id, videoArchiveSetId, mergeDate, mergeType, navigationEdited, statusMessage, videoFrameCount, dateSource, hd);
                mergeHistories.add(mergeHistory);
            }
            return mergeHistories;
        }
    };
    public static final DateFormat DATE_FORMAT_UTC = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"){
        {
            this.setTimeZone(TimeZone.getTimeZone("UTC"));
        }
    };
    private static final DateFormat DATE_FORMAT_TRACKINGNUMBER = new SimpleDateFormat("yyyyDDD"){
        {
            this.setTimeZone(TimeZone.getTimeZone("UTC"));
        }
    };
    public static final Calendar CALENDAR = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
    public final QueryFunction<List<Long>> ID_FUNCTION = new QueryFunction<List<Long>>(){

        public List<Long> apply(ResultSet resultSet) throws SQLException {
            ArrayList<Long> ids = new ArrayList<Long>();
            while (resultSet.next()) {
                ids.add(resultSet.getLong(1));
            }
            Collections.sort(ids);
            return ids;
        }
    };
    private final AnnotationDAOFactory annotationDAOFactory;
    private final DiveDAO diveDAO;

    @Inject
    public MergeHistoryDAOImpl(AnnotationDAOFactory annotationDAOFactory, DiveDAO diveDAO) {
        super(bundle.getString("jdbc.url"), bundle.getString("jdbc.username"), bundle.getString("jdbc.password"), bundle.getString("jdbc.driver"));
        this.annotationDAOFactory = annotationDAOFactory;
        this.diveDAO = diveDAO;
        try {
            Class.forName(bundle.getString("jdbc.driver"));
        }
        catch (ClassNotFoundException ex) {
            throw new DBException("Failed to initialize driver class:" + bundle.getString("jdbc.driver"), (Throwable)ex);
        }
    }

    @Override
    public List<MergeHistory> find(Long videoArchiveSetId, boolean isHD) {
        int hd;
        int n = hd = isHD ? 1 : 0;
        if (videoArchiveSetId != null) {
            String sql = "SELECT ms.id, ms.VideoArchiveSetID_FK, ms.MergeDate, ms.MergeType, ms.IsNavigationEdited, ms.StatusMessage, ms.VideoFrameCount, ms.DateSource, ms.IsHD FROM EXPDMergeHistory as ms WHERE ms.VideoArchiveSetID_FK = " + videoArchiveSetId + "AND IsHD = " + hd + " ORDER BY MergeDate DESC";
            return (List)this.executeQueryFunction(sql, QUERY_FUNCTION);
        }
        return new ArrayList<MergeHistory>();
    }

    @Override
    public List<MergeHistory> findAllMostRecent(boolean isHD) {
        int hd = isHD ? 1 : 0;
        String sql = "SELECT m.id, m.VideoArchiveSetID_FK, m.MergeDate FROM EXPDMergeHistory m INNER JOIN (SELECT max(mergeDate) AS LatestDate, VideoArchiveSetID_FK  FROM EXPDMergeHistory GROUP BY VideoArchiveSetID_FK) d ON m.MergeDate = d.LatestDate AND m.VideoArchiveSetID_FK = d.VideoArchiveSetID_FK WHERE IsHD = " + hd + " ORDER BY m.MergeDate DESC";
        List ids = (List)this.executeQueryFunction(sql, this.ID_FUNCTION);
        ArrayList<MergeHistory> histories = new ArrayList<MergeHistory>(ids.size());
        for (Long id : ids) {
            sql = "SELECT ms.id, ms.VideoArchiveSetID_FK, ms.MergeDate, ms.MergeType, ms.IsNavigationEdited, ms.StatusMessage, ms.VideoFrameCount, ms.DateSource, ms.IsHD FROM EXPDMergeHistory as ms WHERE ms.id = " + id;
            histories.addAll((Collection)this.executeQueryFunction(sql, QUERY_FUNCTION));
        }
        return histories;
    }

    @Override
    public List<MergeHistory> findByPlatformAndSequenceNumber(String platform, Number sequenceNumber, boolean isHD) {
        Long id;
        int hd = isHD ? 1 : 0;
        String sql = "SELECT ms.VideoArchiveSetID_FK FROM VideoArchiveSet as vas LEFT OUTER JOIN EXPDMergeHistory as ms ON ms.VideoArchiveSetID_FK = vas.id LEFT OUTER JOIN CameraPlatformDeployment as cpd ON cpd.VideoArchiveSetID_FK = vas.id WHERE vas.PlatformName = '" + platform + "' AND cpd.SeqNumber = " + sequenceNumber + " AND IsHD = " + hd;
        List ids = (List)this.executeQueryFunction(sql, this.ID_FUNCTION);
        Long l = id = ids.size() > 0 ? (Long)ids.get(0) : null;
        if (id == null) {
            return new ArrayList<MergeHistory>();
        }
        return this.find(id, isHD);
    }

    @Override
    public MergeHistory findMostRecent(Long videoArchiveSetId, boolean isHD) {
        List<MergeHistory> mergeHistories = this.find(videoArchiveSetId, isHD);
        if (mergeHistories.isEmpty()) {
            return null;
        }
        return mergeHistories.get(0);
    }

    @Override
    public List<Long> findSetsWithEditedNav() {
        List<MergeHistory> allHistories = this.findAllMostRecent(true);
        allHistories.addAll(this.findAllMostRecent(false));
        ArrayList<Long> mergedWithRawNav = new ArrayList<Long>();
        for (MergeHistory history : allHistories) {
            if (history.isNavigationEdited().booleanValue()) continue;
            mergedWithRawNav.add(history.getVideoArchiveSetID());
        }
        this.log.debug("Found " + mergedWithRawNav.size() + " MergeHistories that used raw navigation");
        ArrayList<Long> good = new ArrayList<Long>();
        VideoArchiveSetDAO dao = this.annotationDAOFactory.newVideoArchiveSetDAO();
        dao.startTransaction();
        for (Long id : mergedWithRawNav) {
            VideoArchiveSet videoArchiveSet = dao.findByPrimaryKey((Object)id);
            if (videoArchiveSet == null) {
                this.log.info("Unable to find VideoArchiveSet with id = " + id + " in the database");
                continue;
            }
            String platform = videoArchiveSet.getPlatformName();
            Integer sequenceNumber = null;
            if (videoArchiveSet.getCameraDeployments().size() != 1) {
                this.log.info(videoArchiveSet + " represents more than one CameraDeployment. Unable to merge it");
                continue;
            }
            sequenceNumber = ((CameraDeployment)videoArchiveSet.getCameraDeployments().iterator().next()).getSequenceNumber();
            Dive dive = this.diveDAO.findByPlatformAndDiveNumber(platform, sequenceNumber);
            if (dive == null || dive.getStartDate() == null || dive.getEndDate() == null) {
                this.log.info("Dive info is not available in EXPD for " + platform + " #" + sequenceNumber);
                continue;
            }
            String sql = "SELECT id FROM CleanRovNavLoad WHERE fileName LIKE '%" + DATE_FORMAT_TRACKINGNUMBER.format(dive.getStartDate()) + platform.substring(0, 1) + "%' AND isLoaded > 0";
            List r = (List)((QueryableImpl)this.diveDAO).executeQueryFunction(sql, this.ID_FUNCTION);
            if (r.size() <= 0) continue;
            good.add(id);
        }
        dao.endTransaction();
        dao.close();
        return good;
    }

    @Override
    public List<Long> findUnmergedSets() {
        return (List)this.executeQueryFunction("SELECT id FROM VideoArchiveSet WHERE id NOT IN (SELECT VideoArchiveSetID_FK FROM EXPDMergeHistory)", this.ID_FUNCTION);
    }

    @Override
    public List<Long> findUpdatedSets() {
        List<MergeHistory> recentHistories = this.findAllMostRecent(true);
        recentHistories.addAll(this.findAllMostRecent(false));
        QueryFunction<Integer> countFunction = new QueryFunction<Integer>(){

            public Integer apply(ResultSet resultSet) throws SQLException {
                return resultSet.next() ? resultSet.getInt(1) : 0;
            }
        };
        ArrayList<Long> updatedSets = new ArrayList<Long>();
        for (MergeHistory history : recentHistories) {
            Long id = history.getVideoArchiveSetID();
            String sql = "SELECT COUNT(VideoArchiveSetID_FK) FROM Annotations WHERE VideoArchiveSetID_FK = " + id + " AND ObservationDate > (SELECT MAX(MergeDate) FROM EXPDMergeHistory WHERE VideoArchiveSetID_FK = " + id + ")";
            Integer count = (Integer)this.executeQueryFunction(sql, (QueryFunction)countFunction);
            if (count <= 0) continue;
            updatedSets.add(id);
        }
        return updatedSets;
    }

    @Override
    public void update(MergeHistory mergeHistory) {
        int navEdited = mergeHistory.isNavigationEdited() != false ? 1 : 0;
        int isHD = mergeHistory.isHd() != false ? 1 : 0;
        String sql = "INSERT INTO EXPDMergeHistory (VideoArchiveSetID_FK, MergeDate, MergeType, IsNavigationEdited, StatusMessage, VideoFrameCount, DateSource, IsHD) VALUES (" + mergeHistory.getVideoArchiveSetID() + ", CONVERT(DATETIME, '" + DATE_FORMAT_UTC.format(mergeHistory.getMergeDate()) + "', 120), '" + mergeHistory.getMergeType() + "', " + navEdited + ", '" + mergeHistory.getStatusMessage() + "', " + mergeHistory.getVideoFrameCount() + ", '" + mergeHistory.getDateSource() + "', " + isHD + ")";
        this.executeUpdate(sql);
    }
}

