/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vars.integration;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.inject.Injector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.mbari.expd.CameraDatum;
import org.mbari.expd.CtdDatum;
import org.mbari.expd.Dive;
import org.mbari.expd.DiveDAO;
import org.mbari.expd.NavigationDatum;
import org.mbari.expd.NavigationDatumDAO;
import org.mbari.expd.UberDatum;
import org.mbari.expd.UberDatumDAO;
import org.mbari.expd.actions.CollateByAlternateTimecodeFunction;
import org.mbari.expd.actions.CollateByDateFunction;
import org.mbari.expd.actions.CollateByTimecodeFunction;
import org.mbari.expd.jdbc.DAOFactoryImpl;
import org.mbari.expd.jdbc.UberDatumImpl;
import org.mbari.vars.integration.MergeHistoryDAOImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vars.DAO;
import vars.VideoMoment;
import vars.annotation.AnnotationDAOFactory;
import vars.annotation.CameraData;
import vars.annotation.PhysicalData;
import vars.annotation.VideoArchive;
import vars.annotation.VideoArchiveSet;
import vars.annotation.VideoArchiveSetDAO;
import vars.annotation.VideoFrame;
import vars.annotation.ui.StateLookup;
import vars.integration.MergeFunction;
import vars.integration.MergeHistory;
import vars.integration.MergeType;

public class MergeEXPDAnnotations
implements MergeFunction<Map<VideoFrame, UberDatum>> {
    private final double offsetSecs = 7.5;
    public final Logger log = LoggerFactory.getLogger(this.getClass());
    private Dive dive;
    private MergeHistory mergeHistory = new MergeHistory();
    private final String platform;
    private final int sequenceNumber;
    private Collection<UberDatum> uberData;
    private final boolean useHD;
    private Collection<VideoFrame> videoFrames;

    public MergeEXPDAnnotations(String platform, int sequenceNumber, boolean useHD) {
        this.platform = platform;
        this.sequenceNumber = sequenceNumber;
        this.useHD = useHD;
    }

    @Override
    public Map<VideoFrame, UberDatum> apply(MergeType mergeType) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Applying " + (Object)((Object)mergeType) + " merge to " + this.platform + " #" + this.sequenceNumber + " [use HD = " + this.useHD + "]");
        }
        this.fetch();
        Object data = this.coallate(mergeType);
        this.update((Map<VideoFrame, UberDatum>)data, mergeType);
        return data;
    }

    @Override
    public Map<VideoFrame, UberDatum> coallate(MergeType mergeType) {
        this.fetch();
        Map<VideoFrame, UberDatum> data = new HashMap<VideoFrame, UberDatum>();
        switch (mergeType) {
            case CONSERVATIVE: {
                data = this.coallateConservative();
                break;
            }
            case OPTIMISTIC: {
                data = this.coallateOptimistic();
                break;
            }
            case PESSIMISTIC: {
                data = this.coallatePessimistic();
                break;
            }
            case PRAGMATIC: {
                data = this.coallatePragmatic();
            }
        }
        return data;
    }

    private Map<VideoFrame, UberDatum> coallateConservative() {
        Map<VideoFrame, UberDatum> merged = this.mergeByDate(this.videoFrames, this.uberData);
        ArrayList<VideoFrame> leftovers = new ArrayList<VideoFrame>(this.videoFrames);
        leftovers.removeAll(merged.keySet());
        if (leftovers.size() > 0) {
            merged.putAll(this.mergeByTimecode(leftovers, this.uberData));
        }
        return merged;
    }

    private Map<VideoFrame, UberDatum> coallateOptimistic() {
        return this.mergeByDate(this.videoFrames, this.uberData);
    }

    private Map<VideoFrame, UberDatum> coallatePessimistic() {
        return this.mergeByTimecode(this.videoFrames, this.uberData);
    }

    private Map<VideoFrame, UberDatum> coallatePragmatic() {
        List<VideoFrame> bogusDates = this.videoFrames.stream().filter(input -> {
            Date date = input.getRecordedDate();
            return date == null || date.before(this.dive.getStartDate()) || date.after(this.dive.getEndDate());
        }).collect(Collectors.toList());
        this.log.debug(Joiner.on((String)", ").join(bogusDates));
        ArrayList<VideoFrame> leftovers = new ArrayList<VideoFrame>(this.videoFrames);
        Map<Object, Object> merged = new HashMap();
        try {
            merged = this.mergeByTimecode(bogusDates, this.uberData);
            leftovers.removeAll(merged.keySet());
        }
        catch (Exception e) {
            this.log.warn("Failed to merge " + bogusDates.size() + " annotations with bad dates by timecode", (Throwable)e);
            leftovers.remove(bogusDates);
        }
        if (leftovers.size() > 0) {
            merged.putAll(this.mergeByDate(leftovers, this.uberData));
        }
        return merged;
    }

    private void fetch() {
        if (this.uberData == null) {
            this.uberData = this.fetchExpdData();
        }
        if (this.videoFrames == null) {
            this.videoFrames = this.fetchVarsData();
        }
    }

    private List<UberDatum> fetchExpdData() {
        DAOFactoryImpl daoFactory = new DAOFactoryImpl();
        DiveDAO diveDAO = daoFactory.newDiveDAO();
        this.dive = diveDAO.findByPlatformAndDiveNumber(this.platform, Integer.valueOf(this.sequenceNumber));
        UberDatumDAO uberDatumDAO = daoFactory.newUberDatumDAO();
        List uberData = uberDatumDAO.fetchData(this.dive, this.useHD, 7.5);
        if (uberData.size() == 0) {
            NavigationDatumDAO navigationDatumDAO = daoFactory.newNavigationDatumDAO();
            List navigationData = navigationDatumDAO.fetchBestNavigationData(this.dive);
            uberData.addAll(Collections2.transform((Collection)navigationData, (Function)new Function<NavigationDatum, UberDatum>(){

                public UberDatum apply(NavigationDatum from) {
                    return new UberDatumImpl(null, from, null);
                }
            }));
        }
        return uberData;
    }

    private List<VideoFrame> fetchVarsData() {
        Injector injector = StateLookup.GUICE_INJECTOR;
        AnnotationDAOFactory annotationDAOFactory = (AnnotationDAOFactory)injector.getInstance(AnnotationDAOFactory.class);
        VideoArchiveSetDAO videoArchiveSetDAO = annotationDAOFactory.newVideoArchiveSetDAO();
        ArrayList<VideoFrame> myVideoFrames = new ArrayList<VideoFrame>();
        videoArchiveSetDAO.startTransaction();
        Collection videoArchiveSets = videoArchiveSetDAO.findAllByPlatformAndSequenceNumber(this.platform, this.sequenceNumber);
        for (VideoArchiveSet videoArchiveSet : videoArchiveSets) {
            for (VideoArchive videoArchive : videoArchiveSet.getVideoArchives()) {
                if (this.useHD && videoArchive.getName().toUpperCase().endsWith("HD")) {
                    myVideoFrames.addAll(videoArchive.getVideoFrames());
                    continue;
                }
                if (this.useHD || videoArchive.getName().toUpperCase().endsWith("HD")) continue;
                myVideoFrames.addAll(videoArchive.getVideoFrames());
            }
        }
        videoArchiveSetDAO.endTransaction();
        videoArchiveSetDAO.close();
        if (myVideoFrames.size() == 0) {
            this.mergeHistory.setStatusMessage(this.mergeHistory.getStatusMessage() + "; No annotations found in VARS");
        }
        return myVideoFrames;
    }

    public MergeHistory getMergeHistory() {
        return this.mergeHistory;
    }

    private Map<VideoFrame, UberDatum> mergeByDate(Collection<VideoFrame> vfc, Collection<UberDatum> udc) {
        CollateByDateFunction f1 = new CollateByDateFunction();
        List d = vfc.stream().map(VideoMoment::getRecordedDate).collect(Collectors.toList());
        Map r1 = f1.apply(d, udc, 7000L);
        LinkedHashMap<VideoFrame, UberDatum> out = new LinkedHashMap<VideoFrame, UberDatum>();
        for (VideoFrame videoFrame : vfc) {
            UberDatum uberDatum = (UberDatum)r1.get(videoFrame.getRecordedDate());
            if (uberDatum == null) continue;
            out.put(videoFrame, uberDatum);
        }
        return out;
    }

    private Map<VideoFrame, UberDatum> mergeByTimecode(Collection<VideoFrame> vfc, Collection<UberDatum> udc) {
        CollateByAlternateTimecodeFunction f2 = this.useHD ? new CollateByAlternateTimecodeFunction() : new CollateByTimecodeFunction();
        List d = vfc.stream().map(VideoMoment::getTimecode).collect(Collectors.toList());
        Map r2 = f2.apply(d, udc, 7000L);
        LinkedHashMap<VideoFrame, UberDatum> out = new LinkedHashMap<VideoFrame, UberDatum>();
        for (VideoFrame videoFrame : vfc) {
            UberDatum uberDatum = (UberDatum)r2.get(videoFrame.getTimecode());
            if (uberDatum == null) continue;
            out.put(videoFrame, uberDatum);
        }
        return out;
    }

    @Override
    public void update(Map<VideoFrame, UberDatum> data, MergeType mergeType) {
        this.fetch();
        this.mergeHistory.setMergeDate(new Date());
        this.mergeHistory.setStatusMessage("Using " + (Object)((Object)mergeType) + " merge");
        Injector injector = StateLookup.GUICE_INJECTOR;
        AnnotationDAOFactory annotationDAOFactory = (AnnotationDAOFactory)injector.getInstance(AnnotationDAOFactory.class);
        DAO dao = annotationDAOFactory.newDAO();
        dao.startTransaction();
        int fixedDateCount = 0;
        int badCameraDataCount = 0;
        int badCtdDataCount = 0;
        int badNavDataCount = 0;
        for (VideoFrame videoFrame : data.keySet()) {
            UberDatum uberDatum = data.get(videoFrame);
            String nav = uberDatum.getNavigationDatum() == null ? "NO Navigation Data" : uberDatum.getNavigationDatum().getDate() + " : Depth = " + uberDatum.getNavigationDatum().getDepth();
            String cam = uberDatum.getCameraDatum() == null ? "NO Camera Data" : uberDatum.getCameraDatum().getTimecode() + " - " + uberDatum.getCameraDatum().getAlternativeTimecode() + " - " + uberDatum.getCameraDatum().getDate();
            String vf = videoFrame.getRecordedDate() == null ? "MISSING" : videoFrame.getRecordedDate().toInstant().toString();
            this.log.debug(videoFrame.getTimecode() + " : " + vf + " :NAV: " + nav + " :CAM: " + cam);
            VideoFrame videoFrame2 = (VideoFrame)dao.find((Object)videoFrame);
            if (this.mergeHistory.getVideoArchiveSetID() == null || this.mergeHistory.getVideoArchiveSetID() < 0L) {
                this.mergeHistory.setVideoArchiveSetID((Long)videoFrame2.getVideoArchive().getVideoArchiveSet().getPrimaryKey());
            }
            Date recordedDate = videoFrame2.getRecordedDate();
            CameraData cameraData = videoFrame2.getCameraData();
            CameraDatum cameraDatum = uberDatum.getCameraDatum();
            if (cameraDatum != null) {
                cameraData.setFocus(cameraDatum.getFocus() == null ? null : Integer.valueOf(Math.round(cameraDatum.getFocus().floatValue())));
                cameraData.setLogDate(cameraDatum.getDate());
                if (this.useHD) {
                    videoFrame2.setAlternateTimecode(cameraDatum.getTimecode());
                } else {
                    videoFrame2.setAlternateTimecode(cameraDatum.getAlternativeTimecode());
                }
                cameraData.setZoom(cameraDatum.getZoom() == null ? null : Integer.valueOf(Math.round(cameraDatum.getZoom().floatValue())));
                cameraData.setIris(cameraDatum.getIris() == null ? null : Integer.valueOf(Math.round(cameraDatum.getIris().floatValue())));
            } else {
                this.log.debug("No camera data was found in EXPD for {}", (Object)videoFrame2);
                cameraData.setFocus(null);
                cameraData.setZoom(null);
                cameraData.setIris(null);
                cameraData.setLogDate(null);
                ++badCameraDataCount;
            }
            PhysicalData physicalData = videoFrame2.getPhysicalData();
            CtdDatum ctdDatum = uberDatum.getCtdDatum();
            if (ctdDatum != null) {
                physicalData.setLight(ctdDatum.getLightTransmission());
                physicalData.setOxygen(ctdDatum.getOxygen());
                physicalData.setSalinity(ctdDatum.getSalinity());
                physicalData.setTemperature(ctdDatum.getTemperature());
            } else {
                this.log.debug("No CTD data was found in EXPD for {}", (Object)videoFrame2);
                physicalData.setLight(null);
                physicalData.setOxygen(null);
                physicalData.setSalinity(null);
                physicalData.setTemperature(null);
                ++badCtdDataCount;
            }
            NavigationDatum navigationDatum = uberDatum.getNavigationDatum();
            if (navigationDatum != null) {
                physicalData.setDepth(navigationDatum.getDepth());
                physicalData.setLatitude(navigationDatum.getLatitude());
                physicalData.setLogDate(navigationDatum.getDate());
                physicalData.setLongitude(navigationDatum.getLongitude());
            } else {
                this.log.debug("No navigation data was found in EXPD for {}", (Object)videoFrame2);
                physicalData.setDepth(null);
                physicalData.setLatitude(null);
                physicalData.setLogDate(null);
                physicalData.setLongitude(null);
                ++badNavDataCount;
            }
            Date date = null;
            switch (mergeType) {
                case PESSIMISTIC: {
                    this.mergeHistory.setDateSource("EXPD");
                    if (navigationDatum != null) {
                        date = navigationDatum.getDate();
                    }
                    if (date == null && cameraDatum != null) {
                        date = cameraDatum.getDate();
                    }
                    if (recordedDate != null && recordedDate.equals(date)) break;
                    videoFrame2.setRecordedDate(date);
                    ++fixedDateCount;
                    break;
                }
                case PRAGMATIC: {
                    if (recordedDate != null && !recordedDate.before(this.dive.getStartDate()) && !recordedDate.after(this.dive.getEndDate())) break;
                    if (navigationDatum != null) {
                        date = navigationDatum.getDate();
                    }
                    if (date == null && cameraDatum != null) {
                        date = cameraDatum.getDate();
                    }
                    videoFrame2.setRecordedDate(date);
                    ++fixedDateCount;
                }
            }
        }
        if (MergeType.PESSIMISTIC == mergeType) {
            ArrayList<VideoFrame> unmerged = new ArrayList<VideoFrame>(this.videoFrames);
            unmerged.removeAll(data.keySet());
            for (VideoFrame videoFrame : unmerged) {
                videoFrame = (VideoFrame)dao.find((Object)videoFrame);
                videoFrame.setRecordedDate(null);
            }
        }
        dao.endTransaction();
        dao.close();
        Collection rawNavRecords = Collections2.filter(data.values(), (Predicate)new Predicate<UberDatum>(){

            public boolean apply(UberDatum input) {
                NavigationDatum nav = input.getNavigationDatum();
                return nav != null && nav.isEdited() == Boolean.FALSE;
            }
        });
        switch (mergeType) {
            case PESSIMISTIC: {
                this.mergeHistory.setDateSource("EXPD");
                break;
            }
            default: {
                this.mergeHistory.setDateSource("VARS");
            }
        }
        if (fixedDateCount > 0) {
            this.mergeHistory.setDateSource("Both");
            this.mergeHistory.setStatusMessage(this.mergeHistory.getStatusMessage() + "; Fixed " + fixedDateCount + " annotation dates");
        }
        if (badCameraDataCount > 0) {
            this.mergeHistory.setStatusMessage(this.mergeHistory.getStatusMessage() + "; " + badCameraDataCount + " annotations without camera data");
        }
        if (badCtdDataCount > 0) {
            this.mergeHistory.setStatusMessage(this.mergeHistory.getStatusMessage() + "; " + badCtdDataCount + " annotations without ctd data");
        }
        if (badNavDataCount > 0) {
            this.mergeHistory.setStatusMessage(this.mergeHistory.getStatusMessage() + "; " + badNavDataCount + " annotations without navigation data");
        }
        this.mergeHistory.setHd(this.useHD);
        this.mergeHistory.setMergeType(mergeType.name());
        this.mergeHistory.setNavigationEdited(rawNavRecords.size() == 0);
        this.mergeHistory.setVideoFrameCount(this.videoFrames.size());
        DAOFactoryImpl dAOFactoryImpl = new DAOFactoryImpl();
        DiveDAO diveDAO = dAOFactoryImpl.newDiveDAO();
        MergeHistoryDAOImpl mergeHistoryDAO = new MergeHistoryDAOImpl(annotationDAOFactory, diveDAO);
        if (data.size() > 0) {
            mergeHistoryDAO.update(this.mergeHistory);
        }
    }
}

