/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vars.integration;

import com.google.inject.Injector;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import org.mbari.vars.integration.ImageReferenceFixer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import vars.ToolBelt;
import vars.annotation.CameraData;
import vars.knowledgebase.ui.StateLookup;

public final class ImageReferenceFixer$ {
    public static ImageReferenceFixer$ MODULE$;
    private ToolBelt toolBelt;
    private final String FILE_PREFIX;
    private final byte[] GIF_KEY;
    private final byte[] JPG_KEY;
    private final byte[] PNG_KEY;
    private final Logger log;
    private volatile boolean bitmap$0;

    static {
        new ImageReferenceFixer$();
    }

    public String FILE_PREFIX() {
        return this.FILE_PREFIX;
    }

    public byte[] GIF_KEY() {
        return this.GIF_KEY;
    }

    public byte[] JPG_KEY() {
        return this.JPG_KEY;
    }

    public byte[] PNG_KEY() {
        return this.PNG_KEY;
    }

    private ToolBelt toolBelt$lzycompute() {
        ImageReferenceFixer$ imageReferenceFixer$ = this;
        synchronized (imageReferenceFixer$) {
            if (!this.bitmap$0) {
                Injector injector = StateLookup.GUICE_INJECTOR;
                this.toolBelt = (ToolBelt)injector.getInstance(ToolBelt.class);
                this.bitmap$0 = true;
            }
        }
        return this.toolBelt;
    }

    public ToolBelt toolBelt() {
        return !this.bitmap$0 ? this.toolBelt$lzycompute() : this.toolBelt;
    }

    public Logger log() {
        return this.log;
    }

    public boolean isFileURL(String url) {
        return url != null && url.toLowerCase().startsWith(this.FILE_PREFIX());
    }

    public boolean isImageOnWebServer(URL url) {
        boolean bl;
        if (url != null) {
            byte[] b = new byte[3];
            try {
                InputStream inputStream = url.openStream();
                inputStream.read(b);
                inputStream.close();
            }
            catch (Exception e) {
                this.log().info("Unable to open the URL, " + url, (Throwable)e);
            }
            bl = Arrays.equals(b, this.PNG_KEY()) || Arrays.equals(b, this.JPG_KEY()) || Arrays.equals(b, this.GIF_KEY());
        } else {
            bl = false;
        }
        return bl;
    }

    public void main(String[] args) {
        if (args.length != 1) {
            Predef$.MODULE$.print((Object)"\n                | Usage: ImageReferenceFixer [rootUrl]\n                |\n                | Args: rootUrl = The root url that hosts the images. At MBARI\n                |          it's http://search.mbari.org/ARCHIVE/frameGrabs/\n                    ");
        }
        try {
            this.fix(args[0]);
        }
        catch (Exception e) {
            this.log().error("Unable to update image references", (Throwable)e);
        }
    }

    public void fix(String rootUrl) {
        ImageReferenceFixer fixer = new ImageReferenceFixer(this.toolBelt(), rootUrl);
        List<CameraData> cameraDatas = fixer.findCameraDataWithFileUrls();
        fixer.update(cameraDatas, (Function1 & java.io.Serializable & Serializable)l -> JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(l));
    }

    private ImageReferenceFixer$() {
        MODULE$ = this;
        this.FILE_PREFIX = "file:";
        this.GIF_KEY = (byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{(byte)71, (byte)73, (byte)70}), ClassTag$.MODULE$.Byte());
        this.JPG_KEY = (byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{(byte)137, (byte)80, (byte)78}), ClassTag$.MODULE$.Byte());
        this.PNG_KEY = (byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{(byte)255, (byte)216, (byte)255}), ClassTag$.MODULE$.Byte());
        this.log = LoggerFactory.getLogger(ImageReferenceFixer.class);
    }
}

