/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vars.integration;

import java.io.Serializable;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.Date;
import java.util.TimeZone;
import org.mbari.math.FastCollator$;
import org.mbari.vars.integration.GenericData;
import org.mbari.vars.integration.GenericMerge$;
import org.mbari.vars.integration.NullGenericData$;
import org.mbari.vars.integration.TextParser;
import org.mbari.vars.integration.TextParser$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Try$;
import vars.annotation.AnnotationDAOFactory;
import vars.annotation.PhysicalData;
import vars.annotation.VideoArchive;
import vars.annotation.VideoArchiveDAO;
import vars.annotation.VideoFrame;
import vars.annotation.VideoFrameDAO;

@ScalaSignature(bytes="\u0006\u0001\u0005Mg\u0001B\u0001\u0003\u0001-\u0011AbR3oKJL7-T3sO\u0016T!a\u0001\u0003\u0002\u0017%tG/Z4sCRLwN\u001c\u0006\u0003\u000b\u0019\tAA^1sg*\u0011q\u0001C\u0001\u0006[\n\f'/\u001b\u0006\u0002\u0013\u0005\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\u0004\t\u0003\u001bAi\u0011A\u0004\u0006\u0002\u001f\u0005)1oY1mC&\u0011\u0011C\u0004\u0002\u0007\u0003:L(+\u001a4\t\u0011M\u0001!Q1A\u0005\u0002Q\t1!\u001e:m+\u0005)\u0002C\u0001\f\u001c\u001b\u00059\"B\u0001\r\u001a\u0003\rqW\r\u001e\u0006\u00025\u0005!!.\u0019<b\u0013\tarCA\u0002V%2C\u0001B\b\u0001\u0003\u0002\u0003\u0006I!F\u0001\u0005kJd\u0007\u0005\u0003\u0005!\u0001\t\u0015\r\u0011\"\u0001\"\u0003%!W\r\\5nSR,'/F\u0001#!\t\u0019#F\u0004\u0002%QA\u0011QED\u0007\u0002M)\u0011qEC\u0001\u0007yI|w\u000e\u001e \n\u0005%r\u0011A\u0002)sK\u0012,g-\u0003\u0002,Y\t11\u000b\u001e:j]\u001eT!!\u000b\b\t\u00119\u0002!\u0011!Q\u0001\n\t\n!\u0002Z3mS6LG/\u001a:!\u0011\u0015\u0001\u0004\u0001\"\u00012\u0003\u0019a\u0014N\\5u}Q\u0019!\u0007N\u001b\u0011\u0005M\u0002Q\"\u0001\u0002\t\u000bMy\u0003\u0019A\u000b\t\u000f\u0001z\u0003\u0013!a\u0001E!1q\u0007\u0001Q\u0001\na\na\u0001]1sg\u0016\u0014\bCA\u001a:\u0013\tQ$A\u0001\u0006UKb$\b+\u0019:tKJDa\u0001\u0010\u0001!\u0002\u0013i\u0014a\u00017pOB\u0011a(Q\u0007\u0002\u007f)\u0011\u0001\tC\u0001\u0006g24GG[\u0005\u0003\u0005~\u0012a\u0001T8hO\u0016\u0014\bB\u0002#\u0001A\u0003%Q)A\u0007nSN\u001c\u0018N\\4E_V\u0014G.\u001a\t\u0003\u001b\u0019K!a\u0012\b\u0003\r\u0011{WO\u00197f\u0011\u0019I\u0005\u0001)A\u0005\u0015\u0006aQ.[:tS:<g\t\\8biB\u0011QbS\u0005\u0003\u0019:\u0011QA\u00127pCRDaA\u0014\u0001!\u0002\u0013y\u0015A\u00033bi\u0016\u0004\u0016M]:feB\u0011\u0001kU\u0007\u0002#*\u0011!+G\u0001\u0005i\u0016DH/\u0003\u0002U#\n\u00012+[7qY\u0016$\u0015\r^3G_Jl\u0017\r\u001e\u0005\u0006-\u0002!\taV\u0001\u0006CB\u0004H.\u001f\u000b\u00051\u0016<\u0017\u000e\u0006\u0002Z9B\u0011QBW\u0005\u00037:\u0011A!\u00168ji\")Q,\u0016a\u0002=\u0006QA-Y8GC\u000e$xN]=\u0011\u0005}\u001bW\"\u00011\u000b\u0005\u0005\u0014\u0017AC1o]>$\u0018\r^5p]*\tQ!\u0003\u0002eA\n!\u0012I\u001c8pi\u0006$\u0018n\u001c8E\u0003>3\u0015m\u0019;pefDQAZ+A\u0002\t\n\u0001C^5eK>\f%o\u00195jm\u0016t\u0015-\\3\t\u000b!,\u0006\u0019A#\u0002\u001b=4gm]3u'\u0016\u001cwN\u001c3t\u0011\u001dQW\u000b%AA\u0002-\f!B]3tKRtU\u000f\u001c7t!\tiA.\u0003\u0002n\u001d\t9!i\\8mK\u0006t\u0007\"B8\u0001\t\u0003\u0001\u0018aB2pY2\fG/\u001a\u000b\u0006c\u0006E\u00111\u0003\u000b\u0004e\u0006=\u0001cA:yw:\u0011AO\u001e\b\u0003KUL\u0011aD\u0005\u0003o:\tq\u0001]1dW\u0006<W-\u0003\u0002zu\n\u00191+Z9\u000b\u0005]t\u0001#B\u0007}}\u0006\r\u0011BA?\u000f\u0005\u0019!V\u000f\u001d7feA\u0011ql`\u0005\u0004\u0003\u0003\u0001'A\u0003,jI\u0016|gI]1nKB)Q\"!\u0002\u0002\n%\u0019\u0011q\u0001\b\u0003\r=\u0003H/[8o!\r\u0019\u00141B\u0005\u0004\u0003\u001b\u0011!aC$f]\u0016\u0014\u0018n\u0019#bi\u0006DQ!\u00188A\u0004yCQA\u001a8A\u0002\tBQ\u0001\u001b8A\u0002\u0015Cq!a\u0006\u0001\t\u0013\tI\"A\bgS:$g+\u001b3f_\u001a\u0013\u0018-\\3t)\u0011\tY\"!\t\u0015\t\u0005u\u0011q\u0004\t\u0004gbt\bBB/\u0002\u0016\u0001\u000fa\f\u0003\u0004g\u0003+\u0001\rA\t\u0005\b\u0003K\u0001A\u0011BA\u0014\u0003=aw.\u00193HK:,'/[2ECR\fGCAA\u0015!\u0011\u0019\b0!\u0003\t\u000f\u00055\u0002\u0001\"\u0003\u00020\u0005I\u0001/\u0019:tK\u0012\u000bG/\u001a\u000b\u0005\u0003c\ti\u0004\u0005\u0003\u00024\u0005eRBAA\u001b\u0015\r\t9$G\u0001\u0005kRLG.\u0003\u0003\u0002<\u0005U\"\u0001\u0002#bi\u0016Dq!a\u0010\u0002,\u0001\u0007!%A\u0001t\u0011\u001d\t\u0019\u0005\u0001C\u0005\u0003\u000b\nA\u0001\\8bIV!\u0011qIA*))\tI%!\u001a\u0002j\u0005M\u0014q\u000f\t\u0006g\u0006-\u0013qJ\u0005\u0004\u0003\u001bR(\u0001\u0002'jgR\u0004B!!\u0015\u0002T1\u0001A\u0001CA+\u0003\u0003\u0012\r!a\u0016\u0003\u0003Q\u000bB!!\u0017\u0002`A\u0019Q\"a\u0017\n\u0007\u0005ucBA\u0004O_RD\u0017N\\4\u0011\u00075\t\t'C\u0002\u0002d9\u00111!\u00118z\u0011\u001d\t9'!\u0011A\u0002\t\n!bY8mk6tg*Y7f\u0011!\tY'!\u0011A\u0002\u00055\u0014A\u00014o!\u0019i\u0011q\u000e\u0012\u0002P%\u0019\u0011\u0011\u000f\b\u0003\u0013\u0019+hn\u0019;j_:\f\u0004\u0002CA;\u0003\u0003\u0002\r!a\u0014\u0002\u00195L7o]5oOZ\u000bG.^3\t\u0011\u0005e\u0014\u0011\ta\u0001\u0003w\nA\"\u001a=qK\u000e$X\rZ*ju\u0016\u00042!DA?\u0013\r\tyH\u0004\u0002\u0004\u0013:$\bbBAB\u0001\u0011\u0005\u0011QQ\u0001\u0007kB$\u0017\r^3\u0015\r\u0005\u001d\u00151RAH)\rI\u0016\u0011\u0012\u0005\u0007;\u0006\u0005\u00059\u00010\t\u000f\u00055\u0015\u0011\u0011a\u0001e\u0006!A-\u0019;b\u0011!Q\u0017\u0011\u0011I\u0001\u0002\u0004Y\u0007\"CAJ\u0001E\u0005I\u0011AAK\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\u001aTCAALU\rY\u0017\u0011T\u0016\u0003\u00037\u0003B!!(\u0002&6\u0011\u0011q\u0014\u0006\u0005\u0003C\u000b\u0019+A\u0005v]\u000eDWmY6fI*\u0011\u0011MD\u0005\u0005\u0003O\u000byJA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D\u0011\"a+\u0001#\u0003%\t!!&\u0002!U\u0004H-\u0019;fI\u0011,g-Y;mi\u0012\u0012taBAX\u0005!\u0005\u0011\u0011W\u0001\r\u000f\u0016tWM]5d\u001b\u0016\u0014x-\u001a\t\u0004g\u0005MfAB\u0001\u0003\u0011\u0003\t)lE\u0002\u000242Aq\u0001MAZ\t\u0003\tI\f\u0006\u0002\u00022\"A\u0011QXAZ\t\u0003\ty,\u0001\u0003nC&tGcA-\u0002B\"A\u00111YA^\u0001\u0004\t)-\u0001\u0003be\u001e\u001c\b\u0003B\u0007\u0002H\nJ1!!3\u000f\u0005\u0015\t%O]1z\u0011)\ti-a-\u0012\u0002\u0013\u0005\u0011qZ\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005E'f\u0001\u0012\u0002\u001a\u0002")
public class GenericMerge {
    private final URL url;
    private final String delimiter;
    private final TextParser parser;
    private final Logger log;
    private final double missingDouble;
    private final float missingFloat;
    private final SimpleDateFormat dateParser;

    public static String $lessinit$greater$default$2() {
        return GenericMerge$.MODULE$.$lessinit$greater$default$2();
    }

    public static void main(String[] stringArray) {
        GenericMerge$.MODULE$.main(stringArray);
    }

    public URL url() {
        return this.url;
    }

    public String delimiter() {
        return this.delimiter;
    }

    public void apply(String videoArchiveName, double offsetSeconds, boolean resetNulls, AnnotationDAOFactory daoFactory) {
        this.update(this.collate(videoArchiveName, offsetSeconds, daoFactory), resetNulls, daoFactory);
    }

    public boolean apply$default$3() {
        return true;
    }

    public Seq<Tuple2<VideoFrame, Option<GenericData>>> collate(String videoArchiveName, double offsetSeconds, AnnotationDAOFactory daoFactory) {
        Seq<VideoFrame> videoFrames = this.findVideoFrames(videoArchiveName, daoFactory);
        long[] vfMillis = (long[])((TraversableOnce)videoFrames.map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)GenericMerge.$anonfun$collate$1(x$1)), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Long());
        Seq<GenericData> logData = this.loadGenericData();
        long[] logMillis = (long[])((TraversableOnce)logData.map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)GenericMerge.$anonfun$collate$2(x$2)), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Long());
        return FastCollator$.MODULE$.apply(videoFrames, (Function1 & Serializable & scala.Serializable)vf -> BoxesRunTime.boxToDouble((double)GenericMerge.vfToSecs$1(vf)), logData, (Function1 & Serializable & scala.Serializable)gd -> BoxesRunTime.boxToDouble((double)GenericMerge.logToSecs$1(gd)), offsetSeconds);
    }

    private Seq<VideoFrame> findVideoFrames(String videoArchiveName, AnnotationDAOFactory daoFactory) {
        VideoArchiveDAO dao = daoFactory.newVideoArchiveDAO();
        dao.startTransaction();
        VideoArchive videoArchive = dao.findByName(videoArchiveName);
        Nil$ videoFrames = videoArchive != null ? (Seq)JavaConverters$.MODULE$.asScalaBufferConverter(videoArchive.getVideoFrames()).asScala() : Nil$.MODULE$;
        dao.endTransaction();
        dao.close();
        return videoFrames;
    }

    private Seq<GenericData> loadGenericData() {
        List columns = (List)this.parser.columns().map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.toLowerCase(), List$.MODULE$.canBuildFrom());
        List<Date> date = this.load("date", (Function1 & Serializable & scala.Serializable)s -> this.parseDate((String)s), new Date(0L), this.parser.rows().size());
        List<Double> lat = this.load("latitude", (Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToDouble((double)GenericMerge.$anonfun$loadGenericData$3(s)), BoxesRunTime.boxToDouble((double)Double.NaN), this.parser.rows().size());
        List<Double> lon = this.load("longitude", (Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToDouble((double)GenericMerge.$anonfun$loadGenericData$4(s)), BoxesRunTime.boxToDouble((double)Double.NaN), this.parser.rows().size());
        List<Float> depth = this.load("depth", (Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToFloat((float)GenericMerge.$anonfun$loadGenericData$5(s)), BoxesRunTime.boxToFloat((float)Float.NaN), this.parser.rows().size());
        List<Float> salinity = this.load("salinity", (Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToFloat((float)GenericMerge.$anonfun$loadGenericData$6(s)), BoxesRunTime.boxToFloat((float)Float.NaN), this.parser.rows().size());
        List<Float> temperature = this.load("temperature", (Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToFloat((float)GenericMerge.$anonfun$loadGenericData$7(s)), BoxesRunTime.boxToFloat((float)Float.NaN), this.parser.rows().size());
        List<Float> oxygen = this.load("oxygen", (Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToFloat((float)GenericMerge.$anonfun$loadGenericData$8(s)), BoxesRunTime.boxToFloat((float)Float.NaN), this.parser.rows().size());
        return (Seq)date.indices().map((Function1 & Serializable & scala.Serializable)i -> GenericMerge.$anonfun$loadGenericData$9(date, lat, lon, depth, salinity, temperature, oxygen, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
    }

    private Date parseDate(String s) {
        return (Date)Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> Date.from(Instant.parse(s))).getOrElse((Function0 & Serializable & scala.Serializable)() -> $this.dateParser.parse(s));
    }

    private <T> List<T> load(String columnName, Function1<String, T> fn, T missingValue, int expectedSize) {
        List columns = (List)this.parser.columns().map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.toLowerCase(), List$.MODULE$.canBuildFrom());
        int idx = columns.indexOf((Object)columnName.toLowerCase());
        return idx >= 0 ? ((TraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.parser.values())).map((Function1 & Serializable & scala.Serializable)row -> Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> fn.apply((Object)row[idx])).getOrElse((Function0 & Serializable & scala.Serializable)() -> missingValue), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()))).toList() : (List)List$.MODULE$.fill(expectedSize, (Function0 & Serializable & scala.Serializable)() -> missingValue);
    }

    public void update(Seq<Tuple2<VideoFrame, Option<GenericData>>> data, boolean resetNulls, AnnotationDAOFactory daoFactory) {
        VideoArchiveDAO dao = daoFactory.newVideoArchiveDAO();
        VideoFrameDAO vfDao = daoFactory.newVideoFrameDAO(dao.getEntityManager());
        dao.startTransaction();
        data.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)GenericMerge.$anonfun$update$1(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
            GenericMerge.$anonfun$update$2(resetNulls, vfDao, x$5);
            return BoxedUnit.UNIT;
        });
        dao.endTransaction();
        dao.close();
    }

    public boolean update$default$2() {
        return true;
    }

    public static final /* synthetic */ long $anonfun$collate$1(VideoFrame x$1) {
        return x$1.getRecordedDate().getTime();
    }

    public static final /* synthetic */ long $anonfun$collate$2(GenericData x$2) {
        return x$2.date().getTime();
    }

    private static final double vfToSecs$1(VideoFrame vf) {
        return (double)vf.getRecordedDate().getTime() / 1000.0;
    }

    private static final double logToSecs$1(GenericData gd) {
        return (double)gd.date().getTime() / 1000.0;
    }

    public static final /* synthetic */ double $anonfun$loadGenericData$3(String s) {
        return new StringOps(Predef$.MODULE$.augmentString(s)).toDouble();
    }

    public static final /* synthetic */ double $anonfun$loadGenericData$4(String s) {
        return new StringOps(Predef$.MODULE$.augmentString(s)).toDouble();
    }

    public static final /* synthetic */ float $anonfun$loadGenericData$5(String s) {
        return new StringOps(Predef$.MODULE$.augmentString(s)).toFloat();
    }

    public static final /* synthetic */ float $anonfun$loadGenericData$6(String s) {
        return new StringOps(Predef$.MODULE$.augmentString(s)).toFloat();
    }

    public static final /* synthetic */ float $anonfun$loadGenericData$7(String s) {
        return new StringOps(Predef$.MODULE$.augmentString(s)).toFloat();
    }

    public static final /* synthetic */ float $anonfun$loadGenericData$8(String s) {
        return new StringOps(Predef$.MODULE$.augmentString(s)).toFloat();
    }

    public static final /* synthetic */ GenericData $anonfun$loadGenericData$9(List date$1, List lat$1, List lon$1, List depth$1, List salinity$1, List temperature$1, List oxygen$1, int i) {
        return new GenericData((Date)date$1.apply(i), BoxesRunTime.unboxToDouble((Object)lat$1.apply(i)), BoxesRunTime.unboxToDouble((Object)lon$1.apply(i)), BoxesRunTime.unboxToFloat((Object)depth$1.apply(i)), BoxesRunTime.unboxToFloat((Object)salinity$1.apply(i)), BoxesRunTime.unboxToFloat((Object)temperature$1.apply(i)), BoxesRunTime.unboxToFloat((Object)oxygen$1.apply(i)));
    }

    public static final /* synthetic */ boolean $anonfun$update$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$update$2(boolean resetNulls$1, VideoFrameDAO vfDao$1, Tuple2 x$5) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x$5;
        if (tuple2 != null) {
            VideoFrame vf = (VideoFrame)tuple2._1();
            Option gdOpt = (Option)tuple2._2();
            GenericData gd = (GenericData)gdOpt.getOrElse((Function0 & Serializable & scala.Serializable)() -> NullGenericData$.MODULE$);
            VideoFrame videoFrame = (VideoFrame)vfDao$1.find((Object)vf);
            PhysicalData pd = videoFrame.getPhysicalData();
            if (resetNulls$1) {
                if (Predef$.MODULE$.double2Double(gd.latitude()).isNaN()) {
                    pd.setLatitude(null);
                } else {
                    pd.setLatitude(Predef$.MODULE$.double2Double(gd.latitude()));
                }
                if (Predef$.MODULE$.double2Double(gd.longitude()).isNaN()) {
                    pd.setLongitude(null);
                } else {
                    pd.setLongitude(Predef$.MODULE$.double2Double(gd.longitude()));
                }
                if (Predef$.MODULE$.float2Float(gd.depth()).isNaN()) {
                    pd.setDepth(null);
                } else {
                    pd.setDepth(Predef$.MODULE$.float2Float(gd.depth()));
                }
                if (Predef$.MODULE$.float2Float(gd.salinity()).isNaN()) {
                    pd.setSalinity(null);
                } else {
                    pd.setSalinity(Predef$.MODULE$.float2Float(gd.salinity()));
                }
                if (Predef$.MODULE$.float2Float(gd.temperature()).isNaN()) {
                    pd.setTemperature(null);
                } else {
                    pd.setTemperature(Predef$.MODULE$.float2Float(gd.temperature()));
                }
                if (Predef$.MODULE$.float2Float(gd.oxygen()).isNaN()) {
                    pd.setOxygen(null);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    pd.setOxygen(Predef$.MODULE$.float2Float(gd.oxygen()));
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                if (!Predef$.MODULE$.double2Double(gd.latitude()).isNaN()) {
                    pd.setLatitude(Predef$.MODULE$.double2Double(gd.latitude()));
                }
                if (!Predef$.MODULE$.double2Double(gd.longitude()).isNaN()) {
                    pd.setLongitude(Predef$.MODULE$.double2Double(gd.longitude()));
                }
                if (!Predef$.MODULE$.float2Float(gd.depth()).isNaN()) {
                    pd.setDepth(Predef$.MODULE$.float2Float(gd.depth()));
                }
                if (!Predef$.MODULE$.float2Float(gd.salinity()).isNaN()) {
                    pd.setSalinity(Predef$.MODULE$.float2Float(gd.salinity()));
                }
                if (!Predef$.MODULE$.float2Float(gd.temperature()).isNaN()) {
                    pd.setTemperature(Predef$.MODULE$.float2Float(gd.temperature()));
                }
                if (!Predef$.MODULE$.float2Float(gd.oxygen()).isNaN()) {
                    pd.setOxygen(Predef$.MODULE$.float2Float(gd.oxygen()));
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    /*
     * WARNING - void declaration
     */
    public GenericMerge(URL url, String delimiter) {
        void var3_3;
        this.url = url;
        this.delimiter = delimiter;
        this.parser = new TextParser(url, delimiter, TextParser$.MODULE$.$lessinit$greater$default$3());
        this.log = LoggerFactory.getLogger(this.getClass());
        this.missingDouble = Double.NaN;
        this.missingFloat = Float.NaN;
        SimpleDateFormat s = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
        s.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.dateParser = var3_3;
    }
}

