/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vars.cloud;

import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.Serializable;
import java.net.URL;
import javax.imageio.ImageIO;
import org.imgscalr.Scalr;
import org.mbari.awt.image.ImageUtilities;
import org.mbari.vars.cloud.FetchAndLabelImagesApp$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.parallel.immutable.ParMap;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;
import vars.annotation.ObservationDAO;
import vars.annotation.VideoFrame;
import vars.annotation.ui.ToolBelt;
import vars.knowledgebase.Concept;
import vars.knowledgebase.ConceptDAO;

@ScalaSignature(bytes="\u0006\u0001\u0005-a\u0001B\u0001\u0003\u0001-\u0011aCR3uG\"\fe\u000e\u001a'bE\u0016d\u0017*\\1hKN\f\u0005\u000f\u001d\u0006\u0003\u0007\u0011\tQa\u00197pk\u0012T!!\u0002\u0004\u0002\tY\f'o\u001d\u0006\u0003\u000f!\tQ!\u001c2be&T\u0011!C\u0001\u0004_J<7\u0001A\n\u0003\u00011\u0001\"!\u0004\t\u000e\u00039Q\u0011aD\u0001\u0006g\u000e\fG.Y\u0005\u0003#9\u0011a!\u00118z%\u00164\u0007\u0002C\n\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u000b\u0002\u0017\r|gnY3qi:\u000bW.\u001a\t\u0003+qq!A\u0006\u000e\u0011\u0005]qQ\"\u0001\r\u000b\u0005eQ\u0011A\u0002\u001fs_>$h(\u0003\u0002\u001c\u001d\u00051\u0001K]3eK\u001aL!!\b\u0010\u0003\rM#(/\u001b8h\u0015\tYb\u0002\u0003\u0005!\u0001\t\u0005\t\u0015!\u0003\u0015\u0003)!\u0018M]4fiJ{w\u000e\u001e\u0005\tE\u0001\u0011\t\u0011)A\u0005G\u0005Q\u0011.\\1hK^KG\r\u001e5\u0011\u00055!\u0013BA\u0013\u000f\u0005\rIe\u000e\u001e\u0005\tO\u0001\u0011\t\u0011)A\u0006Q\u0005AAo\\8m\u0005\u0016dG\u000f\u0005\u0002*_5\t!F\u0003\u0002,Y\u0005\u0011Q/\u001b\u0006\u0003[9\n!\"\u00198o_R\fG/[8o\u0015\u0005)\u0011B\u0001\u0019+\u0005!!vn\u001c7CK2$\b\"\u0002\u001a\u0001\t\u0003\u0019\u0014A\u0002\u001fj]&$h\b\u0006\u00035qeRDCA\u001b8!\t1\u0004!D\u0001\u0003\u0011\u00159\u0013\u0007q\u0001)\u0011\u0015\u0019\u0012\u00071\u0001\u0015\u0011\u0015\u0001\u0013\u00071\u0001\u0015\u0011\u001d\u0011\u0013\u0007%AA\u0002\rBa\u0001\u0010\u0001!\u0002\u0013i\u0014a\u00017pOB\u0011a(Q\u0007\u0002\u007f)\u0011\u0001\tC\u0001\u0006g24GG[\u0005\u0003\u0005~\u0012a\u0001T8hO\u0016\u0014\b\u0002\u0003#\u0001\u0011\u000b\u0007I\u0011A#\u0002\rQ\f'oZ3u+\u00051\u0005CA$M\u001b\u0005A%BA%K\u0003\tIwNC\u0001L\u0003\u0011Q\u0017M^1\n\u00055C%\u0001\u0002$jY\u0016D\u0001b\u0014\u0001\t\u0006\u0004%\t\u0001U\u0001\bG>t7-\u001a9u+\u0005\t\u0006C\u0001*V\u001b\u0005\u0019&B\u0001+/\u00035Ygn\\<mK\u0012<WMY1tK&\u0011ak\u0015\u0002\b\u0007>t7-\u001a9u\u0011\u0015A\u0006\u0001\"\u0003Z\u0003)1\u0017N\u001c3J[\u0006<Wm\u001d\u000b\u00025B!Qc\u0017\u000b\u0015\u0013\tafDA\u0002NCBDQA\u0018\u0001\u0005\n}\u000b\u0011b]1wK&k\u0017mZ3\u0015\u0007\u0001\u001cW\r\u0005\u0002\u000eC&\u0011!M\u0004\u0002\u0005+:LG\u000fC\u0003e;\u0002\u0007A#A\u0002ve2DQAZ/A\u0002Q\t\u0001BZ5mK:\fW.\u001a\u0005\u0006Q\u0002!\t![\u0001\u0006CB\u0004H.\u001f\u000b\u0002A\u001e)1N\u0001E\u0001Y\u00061b)\u001a;dQ\u0006sG\rT1cK2LU.Y4fg\u0006\u0003\b\u000f\u0005\u00027[\u001a)\u0011A\u0001E\u0001]N\u0011Q\u000e\u0004\u0005\u0006e5$\t\u0001\u001d\u000b\u0002Y\")!/\u001cC\u0001g\u0006!Q.Y5o)\t\u0001G\u000fC\u0003vc\u0002\u0007a/\u0001\u0003be\u001e\u001c\bcA\u0007x)%\u0011\u0001P\u0004\u0002\u0006\u0003J\u0014\u0018-\u001f\u0005\bu6\f\n\u0011\"\u0001|\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%gU\tAP\u000b\u0002${.\na\u0010E\u0002\u0000\u0003\u000fi!!!\u0001\u000b\t\u0005\r\u0011QA\u0001\nk:\u001c\u0007.Z2lK\u0012T!!\f\b\n\t\u0005%\u0011\u0011\u0001\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007")
public class FetchAndLabelImagesApp {
    private File target;
    private Concept concept;
    private final String conceptName;
    private final String targetRoot;
    private final int imageWidth;
    private final ToolBelt toolBelt;
    private final Logger log;
    private volatile byte bitmap$0;

    public static int $lessinit$greater$default$3() {
        return FetchAndLabelImagesApp$.MODULE$.$lessinit$greater$default$3();
    }

    public static void main(String[] stringArray) {
        FetchAndLabelImagesApp$.MODULE$.main(stringArray);
    }

    /*
     * WARNING - void declaration
     */
    private File target$lzycompute() {
        FetchAndLabelImagesApp fetchAndLabelImagesApp = this;
        synchronized (fetchAndLabelImagesApp) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                void var2_2;
                File f = new File(this.targetRoot);
                Object object = !f.exists() ? BoxesRunTime.boxToBoolean((boolean)f.mkdirs()) : BoxedUnit.UNIT;
                this.target = var2_2;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.target;
    }

    public File target() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.target$lzycompute() : this.target;
    }

    private Concept concept$lzycompute() {
        FetchAndLabelImagesApp fetchAndLabelImagesApp = this;
        synchronized (fetchAndLabelImagesApp) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                ConceptDAO dao = this.toolBelt.getKnowledgebaseDAOFactory().newConceptDAO();
                this.concept = dao.findByName(this.conceptName);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        this.conceptName = null;
        return this.concept;
    }

    public Concept concept() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.concept$lzycompute() : this.concept;
    }

    private Map<String, String> findImages() {
        ConceptDAO conceptDAO = this.toolBelt.getKnowledgebaseDAOFactory().newConceptDAO();
        ObservationDAO observationDAO = this.toolBelt.getAnnotationDAOFactory().newObservationDAO();
        Buffer observations = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(observationDAO.findAllByConcept(this.concept(), true, conceptDAO)).asScala();
        Buffer urlName1 = (Buffer)observations.map((Function1 & Serializable & scala.Serializable)obs -> {
            None$ none$;
            block4: {
                VideoFrame vf = obs.getVideoFrame();
                try {
                    String url = vf.getCameraData().getImageReference();
                    if (url.toLowerCase().startsWith("http")) {
                        String videoArchiveName = vf.getVideoArchive().getName();
                        String timecode = vf.getTimecode().replace(':', '_');
                        String name = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-", "-", ".png"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{obs.getConceptName(), videoArchiveName, timecode}));
                        String pngUrl = url.replace(".jpg", ".png");
                        none$ = Option$.MODULE$.apply((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)pngUrl), (Object)name));
                        break block4;
                    }
                    none$ = None$.MODULE$;
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (option.isEmpty()) {
                        throw throwable;
                    }
                    $this.log.debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to map ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{obs})));
                    None$ none$2 = None$.MODULE$;
                    none$ = none$2;
                }
            }
            return none$;
        }, Buffer$.MODULE$.canBuildFrom());
        return ((TraversableOnce)urlName1.flatten((Function1 & Serializable & scala.Serializable)xo -> Option$.MODULE$.option2Iterable(xo))).toMap(Predef$.MODULE$.$conforms());
    }

    private void saveImage(String url, String filename) {
        BufferedImage bufferedImage = ImageIO.read(new URL(url));
        BufferedImage scaledImage = Scalr.resize((BufferedImage)bufferedImage, (Scalr.Method)Scalr.Method.ULTRA_QUALITY, (int)this.imageWidth, (BufferedImageOp[])new BufferedImageOp[0]);
        ImageUtilities.saveImage((RenderedImage)scaledImage, (File)new File(this.target(), filename));
        this.log.debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Copied ", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{url, filename})));
    }

    public void apply() {
        ParMap m = (ParMap)this.findImages().par();
        m.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            FetchAndLabelImagesApp.$anonfun$apply$1(this, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$apply$1(FetchAndLabelImagesApp $this, Tuple2 x0$1) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String u = (String)tuple2._1();
            String f = (String)tuple2._2();
            try {
                $this.saveImage(u, f);
                boxedUnit = BoxedUnit.UNIT;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (option.isEmpty()) {
                    throw throwable;
                }
                $this.log.debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to write ", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{u, f})));
                BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit3 = boxedUnit;
    }

    public FetchAndLabelImagesApp(String conceptName, String targetRoot, int imageWidth, ToolBelt toolBelt) {
        this.conceptName = conceptName;
        this.targetRoot = targetRoot;
        this.imageWidth = imageWidth;
        this.toolBelt = toolBelt;
        this.log = LoggerFactory.getLogger(this.getClass());
    }
}

