/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vars.arctic;

import java.io.File;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.mbari.vars.arctic.CSVLogReader$;
import org.mbari.vars.arctic.MergeUtilities$;
import org.mbari.vars.arctic.MergeVideoData;
import org.mbari.vars.arctic.package;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import vars.VideoMoment;
import vars.annotation.VideoArchive;
import vars.annotation.VideoArchiveDAO;
import vars.annotation.VideoFrame;
import vars.annotation.ui.StateLookup;
import vars.annotation.ui.ToolBelt;
import vars.shared.ui.GlobalStateLookup;

public final class MergeVideoData$ {
    public static MergeVideoData$ MODULE$;
    private ToolBelt toolbelt;
    private final Logger log;
    private final package.RawLogRecord NullLogRecord;
    private volatile boolean bitmap$0;

    static {
        new MergeVideoData$();
    }

    public package.RawLogRecord NullLogRecord() {
        return this.NullLogRecord;
    }

    public Iterable<VideoFrame> lookupVideoFrames(String videoArchiveName) {
        Seq seq;
        VideoArchiveDAO dao = this.toolbelt().getAnnotationDAOFactory().newVideoArchiveDAO();
        dao.startTransaction();
        VideoArchive videoArchive = dao.findByName(videoArchiveName);
        if (videoArchive == null) {
            this.log.debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"No VideoArchive named ", " was found."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{videoArchiveName})));
            seq = Nil$.MODULE$;
        } else {
            seq = (Seq)JavaConverters$.MODULE$.asScalaBufferConverter(videoArchive.getVideoFrames()).asScala();
        }
        Seq videoFrames = seq;
        dao.endTransaction();
        this.log.debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Found ", " videoFrames in ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)videoFrames.size()), videoArchiveName})));
        return videoFrames;
    }

    private ToolBelt toolbelt$lzycompute() {
        MergeVideoData$ mergeVideoData$ = this;
        synchronized (mergeVideoData$) {
            if (!this.bitmap$0) {
                this.toolbelt = (ToolBelt)StateLookup.GUICE_INJECTOR.getInstance(ToolBelt.class);
                this.bitmap$0 = true;
            }
        }
        return this.toolbelt;
    }

    public ToolBelt toolbelt() {
        return !this.bitmap$0 ? this.toolbelt$lzycompute() : this.toolbelt;
    }

    public void apply(String videoArchiveName, File logFile, Date startDate) {
        Iterable withBadDates;
        Seq<package.RawLogRecord> raw = CSVLogReader$.MODULE$.apply(logFile);
        Seq<package.FullLogRecord> full = MergeUtilities$.MODULE$.toFullLogRecords(raw, startDate);
        Iterable<VideoFrame> videoFrames = this.lookupVideoFrames(videoArchiveName);
        if (this.log.isDebugEnabled()) {
            DateFormat df = GlobalStateLookup.getUTCDateFormat();
            Seq rs = (Seq)full.sortBy((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToLong((long)MergeVideoData$.$anonfun$apply$1(x$5)), (Ordering)Ordering.Long$.MODULE$);
            this.log.debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Log spans ", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{df.format(((package.FullLogRecord)rs.head()).gpsDate()), df.format(((package.FullLogRecord)rs.last()).gpsDate())})));
            Seq vs = (Seq)videoFrames.toSeq().sortBy((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToLong((long)MergeVideoData$.$anonfun$apply$2(x$6)), (Ordering)Ordering.Long$.MODULE$);
            this.log.debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Annotations span ", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{df.format(((VideoMoment)vs.head()).getRecordedDate()), df.format(((VideoMoment)vs.last()).getRecordedDate())})));
        }
        if ((withBadDates = (Iterable)videoFrames.filter((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)MergeVideoData$.$anonfun$apply$3(startDate, x$7)))).size() > 0) {
            this.log.warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Found ", " VideoFrames with recordedDates"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)withBadDates.size())})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" before ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{GlobalStateLookup.getUTCDateFormat().format(startDate)})));
        }
        MergeVideoData merge = new MergeVideoData(videoFrames, (Iterable<package.FullLogRecord>)full, this.toolbelt());
        merge.update(merge.collate());
    }

    public void main(String[] args) {
        Date date;
        System.setProperty("user.timezone", "UTC");
        TimeZone.setDefault(TimeZone.getTimeZone("UTC"));
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).size() != 3) {
            Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("\n          | Usage:\n          |  MergeVideoData [videoArchiveName] [logFile] [startDate]\n          |\n          | Inputs:\n          |  videoArchiveName: The name, as stored in VARS, of the video archive\n          |     to merge\n          |\n          |  logFile: The full path to the log file to use for the merge\n          |\n          |  startDate: The UTC date formatted as yyyy-MM-dd HH:mm:ss of the start\n          |     of the logFile. Note that currently the HH:mm:ss portion is not\n          |     used so you can just use 00:00:00 there.\n        ")).stripMargin());
            return;
        }
        String videoArchiveName = args[0];
        File logFile = new File(args[1]);
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> GlobalStateLookup.getUTCDateFormat().parse(args[2]));
        if (try_ instanceof Success) {
            Date d;
            Success success = (Success)try_;
            date = d = (Date)success.value();
        } else if (try_ instanceof Failure) {
            this.log.error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to parse your date of ", ". Try yyyy-MM-dd HH:mm:ss format."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{args[2]})));
            System.exit(-1);
            date = new Date();
        } else {
            throw new MatchError((Object)try_);
        }
        Date startDate = date;
        this.apply(videoArchiveName, logFile, startDate);
    }

    public static final /* synthetic */ long $anonfun$apply$1(package.FullLogRecord x$5) {
        return x$5.gpsDate().getTime();
    }

    public static final /* synthetic */ long $anonfun$apply$2(VideoFrame x$6) {
        return x$6.getRecordedDate().getTime();
    }

    public static final /* synthetic */ boolean $anonfun$apply$3(Date startDate$1, VideoFrame x$7) {
        return x$7.getRecordedDate().before(startDate$1);
    }

    private MergeVideoData$() {
        MODULE$ = this;
        this.log = LoggerFactory.getLogger(this.getClass());
        this.NullLogRecord = new package.RawLogRecord((Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, "");
    }
}

