/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vars.arctic;

import java.io.File;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.mbari.vars.arctic.MergeUtilities$;
import org.mbari.vars.arctic.MergeVideoData;
import org.mbari.vars.arctic.MergeVideoData$;
import org.mbari.vars.arctic.SpecialCSVLogReader2$;
import org.mbari.vars.arctic.package;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import vars.VideoMoment;
import vars.annotation.VideoFrame;
import vars.shared.ui.GlobalStateLookup;

public final class MergeVARS692$ {
    public static MergeVARS692$ MODULE$;
    private final Logger log;

    static {
        new MergeVARS692$();
    }

    public void apply(String videoArchiveName, File logFile, Date startDate) {
        Seq<package.RawLogRecord> raw = SpecialCSVLogReader2$.MODULE$.apply(logFile);
        Seq<package.FullLogRecord> full = MergeUtilities$.MODULE$.toFullLogRecords(raw, startDate);
        Iterable videoFrames = (Iterable)MergeVideoData$.MODULE$.lookupVideoFrames(videoArchiveName).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)MergeVARS692$.$anonfun$apply$1(x$1)));
        if (this.log.isDebugEnabled()) {
            DateFormat df = GlobalStateLookup.getUTCDateFormat();
            Seq rs = (Seq)full.sortBy((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)MergeVARS692$.$anonfun$apply$2(x$2)), (Ordering)Ordering.Long$.MODULE$);
            this.log.debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Log spans ", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{df.format(((package.FullLogRecord)rs.head()).gpsDate()), df.format(((package.FullLogRecord)rs.last()).gpsDate())})));
            Seq vs = (Seq)videoFrames.toSeq().sortBy((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)MergeVARS692$.$anonfun$apply$3(x$3)), (Ordering)Ordering.Long$.MODULE$);
            this.log.debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Annotations span ", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{df.format(((VideoMoment)vs.head()).getRecordedDate()), df.format(((VideoMoment)vs.last()).getRecordedDate())})));
        }
        MergeVideoData merge = new MergeVideoData((Iterable<VideoFrame>)videoFrames, (Iterable<package.FullLogRecord>)full, MergeVideoData$.MODULE$.toolbelt());
        merge.update(merge.collate());
    }

    public void main(String[] args) {
        Date date;
        System.setProperty("user.timezone", "UTC");
        TimeZone.setDefault(TimeZone.getTimeZone("UTC"));
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).size() != 3) {
            Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("\n          | Usage:\n          |  MergeVARS692 [videoArchiveName] [logFile] [startDate]\n          |\n          | Inputs:\n          |  videoArchiveName: The name, as stored in VARS, of the video archive\n          |     to merge\n          |\n          |  logFile: The full path to the log file to use for the merge\n          |\n          |  startDate: The start date of the video in yyyy-MM-dd HH:mm:ss\n        ")).stripMargin());
            return;
        }
        String videoArchiveName = args[0];
        File logFile = new File(args[1]);
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> GlobalStateLookup.getUTCDateFormat().parse(args[2]));
        if (try_ instanceof Success) {
            Date d;
            Success success = (Success)try_;
            date = d = (Date)success.value();
        } else if (try_ instanceof Failure) {
            this.log.error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to parse your date of ", ". Try yyyy-MM-dd HH:mm:ss format."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{args[2]})));
            System.exit(-1);
            date = new Date();
        } else {
            throw new MatchError((Object)try_);
        }
        Date startDate = date;
        this.apply(videoArchiveName, logFile, startDate);
    }

    public static final /* synthetic */ boolean $anonfun$apply$1(VideoFrame x$1) {
        return x$1.getRecordedDate() != null;
    }

    public static final /* synthetic */ long $anonfun$apply$2(package.FullLogRecord x$2) {
        return x$2.gpsDate().getTime();
    }

    public static final /* synthetic */ long $anonfun$apply$3(VideoFrame x$3) {
        return x$3.getRecordedDate().getTime();
    }

    private MergeVARS692$() {
        MODULE$ = this;
        this.log = LoggerFactory.getLogger(this.getClass());
    }
}

