/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vars.arctic;

import java.io.File;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import org.mbari.vars.arctic.MergeVideoData;
import org.mbari.vars.arctic.MergeVideoData$;
import org.mbari.vars.arctic.SpecialShipLogReader1$;
import org.mbari.vars.arctic.package;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;
import vars.VideoMoment;
import vars.annotation.VideoFrame;
import vars.shared.ui.GlobalStateLookup;

public final class MergeVARS688$ {
    public static MergeVARS688$ MODULE$;
    private final Logger log;
    private final SimpleDateFormat dateFormat;

    static {
        new MergeVARS688$();
    }

    public void apply(String videoArchiveName, File logFile, int year) {
        Seq<package.SimplePosition> simple = SpecialShipLogReader1$.MODULE$.apply(logFile, year);
        Seq<package.FullLogRecord> full = this.toFullLogRecords(simple);
        Iterable videoFrames = (Iterable)MergeVideoData$.MODULE$.lookupVideoFrames(videoArchiveName).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)MergeVARS688$.$anonfun$apply$1(x$1)));
        if (this.log.isDebugEnabled()) {
            DateFormat df = GlobalStateLookup.getUTCDateFormat();
            Seq rs = (Seq)full.sortBy((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)MergeVARS688$.$anonfun$apply$2(x$2)), (Ordering)Ordering.Long$.MODULE$);
            this.log.debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Log spans ", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{df.format(((package.FullLogRecord)rs.head()).gpsDate()), df.format(((package.FullLogRecord)rs.last()).gpsDate())})));
            Seq vs = (Seq)videoFrames.toSeq().sortBy((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)MergeVARS688$.$anonfun$apply$3(x$3)), (Ordering)Ordering.Long$.MODULE$);
            this.log.debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Annotations span ", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{df.format(((VideoMoment)vs.head()).getRecordedDate()), df.format(((VideoMoment)vs.last()).getRecordedDate())})));
        }
        MergeVideoData merge = new MergeVideoData((Iterable<VideoFrame>)videoFrames, (Iterable<package.FullLogRecord>)full, MergeVideoData$.MODULE$.toolbelt());
        merge.update(merge.collate());
    }

    private Seq<package.FullLogRecord> toFullLogRecords(Seq<package.SimplePosition> simple) {
        return (Seq)simple.map((Function1 & Serializable & scala.Serializable)s -> new package.FullLogRecord((Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)s.latitude())), (Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)s.longitude())), MergeVARS688$.MODULE$.dateFormat.format(s.time()), s.time()), Seq$.MODULE$.canBuildFrom());
    }

    public void main(String[] args) {
        System.setProperty("user.timezone", "UTC");
        TimeZone.setDefault(TimeZone.getTimeZone("UTC"));
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).size() != 3) {
            Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("\n          | Usage:\n          |  MergeVARS688 [videoArchiveName] [logFile] [year]\n          |\n          | Inputs:\n          |  videoArchiveName: The name, as stored in VARS, of the video archive\n          |     to merge\n          |\n          |  logFile: The full path to the log file to use for the merge\n          |\n          |  year: The year of the data within the logfile\n        ")).stripMargin());
            return;
        }
        String videoArchiveName = args[0];
        File logFile = new File(args[1]);
        int year = new StringOps(Predef$.MODULE$.augmentString(args[2])).toInt();
        this.apply(videoArchiveName, logFile, year);
    }

    public static final /* synthetic */ boolean $anonfun$apply$1(VideoFrame x$1) {
        return x$1.getRecordedDate() != null;
    }

    public static final /* synthetic */ long $anonfun$apply$2(package.FullLogRecord x$2) {
        return x$2.gpsDate().getTime();
    }

    public static final /* synthetic */ long $anonfun$apply$3(VideoFrame x$3) {
        return x$3.getRecordedDate().getTime();
    }

    private MergeVARS688$() {
        MODULE$ = this;
        this.log = LoggerFactory.getLogger(this.getClass());
        this.dateFormat = new SimpleDateFormat("HH:mm:ss");
    }
}

