/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vars.arctic;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.mbari.math.Matlib;
import org.mbari.movie.Timecode;
import org.mbari.vars.arctic.package;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class MergeUtilities$ {
    public static MergeUtilities$ MODULE$;
    private final SimpleDateFormat dateFormat;

    static {
        new MergeUtilities$();
    }

    public Seq<Object> findClockRollover(Iterable<package.ILogRecord> records) {
        double[] frames = (double[])((TraversableOnce)records.map((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToDouble((double)MergeUtilities$.$anonfun$findClockRollover$2(r)), Iterable$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Double());
        double[] df = Matlib.diff((double[])frames);
        return (Seq)((TraversableLike)this.findRollovers$1(df, MergeUtilities$.findRollovers$default$2$1(), MergeUtilities$.findRollovers$default$3$1()).reverse()).map((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)x$4 -> x$4 + 1, Seq$.MODULE$.canBuildFrom());
    }

    public Seq<package.FullLogRecord> toFullLogRecords(Seq<package.RawLogRecord> records, Date startDate) {
        GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        calendar.setTime(startDate);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        Date baseDate = calendar.getTime();
        long msInDay = 86400000L;
        int n = 0;
        Seq rollovers = (Seq)this.findClockRollover((Iterable<package.ILogRecord>)records).$plus$colon((Object)BoxesRunTime.boxToInteger((int)n), Seq$.MODULE$.canBuildFrom());
        IndexedSeq rolloverBaseDates = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), rollovers.size()).map((Function1 & Serializable & scala.Serializable)i -> MergeUtilities$.$anonfun$toFullLogRecords$1(baseDate, msInDay, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        Seq rollovers2 = (Seq)rollovers.$colon$plus((Object)BoxesRunTime.boxToInteger((int)records.size()), Seq$.MODULE$.canBuildFrom());
        IndexedSeq groupedRecords = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), rollovers2.size() - 2).map((Function1 & Serializable & scala.Serializable)i -> MergeUtilities$.$anonfun$toFullLogRecords$2(records, rollovers2, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq rs = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), groupedRecords.size()).map((Function1 & Serializable & scala.Serializable)i -> MergeUtilities$.$anonfun$toFullLogRecords$3(rolloverBaseDates, groupedRecords, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        return (Seq)rs.flatten((Function1)Predef$.MODULE$.$conforms());
    }

    public Seq<package.FullLogRecord> toFullLogRecords(Seq<package.SimplePosition> simple) {
        return (Seq)simple.map((Function1 & Serializable & scala.Serializable)s -> new package.FullLogRecord((Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)s.latitude())), (Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)s.longitude())), MergeUtilities$.MODULE$.dateFormat.format(s.time()), s.time()), Seq$.MODULE$.canBuildFrom());
    }

    private final Seq findRollovers$1(double[] xs, List accum, int i) {
        List list;
        while (true) {
            int r = new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(xs)).indexWhere((Function1)(JFunction1.mcZD.sp & Serializable & scala.Serializable)x$1 -> x$1 < 0.0);
            int s = r + i;
            if (r == -1) {
                list = accum;
                break;
            }
            if (r == new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(xs)).size() - 1) {
                int n = s;
                list = accum.$colon$colon((Object)BoxesRunTime.boxToInteger((int)n));
                break;
            }
            int n = s;
            i = s + 1;
            accum = accum.$colon$colon((Object)BoxesRunTime.boxToInteger((int)n));
            xs = (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(xs)).slice(r + 1, new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(xs)).size());
        }
        return list;
    }

    private static final List findRollovers$default$2$1() {
        return Nil$.MODULE$;
    }

    private static final int findRollovers$default$3$1() {
        return 0;
    }

    public static final /* synthetic */ double $anonfun$findClockRollover$2(package.ILogRecord r) {
        return new Timecode(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":00"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{r.gpsTime()}))).getFrames();
    }

    public static final /* synthetic */ Date $anonfun$toFullLogRecords$1(Date baseDate$1, long msInDay$1, int i) {
        long t = baseDate$1.getTime() + (long)i * msInDay$1;
        return new Date(t);
    }

    private static final package.FullLogRecord transform$1(package.RawLogRecord r, Date d) {
        Timecode tc = new Timecode(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":00"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{r.gpsTime()})));
        long msOffset = package$.MODULE$.round(tc.getFrames() / tc.getFrameRate() * (double)1000L);
        Date gpsDate = new Date(d.getTime() + msOffset);
        return r.asFullLogRecord(gpsDate);
    }

    public static final /* synthetic */ Seq $anonfun$toFullLogRecords$2(Seq records$1, Seq rollovers2$1, int i) {
        return (Seq)records$1.slice(BoxesRunTime.unboxToInt((Object)rollovers2$1.apply(i)), BoxesRunTime.unboxToInt((Object)rollovers2$1.apply(i + 1)));
    }

    public static final /* synthetic */ Seq $anonfun$toFullLogRecords$3(IndexedSeq rolloverBaseDates$1, IndexedSeq groupedRecords$1, int i) {
        Seq xs = (Seq)groupedRecords$1.apply(i);
        Date baseDate = (Date)rolloverBaseDates$1.apply(i);
        return (Seq)xs.map((Function1 & Serializable & scala.Serializable)r -> MergeUtilities$.transform$1(r, baseDate), Seq$.MODULE$.canBuildFrom());
    }

    private MergeUtilities$() {
        MODULE$ = this;
        this.dateFormat = new SimpleDateFormat("HH:mm:ss");
    }
}

