/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.smith;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.Serializable;
import java.net.URL;
import javax.imageio.ImageIO;
import org.mbari.geometry.Point2D;
import org.mbari.smith.Annotation;
import org.mbari.smith.Annotation$;
import org.mbari.smith.CaseClassTextFileWriter;
import org.mbari.smith.CaseClassTextFileWriter$;
import org.mbari.smith.FlatAnnotation;
import org.mbari.smith.FlatAnnotation$;
import org.mbari.smith.TrimAreaMeasurementApp$;
import org.mbari.smith.package$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import vars.ILink;
import vars.ToolBox;
import vars.annotation.AnnotationDAOFactory;
import vars.annotation.Observation;
import vars.annotation.VideoArchive;
import vars.annotation.VideoArchiveDAO;
import vars.annotation.VideoFrame;
import vars.annotation.functions.TrimAreaMeasurementsFn;

public final class TrimAreaMeasurementApp$ {
    public static TrimAreaMeasurementApp$ MODULE$;
    private final ToolBox toolBox;
    private final List<String> columns;

    static {
        new TrimAreaMeasurementApp$();
    }

    public void apply(String videoArchiveName, File target, double top, double bottom) {
        Iterable<VideoFrame> videoFrames = this.findVideoFrames(videoArchiveName);
        Iterable observations = (Iterable)videoFrames.flatMap((Function1 & Serializable & scala.Serializable)x$1 -> (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(x$1.getObservations()).asScala(), Iterable$.MODULE$.canBuildFrom());
        Observation firstImageObs = (Observation)((IterableLike)observations.toStream().filter((Function1 & Serializable & scala.Serializable)obs -> BoxesRunTime.boxToBoolean((boolean)TrimAreaMeasurementApp$.$anonfun$apply$2(obs)))).head();
        Tuple2<Object, Object> tuple2 = this.imageSize(firstImageObs);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int width = tuple2._1$mcI$sp();
        int height = tuple2._2$mcI$sp();
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(width, height);
        Tuple2.mcII.sp sp3 = sp2;
        int width2 = sp3._1$mcI$sp();
        int height2 = sp3._2$mcI$sp();
        int minX = 0;
        int maxX = width2;
        int minY = (int)((double)height2 * top);
        int maxY = (int)((double)height2 * bottom);
        java.util.List boundaryPoints = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Point2D[]{new Point2D((Number)Predef$.MODULE$.int2Integer(minX), (Number)Predef$.MODULE$.int2Integer(minY)), new Point2D((Number)Predef$.MODULE$.int2Integer(maxX), (Number)Predef$.MODULE$.int2Integer(minY)), new Point2D((Number)Predef$.MODULE$.int2Integer(maxX), (Number)Predef$.MODULE$.int2Integer(maxY)), new Point2D((Number)Predef$.MODULE$.int2Integer(minX), (Number)Predef$.MODULE$.int2Integer(maxY))}))).asJava();
        TrimAreaMeasurementsFn fn = new TrimAreaMeasurementsFn(boundaryPoints);
        Iterable annotations = (Iterable)((TraversableLike)observations.map((Function1 & Serializable & scala.Serializable)obs -> {
            Set trimmedLinks = (Set)((TraversableLike)JavaConverters$.MODULE$.asScalaSetConverter(obs.getAssociations()).asScala()).flatMap((Function1 & Serializable & scala.Serializable)a -> Option$.MODULE$.option2Iterable(package$.MODULE$.toOption(fn.apply((ILink)a))), Set$.MODULE$.canBuildFrom());
            return Annotation$.MODULE$.from((Observation)obs, (Iterable<ILink>)trimmedLinks);
        }, Iterable$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)a -> FlatAnnotation$.MODULE$.from((Annotation)a, FlatAnnotation$.MODULE$.from$default$2()), Iterable$.MODULE$.canBuildFrom());
        CaseClassTextFileWriter writer = new CaseClassTextFileWriter(target, this.columns, CaseClassTextFileWriter$.MODULE$.$lessinit$greater$default$3());
        annotations.foreach((Function1 & Serializable & scala.Serializable)a -> {
            TrimAreaMeasurementApp$.$anonfun$apply$6(writer, a);
            return BoxedUnit.UNIT;
        });
        writer.close();
    }

    private Iterable<VideoFrame> findVideoFrames(String videoArchiveName) {
        AnnotationDAOFactory factory = this.toolBox.getToolBelt().getAnnotationDAOFactory();
        VideoArchiveDAO dao = factory.newVideoArchiveDAO();
        dao.startTransaction();
        VideoArchive videoArchive = dao.findByName(videoArchiveName);
        java.util.List videoFrames = videoArchive.getVideoFrames();
        dao.endTransaction();
        dao.close();
        return (Iterable)JavaConverters$.MODULE$.asScalaBufferConverter(videoFrames).asScala();
    }

    private Tuple2<Object, Object> imageSize(Observation observation) {
        URL url = new URL(observation.getVideoFrame().getCameraData().getImageReference());
        BufferedImage image = ImageIO.read(url);
        return new Tuple2.mcII.sp(image.getWidth(), image.getHeight());
    }

    public void main(String[] args) {
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).size() != 4) {
            Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("\n          | Dump out the results but trim the areaMeasurements to fit within the boundaries\n          | provided.\n          |\n          | Usage:\n          |   TrimAreaMeasurementApp [videoArchiveName] [file] [topPercent] [bottomPercent]\n          |\n          | Inputs:\n          |   videoArchiveName = The video archive name to process\n          |   file = The file to write to\n          |   topPercent = The top boundary in the image (1 > % >= 0)\n          |   bottomPercent = the bottom boundary in the image (1 >= % > 0)\n        ")).stripMargin());
            return;
        }
        String videoArchiveName = args[0];
        File file = new File(args[1]);
        double topPercent = new StringOps(Predef$.MODULE$.augmentString(args[2])).toDouble();
        double bottomPercent = new StringOps(Predef$.MODULE$.augmentString(args[3])).toDouble();
        Predef$.MODULE$.require(topPercent >= 0.0 && topPercent < bottomPercent, (Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"topPercent must be > 0 and < ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)bottomPercent)})));
        Predef$.MODULE$.require(bottomPercent <= 1.0, (Function0 & Serializable & scala.Serializable)() -> "bottomPercent must be less than 1");
        this.apply(videoArchiveName, file, topPercent, bottomPercent);
    }

    public static final /* synthetic */ boolean $anonfun$apply$2(Observation obs) {
        return obs.getVideoFrame().getCameraData().getImageReference() != null;
    }

    public static final /* synthetic */ void $anonfun$apply$6(CaseClassTextFileWriter writer$1, FlatAnnotation a) {
        JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(MODULE$.getClass().getClassLoader());
        public final class Org_mbari_smith_TrimAreaMeasurementApp$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.mbari.smith.FlatAnnotation").asType().toTypeConstructor();
            }

            public Org_mbari_smith_TrimAreaMeasurementApp$$typecreator1$1() {
            }
        }
        writer$1.write(a, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_mbari_smith_TrimAreaMeasurementApp$$typecreator1$1()), ClassTag$.MODULE$.apply(FlatAnnotation.class));
    }

    private TrimAreaMeasurementApp$() {
        MODULE$ = this;
        this.toolBox = new ToolBox();
        this.columns = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"videoArchiveName", "timecode", "recordedDate", "conceptName", "latitude", "longitude", "depth", "comment", "association", "imageURL", "observer", "observationID", "associations"}));
    }
}

