/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.smith;

import java.io.Serializable;
import org.mbari.geometry.Point2D;
import org.mbari.smith.AMContainer$;
import org.mbari.smith.AMPoint;
import org.mbari.smith.BasicPoint;
import org.mbari.smith.HasCameraView;
import org.mbari.smith.Pixel;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.IndexedSeq;
import scala.collection.IndexedSeq$;
import scala.collection.JavaConverters$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import vars.ILink;
import vars.annotation.AreaMeasurement;

public final class RawPoint$ {
    public static RawPoint$ MODULE$;

    static {
        new RawPoint$();
    }

    public <T extends ILink> Option<AMPoint<T, Double>> centerOfMass(T link, HasCameraView cameraView) {
        return AMContainer$.MODULE$.apply(link).map((Function1 & Serializable & scala.Serializable)c -> {
            IndexedSeq<Pixel> pixels = MODULE$.toPixels(c.areaMeasurement(), cameraView);
            double cx = BoxesRunTime.unboxToDouble((Object)((TraversableOnce)pixels.map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToDouble((double)x$1.xDistance()), IndexedSeq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) / (double)pixels.size();
            double cy = BoxesRunTime.unboxToDouble((Object)((TraversableOnce)pixels.map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToDouble((double)x$2.yDistance()), IndexedSeq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) / (double)pixels.size();
            Point2D point = new Point2D((Number)Predef$.MODULE$.double2Double(cx), (Number)Predef$.MODULE$.double2Double(cy));
            return new BasicPoint(Option$.MODULE$.apply((Object)link), c.areaMeasurement(), point, cameraView);
        });
    }

    public <T extends ILink> Option<AMPoint<T, Double>> farthestPoint(T link, HasCameraView cameraView) {
        Option a = AMContainer$.MODULE$.apply(link).map((Function1 & Serializable & scala.Serializable)c -> {
            IndexedSeq<Pixel> pixels = MODULE$.toPixels(c.areaMeasurement(), cameraView);
            IndexedSeq distances = (IndexedSeq)pixels.map((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToDouble((double)package$.MODULE$.sqrt(p.xDistance() * p.xDistance() + p.yDistance() + p.yDistance())), IndexedSeq$.MODULE$.canBuildFrom());
            double max = BoxesRunTime.unboxToDouble((Object)distances.max((Ordering)Ordering.Double$.MODULE$));
            Option farthestPixel = pixels.find((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)RawPoint$.$anonfun$farthestPoint$3(max, p)));
            return farthestPixel.map((Function1 & Serializable & scala.Serializable)p -> new BasicPoint(Option$.MODULE$.apply((Object)link), c.areaMeasurement(), new Point2D((Number)Predef$.MODULE$.double2Double(p.xDistance()), (Number)Predef$.MODULE$.double2Double(p.yDistance())), cameraView));
        });
        return (Option)a.getOrElse((Function0 & Serializable & scala.Serializable)() -> None$.MODULE$);
    }

    public <T extends ILink> Option<AMPoint<T, Double>> farthestPointFrom(T link, HasCameraView cameraView, Pixel origin) {
        Option a = AMContainer$.MODULE$.apply(link).map((Function1 & Serializable & scala.Serializable)c -> {
            IndexedSeq<Pixel> pixels = MODULE$.toPixels(c.areaMeasurement(), cameraView);
            IndexedSeq distances = (IndexedSeq)pixels.map((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToDouble((double)package$.MODULE$.sqrt(package$.MODULE$.pow(p.xDistance() - origin.xDistance(), 2.0) + package$.MODULE$.pow(p.yDistance() - origin.yDistance(), 2.0))), IndexedSeq$.MODULE$.canBuildFrom());
            double max = BoxesRunTime.unboxToDouble((Object)distances.max((Ordering)Ordering.Double$.MODULE$));
            Option farthestPixel = pixels.find((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)RawPoint$.$anonfun$farthestPointFrom$3(origin, max, p)));
            return farthestPixel.map((Function1 & Serializable & scala.Serializable)p -> new BasicPoint(Option$.MODULE$.apply((Object)link), c.areaMeasurement(), new Point2D((Number)Predef$.MODULE$.double2Double(p.xDistance()), (Number)Predef$.MODULE$.double2Double(p.yDistance())), cameraView));
        });
        return (Option)a.getOrElse((Function0 & Serializable & scala.Serializable)() -> None$.MODULE$);
    }

    private IndexedSeq<Pixel> toPixels(AreaMeasurement areaMeasurement, HasCameraView cameraView) {
        Buffer coords = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(areaMeasurement.getCoordinates()).asScala();
        return ((TraversableOnce)coords.map((Function1 & Serializable & scala.Serializable)p -> new Pixel(cameraView.camera(), cameraView.imageWidth(), cameraView.imageHeight(), Predef$.MODULE$.Integer2int((Integer)p.getX()), Predef$.MODULE$.Integer2int((Integer)p.getY())), Buffer$.MODULE$.canBuildFrom())).toIndexedSeq();
    }

    public static final /* synthetic */ boolean $anonfun$farthestPoint$3(double max$1, Pixel p) {
        double d = package$.MODULE$.sqrt(p.xDistance() * p.xDistance() + p.yDistance() + p.yDistance());
        return d == max$1;
    }

    public static final /* synthetic */ boolean $anonfun$farthestPointFrom$3(Pixel origin$1, double max$2, Pixel p) {
        double d = package$.MODULE$.sqrt(package$.MODULE$.pow(p.xDistance() - origin$1.xDistance(), 2.0) + package$.MODULE$.pow(p.yDistance() - origin$1.yDistance(), 2.0));
        return d == max$2;
    }

    private RawPoint$() {
        MODULE$ = this;
    }
}

