/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.smith;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.net.URL;
import java.text.SimpleDateFormat;
import org.mbari.geometry.Point2D;
import org.mbari.smith.AMContainer;
import org.mbari.smith.AMPoint;
import org.mbari.smith.BasicPoint;
import org.mbari.smith.Camera;
import org.mbari.smith.Camera$;
import org.mbari.smith.CameraView;
import org.mbari.smith.CanadianGrid$;
import org.mbari.smith.CoverageEstimator$;
import org.mbari.smith.HasPoint;
import org.mbari.smith.Pixel;
import org.mbari.smith.RawPoint$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble$;
import scala.runtime.RichInt$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import vars.annotation.Association;
import vars.annotation.PhysicalData;
import vars.annotation.VideoFrame;

public final class PointsApp$ {
    public static PointsApp$ MODULE$;
    private final SimpleDateFormat dateFormat;

    static {
        new PointsApp$();
    }

    public Iterable<Tuple3<AMPoint<Association, Double>, AMPoint<Association, Double>, AMPoint<Association, Double>>> read(String videoArchiveName, double cameraHeight, double alpha, double beta, double theta) {
        List<VideoFrame> videoFrames = CoverageEstimator$.MODULE$.fetchAnnotations(videoArchiveName);
        List associations = (List)((GenericTraversableTemplate)videoFrames.map((Function1 & Serializable & scala.Serializable)vf -> (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(vf.getObservations()).asScala()).flatMap((Function1 & Serializable & scala.Serializable)obs -> (Set)((TraversableLike)JavaConverters$.MODULE$.asScalaSetConverter(obs.getAssociations()).asScala()).withFilter((Function1 & Serializable & scala.Serializable)ass -> BoxesRunTime.boxToBoolean((boolean)PointsApp$.$anonfun$read$3(ass))).map((Function1 & Serializable & scala.Serializable)ass -> ass, Set$.MODULE$.canBuildFrom()), Buffer$.MODULE$.canBuildFrom()), List$.MODULE$.canBuildFrom())).flatten((Function1)Predef$.MODULE$.$conforms());
        Camera camera = Camera$.MODULE$.fromRadians(cameraHeight, alpha, beta, theta, Camera$.MODULE$.fromRadians$default$5());
        Option vf2 = videoFrames.find((Function1 & Serializable & scala.Serializable)v -> BoxesRunTime.boxToBoolean((boolean)PointsApp$.$anonfun$read$5(v)));
        URL url = (URL)vf2.map((Function1 & Serializable & scala.Serializable)v -> new URL(v.getCameraData().getImageReference())).get();
        Tuple2<Object, Object> imageDimensions = CanadianGrid$.MODULE$.imageDimensions(url);
        CameraView cameraView = new CameraView(camera, imageDimensions._1$mcI$sp(), imageDimensions._2$mcI$sp());
        IndexedSeq pointsCC = ((TraversableOnce)((GenericTraversableTemplate)associations.map((Function1 & Serializable & scala.Serializable)x$1 -> RawPoint$.MODULE$.centerOfMass(x$1, cameraView), List$.MODULE$.canBuildFrom())).flatten((Function1 & Serializable & scala.Serializable)xo -> Option$.MODULE$.option2Iterable(xo))).toIndexedSeq();
        Pixel imageBottomCenter = new Pixel(camera, imageDimensions._1$mcI$sp(), imageDimensions._2$mcI$sp(), (int)package$.MODULE$.round((double)imageDimensions._1$mcI$sp() / 2.0), imageDimensions._2$mcI$sp());
        IndexedSeq pointsCI = ((IndexedSeq)pointsCC.map((Function1 & Serializable & scala.Serializable)p -> {
            Point2D newPoint = new Point2D(p.point().getX(), (Number)Predef$.MODULE$.double2Double(Predef$.MODULE$.Double2double((Double)p.point().getY()) - imageBottomCenter.yDistance()));
            return new BasicPoint(p.link(), p.areaMeasurement(), newPoint, cameraView);
        }, IndexedSeq$.MODULE$.canBuildFrom())).toIndexedSeq();
        IndexedSeq pointsFI = ((TraversableOnce)((GenericTraversableTemplate)associations.map((Function1 & Serializable & scala.Serializable)x$2 -> RawPoint$.MODULE$.farthestPointFrom(x$2, cameraView, imageBottomCenter), List$.MODULE$.canBuildFrom())).flatten((Function1 & Serializable & scala.Serializable)xo -> Option$.MODULE$.option2Iterable(xo))).toIndexedSeq();
        return (Iterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), pointsCC.size()).map((Function1 & Serializable & scala.Serializable)i -> PointsApp$.$anonfun$read$13(pointsCC, pointsCI, pointsFI, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
    }

    public void write(Iterable<Tuple3<AMPoint<Association, Double>, AMPoint<Association, Double>, AMPoint<Association, Double>>> points, File file) {
        BufferedWriter writer = new BufferedWriter(new FileWriter(file));
        writer.write("VideoArchiveName\tTimecode\tRecordedDate\tConceptName\tLatitude\tLongitude\tDepth\tXOffsetCenterToCamera\tYOffsetCenterToCamera\tXOffsetCenterToImageBC\tYOffsetCenterToImageBC\tXOffsetFarthestToImageBC\tYOffsetFarthestToImageBC\tComment\tAssociation\tImage\n");
        points.foreach((Function1 & Serializable & scala.Serializable)p -> {
            PointsApp$.$anonfun$write$1(writer, p);
            return BoxedUnit.UNIT;
        });
        writer.close();
    }

    public void main(String[] args) {
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).size() != 6) {
            Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("\n                  | Script that converts any 'area measurement' associations found in your VARS query results\n                  | and converts them to x, y distances from the point directly under the camera.\n                  |\n                  | Usage:\n                  |   PointsApp <cameraHeight> <alpha> <beta> <theta> <inputFile> <outputFile>\n                  |\n                  | Arguments:\n                  |    cameraHeight:     The height of the camera above the seafloor. All area measurements will\n                  |                      be in the same units as cameraHeight (i.e. you should use centimeters\n                  |                      instead of meters)\n                  |    alpha:            The vertical angular field of view in degrees\n                  |    beta:             The horizontal angular field of view in degrees\n                  |    theta:            The tilt of the camera from horizontal in degrees\n                  |    videoArchiveName: The VideoArchive to process\n                  |    targetFile:       The name of the file to write to\n                ")).stripMargin('|'));
        } else {
            double cameraHeight = new StringOps(Predef$.MODULE$.augmentString(args[0])).toDouble();
            double alpha = RichDouble$.MODULE$.toRadians$extension(Predef$.MODULE$.doubleWrapper(new StringOps(Predef$.MODULE$.augmentString(args[1])).toDouble()));
            double beta = RichDouble$.MODULE$.toRadians$extension(Predef$.MODULE$.doubleWrapper(new StringOps(Predef$.MODULE$.augmentString(args[2])).toDouble()));
            double theta = RichDouble$.MODULE$.toRadians$extension(Predef$.MODULE$.doubleWrapper(new StringOps(Predef$.MODULE$.augmentString(args[3])).toDouble()));
            String videoArchiveName = args[4];
            File targetFile = new File(args[5]);
            Iterable<Tuple3<AMPoint<Association, Double>, AMPoint<Association, Double>, AMPoint<Association, Double>>> amPoints = this.read(videoArchiveName, cameraHeight, alpha, beta, theta);
            this.write(amPoints, targetFile);
        }
    }

    public static final /* synthetic */ boolean $anonfun$read$3(Association ass) {
        String string = ass.getLinkName();
        String string2 = "area measurement coordinates [x0 y0 ... xn yn; comment]";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$read$5(VideoFrame v) {
        boolean bl;
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> v.getCameraData().getImageReference());
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            String i = (String)success.value();
            bl = i != null;
        } else if (try_ instanceof Failure) {
            bl = false;
        } else {
            throw new MatchError((Object)try_);
        }
        return bl;
    }

    public static final /* synthetic */ Tuple3 $anonfun$read$13(IndexedSeq pointsCC$1, IndexedSeq pointsCI$1, IndexedSeq pointsFI$1, int i) {
        return new Tuple3(pointsCC$1.apply(i), pointsCI$1.apply(i), pointsFI$1.apply(i));
    }

    public static final /* synthetic */ String $anonfun$write$2() {
        return "";
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ void $anonfun$write$1(BufferedWriter writer$1, Tuple3 p) {
        v0 = ((AMContainer)p._1()).link();
        var4_2 = ((AMContainer)p._2()).link();
        if (v0 != null ? v0.equals(var4_2) == false : var4_2 != null) ** GOTO lbl-1000
        v1 = ((AMContainer)p._2()).link();
        var5_3 = ((AMContainer)p._3()).link();
        if (!(v1 != null ? v1.equals(var5_3) == false : var5_3 != null)) {
            v2 = true;
        } else lbl-1000:
        // 2 sources

        {
            v2 = false;
        }
        Predef$.MODULE$.require(v2);
        obs = ((Association)((AMContainer)p._1()).link().get()).getObservation();
        vf = obs.getVideoFrame();
        va = vf.getVideoArchive();
        d = vf.getRecordedDate() == null ? "" : PointsApp$.MODULE$.dateFormat.format(vf.getRecordedDate());
        img = vf.getCameraData() == null ? "" : vf.getCameraData().getImageReference();
        var13_9 = Option$.MODULE$.apply((Object)vf.getPhysicalData());
        if (None$.MODULE$.equals(var13_9)) {
            var3_10 = new Tuple3((Object)BoxesRunTime.boxToDouble((double)NaN), (Object)BoxesRunTime.boxToDouble((double)NaN), (Object)BoxesRunTime.boxToDouble((double)NaN));
        } else if (var13_9 instanceof Some) {
            var14_11 = (Some)var13_9;
            p = (PhysicalData)var14_11.value();
            var3_10 = new Tuple3((Object)p.getLatitude(), (Object)p.getLongitude(), (Object)p.getDepth());
        } else {
            throw new MatchError((Object)var13_9);
        }
        var12_13 = var3_10;
        if (var12_13 == null) {
            throw new MatchError((Object)var12_13);
        }
        lat = var12_13._1();
        lon = var12_13._2();
        depth = var12_13._3();
        var2_17 = new Tuple3(lat, lon, depth);
        var11_18 = var2_17;
        lat = var11_18._1();
        lon = var11_18._2();
        depth = var11_18._3();
        line = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "\\t", "\\t", "\\t", "\\t", "\\t", "\\t", "\\t", "\\t", "\\t", "\\t", "\\t", "\\t", "\\t", "\\t", "\\t", "\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{va.getName(), vf.getTimecode(), d, obs.getConceptName(), lat, lon, depth, ((HasPoint)p._1()).point().getX(), ((HasPoint)p._1()).point().getY(), ((HasPoint)p._2()).point().getX(), ((HasPoint)p._2()).point().getY(), ((HasPoint)p._3()).point().getX(), ((HasPoint)p._3()).point().getY(), ((AMContainer)p._1()).areaMeasurement().getComment(), ((AMContainer)p._1()).link().getOrElse((Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$write$2(), ()Ljava/lang/String;)()), img}));
        writer$1.write(line);
    }

    private PointsApp$() {
        MODULE$ = this;
        this.dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss'Z'");
    }
}

