/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.smith;

import org.mbari.smith.Camera;
import org.mbari.smith.Pixel$;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.immutable.List;
import scala.math.package$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\r4A!\u0001\u0002\u0001\u0013\t)\u0001+\u001b=fY*\u00111\u0001B\u0001\u0006g6LG\u000f\u001b\u0006\u0003\u000b\u0019\tQ!\u001c2be&T\u0011aB\u0001\u0004_J<7\u0001A\n\u0003\u0001)\u0001\"a\u0003\b\u000e\u00031Q\u0011!D\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001f1\u0011a!\u00118z%\u00164\u0007\u0002C\t\u0001\u0005\u000b\u0007I\u0011\u0001\n\u0002\r\r\fW.\u001a:b+\u0005\u0019\u0002C\u0001\u000b\u0016\u001b\u0005\u0011\u0011B\u0001\f\u0003\u0005\u0019\u0019\u0015-\\3sC\"A\u0001\u0004\u0001B\u0001B\u0003%1#A\u0004dC6,'/\u0019\u0011\t\u0011i\u0001!Q1A\u0005\u0002m\tQa^5ei\",\u0012\u0001\b\t\u0003\u0017uI!A\b\u0007\u0003\u0007%sG\u000f\u0003\u0005!\u0001\t\u0005\t\u0015!\u0003\u001d\u0003\u00199\u0018\u000e\u001a;iA!A!\u0005\u0001BC\u0002\u0013\u00051$\u0001\u0004iK&<\u0007\u000e\u001e\u0005\tI\u0001\u0011\t\u0011)A\u00059\u00059\u0001.Z5hQR\u0004\u0003\u0002\u0003\u0014\u0001\u0005\u000b\u0007I\u0011A\u000e\u0002\u0003aD\u0001\u0002\u000b\u0001\u0003\u0002\u0003\u0006I\u0001H\u0001\u0003q\u0002B\u0001B\u000b\u0001\u0003\u0006\u0004%\taG\u0001\u0002s\"AA\u0006\u0001B\u0001B\u0003%A$\u0001\u0002zA!)a\u0006\u0001C\u0001_\u00051A(\u001b8jiz\"b\u0001M\u00193gQ*\u0004C\u0001\u000b\u0001\u0011\u0015\tR\u00061\u0001\u0014\u0011\u0015QR\u00061\u0001\u001d\u0011\u0015\u0011S\u00061\u0001\u001d\u0011\u00151S\u00061\u0001\u001d\u0011\u0015QS\u00061\u0001\u001d\u0011\u001d9\u0004A1A\u0005\u0002a\nQ!\u00197qQ\u0006,\u0012!\u000f\t\u0003\u0017iJ!a\u000f\u0007\u0003\r\u0011{WO\u00197f\u0011\u0019i\u0004\u0001)A\u0005s\u00051\u0011\r\u001c9iC\u0002Bqa\u0010\u0001C\u0002\u0013\u0005\u0001(\u0001\u0003cKR\f\u0007BB!\u0001A\u0003%\u0011(A\u0003cKR\f\u0007\u0005C\u0004D\u0001\t\u0007I\u0011\u0001\u001d\u0002\u0013a$\u0015n\u001d;b]\u000e,\u0007BB#\u0001A\u0003%\u0011(\u0001\u0006y\t&\u001cH/\u00198dK\u0002Bqa\u0012\u0001C\u0002\u0013\u0005\u0001(A\u0005z\t&\u001cH/\u00198dK\"1\u0011\n\u0001Q\u0001\ne\n!\"\u001f#jgR\fgnY3!\u000f\u0015Y%\u0001#\u0001M\u0003\u0015\u0001\u0016\u000e_3m!\t!RJB\u0003\u0002\u0005!\u0005aj\u0005\u0002N\u0015!)a&\u0014C\u0001!R\tA\nC\u0003S\u001b\u0012\u00051+\u0001\u0007j[\u0006<WmQ8s]\u0016\u00148\u000f\u0006\u0003UA\u0006\u0014\u0007cA+^a9\u0011ak\u0017\b\u0003/jk\u0011\u0001\u0017\u0006\u00033\"\ta\u0001\u0010:p_Rt\u0014\"A\u0007\n\u0005qc\u0011a\u00029bG.\fw-Z\u0005\u0003=~\u0013A\u0001T5ti*\u0011A\f\u0004\u0005\u0006#E\u0003\ra\u0005\u0005\u00065E\u0003\r\u0001\b\u0005\u0006EE\u0003\r\u0001\b")
public class Pixel {
    private final Camera camera;
    private final int width;
    private final int height;
    private final int x;
    private final int y;
    private final double alpha;
    private final double beta;
    private final double xDistance;
    private final double yDistance;

    public static List<Pixel> imageCorners(Camera camera, int n, int n2) {
        return Pixel$.MODULE$.imageCorners(camera, n, n2);
    }

    public Camera camera() {
        return this.camera;
    }

    public int width() {
        return this.width;
    }

    public int height() {
        return this.height;
    }

    public int x() {
        return this.x;
    }

    public int y() {
        return this.y;
    }

    public double alpha() {
        return this.alpha;
    }

    public double beta() {
        return this.beta;
    }

    public double xDistance() {
        return this.xDistance;
    }

    public double yDistance() {
        return this.yDistance;
    }

    public Pixel(Camera camera, int width, int height, int x, int y) {
        this.camera = camera;
        this.width = width;
        this.height = height;
        this.x = x;
        this.y = y;
        Predef$.MODULE$.require(x >= 0 && x <= width, (Function0 & java.io.Serializable & Serializable)() -> "x must be between 0 and " + this.width() + ". You supplied " + this.x());
        Predef$.MODULE$.require(y >= 0 && y <= width, (Function0 & java.io.Serializable & Serializable)() -> "y must be between 0 and " + this.height() + ". You supplied " + this.x());
        double bp = (double)height / 2.0;
        double ip = bp - (double)y;
        this.alpha = package$.MODULE$.atan(ip * package$.MODULE$.tan(camera.alpha() / 2.0) / bp);
        int gp = width / 2;
        int ip2 = gp - x;
        this.beta = package$.MODULE$.atan((double)ip2 * package$.MODULE$.tan(camera.beta() / 2.0) / (double)gp) * (double)-1;
        double oiDistance = camera.height() / package$.MODULE$.sin(camera.theta() - this.alpha());
        this.xDistance = oiDistance * package$.MODULE$.tan(this.beta());
        this.yDistance = camera.height() / package$.MODULE$.tan(camera.theta() - this.alpha());
    }
}

