/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.smith;

import java.awt.Polygon;
import java.io.Serializable;
import java.net.URL;
import org.mbari.smith.Camera;
import org.mbari.smith.CanadianGrid$;
import org.mbari.smith.DetritalPolygons;
import org.mbari.smith.RealArea;
import org.mbari.smith.VirtualPolygon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.math.Numeric;
import scala.runtime.BoxesRunTime;
import vars.annotation.VideoArchive;
import vars.annotation.VideoArchiveDAO;
import vars.annotation.VideoFrame;
import vars.annotation.ui.StateLookup;
import vars.annotation.ui.ToolBelt;

public final class CoverageEstimator$ {
    public static CoverageEstimator$ MODULE$;
    private final Logger log;
    private final ToolBelt toolBelt;
    private int imageWidth;
    private int imageHeight;
    private boolean gotDimensions;

    static {
        new CoverageEstimator$();
    }

    public List<RealArea> apply(String videoArchiveName, Camera camera) {
        List<DetritalPolygons> frameAreas0 = CanadianGrid$.MODULE$.toDetrialPolygons(this.fetchAnnotations(videoArchiveName));
        this.log.debug("Found " + frameAreas0.size() + " areaMeasurements");
        List frameAreas1 = (List)frameAreas0.map((Function1 & Serializable & scala.Serializable)x$1 -> MODULE$.keepAnnotationsWithinFOV((DetritalPolygons)x$1), List$.MODULE$.canBuildFrom());
        this.log.debug("Found " + frameAreas1.size() + " areaMeasurements within FOV");
        return this.toArea((List<DetritalPolygons>)frameAreas1, camera);
    }

    public List<VideoFrame> fetchAnnotations(String videoArchiveName) {
        List list;
        VideoArchiveDAO dao = this.toolBelt.getAnnotationDAOFactory().newVideoArchiveDAO();
        dao.startTransaction();
        Option option = Option$.MODULE$.apply((Object)dao.findByName(videoArchiveName));
        if (option instanceof Some) {
            Some some = (Some)option;
            VideoArchive videoArchive = (VideoArchive)some.value();
            list = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(videoArchive.getVideoFrames()).asScala()).toList();
        } else if (None$.MODULE$.equals(option)) {
            this.log.info("No VideoArchive named " + videoArchiveName + " was found in the database");
            list = List$.MODULE$.empty();
        } else {
            throw new MatchError((Object)option);
        }
        List list2 = list;
        dao.endTransaction();
        return list2;
    }

    private DetritalPolygons keepAnnotationsWithinFOV(DetritalPolygons frameAreas) {
        Polygon fovPolygon = frameAreas.fov().polygon();
        List intersect = (List)frameAreas.detritus().filter((Function1 & Serializable & scala.Serializable)fa -> BoxesRunTime.boxToBoolean((boolean)fovPolygon.intersects(fa.polygon().getBounds2D())));
        this.log.debug(Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)frameAreas.videoFrame()), " has ") + intersect.size() + " measurements in the FOV");
        List x$2 = intersect;
        VideoFrame x$3 = frameAreas.copy$default$1();
        VirtualPolygon x$4 = frameAreas.copy$default$2();
        return frameAreas.copy(x$3, x$4, (List<VirtualPolygon>)x$2);
    }

    private List<RealArea> toArea(List<DetritalPolygons> frameAreas, Camera camera) {
        return (List)frameAreas.map((Function1 & Serializable & scala.Serializable)fa -> {
            if (!CoverageEstimator$.MODULE$.gotDimensions) {
                Tuple2<Object, Object> d = CanadianGrid$.MODULE$.imageDimensions(new URL(fa.videoFrame().getCameraData().getImageReference()));
                CoverageEstimator$.MODULE$.imageWidth = d._1$mcI$sp();
                CoverageEstimator$.MODULE$.imageHeight = d._2$mcI$sp();
                CoverageEstimator$.MODULE$.gotDimensions = true;
            }
            double totalFovArea = CanadianGrid$.MODULE$.calculateArea(fa.fov().areaMeasurement(), CoverageEstimator$.MODULE$.imageWidth, CoverageEstimator$.MODULE$.imageHeight, camera);
            List detritalAreas = (List)fa.detritus().map((Function1 & Serializable & scala.Serializable)ap -> BoxesRunTime.boxToDouble((double)CanadianGrid$.MODULE$.calculateArea(ap.areaMeasurement(), CoverageEstimator$.MODULE$.imageWidth, CoverageEstimator$.MODULE$.imageHeight, camera)), List$.MODULE$.canBuildFrom());
            CoverageEstimator$.MODULE$.log.debug(BoxesRunTime.unboxToDouble((Object)detritalAreas.sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) + "");
            return new RealArea(fa.videoFrame(), totalFovArea, BoxesRunTime.unboxToDouble((Object)detritalAreas.sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)));
        }, List$.MODULE$.canBuildFrom());
    }

    private CoverageEstimator$() {
        MODULE$ = this;
        this.log = LoggerFactory.getLogger(this.getClass());
        this.toolBelt = (ToolBelt)StateLookup.GUICE_INJECTOR.getInstance(ToolBelt.class);
        this.gotDimensions = false;
    }
}

