/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.smith;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.Serializable;
import java.net.URL;
import java.text.SimpleDateFormat;
import org.mbari.smith.Camera;
import org.mbari.smith.Camera$;
import org.mbari.smith.CameraView;
import org.mbari.smith.CanadianGrid$;
import org.mbari.smith.CoverageEstimator$;
import org.mbari.smith.Pixel;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import vars.ILink;
import vars.annotation.Association;
import vars.annotation.Observation;
import vars.annotation.PhysicalData;
import vars.annotation.VideoArchive;
import vars.annotation.VideoFrame;
import vars.annotation.ui.imagepanel.Measurement;

public final class CanadianGridDistanceApp$ {
    public static CanadianGridDistanceApp$ MODULE$;
    private final SimpleDateFormat dateFormat;

    static {
        new CanadianGridDistanceApp$();
    }

    public Iterable<Tuple2<Association, Object>> read(String videoArchiveName, double cameraHeight, double alpha, double beta, double theta) {
        List<VideoFrame> videoFrames = CoverageEstimator$.MODULE$.fetchAnnotations(videoArchiveName);
        List associations = (List)videoFrames.flatMap((Function1 & Serializable & scala.Serializable)vf -> (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(vf.getObservations()).asScala()).flatMap((Function1 & Serializable & scala.Serializable)obs -> (Set)((TraversableLike)JavaConverters$.MODULE$.asScalaSetConverter(obs.getAssociations()).asScala()).withFilter((Function1 & Serializable & scala.Serializable)ass -> BoxesRunTime.boxToBoolean((boolean)CanadianGridDistanceApp$.$anonfun$read$3(ass))).map((Function1 & Serializable & scala.Serializable)ass -> ass, Set$.MODULE$.canBuildFrom()), Buffer$.MODULE$.canBuildFrom()), List$.MODULE$.canBuildFrom());
        Camera camera = Camera$.MODULE$.fromRadians(cameraHeight, alpha, beta, theta, Camera$.MODULE$.fromRadians$default$5());
        Option vf2 = videoFrames.find((Function1 & Serializable & scala.Serializable)v -> BoxesRunTime.boxToBoolean((boolean)CanadianGridDistanceApp$.$anonfun$read$5(v)));
        URL url = (URL)vf2.map((Function1 & Serializable & scala.Serializable)v -> new URL(v.getCameraData().getImageReference())).get();
        Tuple2<Object, Object> imageDimensions = CanadianGrid$.MODULE$.imageDimensions(url);
        CameraView cameraView = new CameraView(camera, imageDimensions._1$mcI$sp(), imageDimensions._2$mcI$sp());
        Iterable measurements = (Iterable)((List)((TraversableLike)associations.map((Function1 & Serializable & scala.Serializable)a -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(a), (Object)Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> Measurement.fromLink((ILink)a)).toOption()), List$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)CanadianGridDistanceApp$.$anonfun$read$10(p)))).map((Function1 & Serializable & scala.Serializable)p -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(p._1()), ((Option)p._2()).get()), List$.MODULE$.canBuildFrom());
        return (Iterable)measurements.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)CanadianGridDistanceApp$.$anonfun$read$12(check$ifrefutable$1))).map((Function1 & Serializable & scala.Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Association a = (Association)tuple2._1();
            Measurement m = (Measurement)tuple2._2();
            Pixel p0 = new Pixel(cameraView.camera(), cameraView.imageWidth(), cameraView.imageHeight(), m.getX0(), m.getY0());
            Pixel p1 = new Pixel(cameraView.camera(), cameraView.imageWidth(), cameraView.imageHeight(), m.getX1(), m.getY1());
            double x = package$.MODULE$.abs(p0.xDistance() - p1.xDistance());
            double y = package$.MODULE$.abs(p0.yDistance() - p1.yDistance());
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)a), (Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.sqrt(x * x + y * y)));
            return tuple22;
        }, Iterable$.MODULE$.canBuildFrom());
    }

    public void write(Iterable<Tuple2<Association, Object>> distances, File file) {
        BufferedWriter writer = new BufferedWriter(new FileWriter(file));
        writer.write("VideoArchiveName\tTimecode\tRecordedDate\tConceptName\tLatitude\tLongitude\tDepth\tMeasurementLength\tComment\tAssociation\tImage\tObserver\tObservationID\n");
        distances.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)CanadianGridDistanceApp$.$anonfun$write$1(check$ifrefutable$2))).foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            CanadianGridDistanceApp$.$anonfun$write$2(writer, x$3);
            return BoxedUnit.UNIT;
        });
        writer.close();
    }

    public void main(String[] args) {
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).size() != 6) {
            Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("\n                | Script that converts any 'measurement' associations found in your VARS query results\n                | and converts them to distances in the same units as the cameraHeight\n                |\n                | Usage:\n                |   CanadianGridDistanceApp <cameraHeight> <alpha> <beta> <theta> <videoArchiveName> <outputFile>\n                |\n                | Arguments:\n                |    cameraHeight:     The height of the camera above the seafloor. All area measurements will\n                |                      be in the same units as cameraHeight (i.e. you should use centimeters\n                |                      instead of meters)\n                |    alpha:            The vertical angular field of view in degrees\n                |    beta:             The horizontal angular field of view in degrees\n                |    theta:            The tilt of the camera from horizontal in degrees\n                |    videoArchiveName: The VideoArchive to process\n                |    targetFile:       The name of the file to write to\n              ")).stripMargin('|'));
        } else {
            double cameraHeight = new StringOps(Predef$.MODULE$.augmentString(args[0])).toDouble();
            double alpha = RichDouble$.MODULE$.toRadians$extension(Predef$.MODULE$.doubleWrapper(new StringOps(Predef$.MODULE$.augmentString(args[1])).toDouble()));
            double beta = RichDouble$.MODULE$.toRadians$extension(Predef$.MODULE$.doubleWrapper(new StringOps(Predef$.MODULE$.augmentString(args[2])).toDouble()));
            double theta = RichDouble$.MODULE$.toRadians$extension(Predef$.MODULE$.doubleWrapper(new StringOps(Predef$.MODULE$.augmentString(args[3])).toDouble()));
            String videoArchiveName = args[4];
            File targetFile = new File(args[5]);
            Iterable<Tuple2<Association, Object>> dists = this.read(videoArchiveName, cameraHeight, alpha, beta, theta);
            this.write(dists, targetFile);
        }
    }

    public static final /* synthetic */ boolean $anonfun$read$3(Association ass) {
        String string = ass.getLinkName();
        String string2 = "measurement in pixels [x0 y0 x1 y1 comment]";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$read$5(VideoFrame v) {
        boolean bl;
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> v.getCameraData().getImageReference());
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            String i = (String)success.value();
            bl = i != null;
        } else if (try_ instanceof Failure) {
            bl = false;
        } else {
            throw new MatchError((Object)try_);
        }
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$read$10(Tuple2 p) {
        return ((Option)p._2()).isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$read$12(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$write$1(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$write$2(BufferedWriter writer$1, Tuple2 x$3) {
        Tuple3 tuple3;
        String img;
        String date;
        Object observationID;
        String observer;
        Measurement meas;
        VideoArchive va;
        VideoFrame vf;
        Observation obs;
        double dist;
        Association ass;
        Tuple2 tuple2 = x$3;
        if (tuple2 != null) {
            Tuple3 tuple32;
            ass = (Association)tuple2._1();
            dist = tuple2._2$mcD$sp();
            obs = ass.getObservation();
            vf = obs.getVideoFrame();
            va = vf.getVideoArchive();
            meas = Measurement.fromLink((ILink)ass);
            observer = obs.getObserver();
            observationID = obs.getPrimaryKey();
            date = vf.getRecordedDate() == null ? "" : CanadianGridDistanceApp$.MODULE$.dateFormat.format(vf.getRecordedDate());
            img = vf.getCameraData() == null ? "" : vf.getCameraData().getImageReference();
            Option option = Option$.MODULE$.apply((Object)vf.getPhysicalData());
            if (None$.MODULE$.equals(option)) {
                tuple32 = new Tuple3((Object)BoxesRunTime.boxToDouble((double)Double.NaN), (Object)BoxesRunTime.boxToDouble((double)Double.NaN), (Object)BoxesRunTime.boxToDouble((double)Double.NaN));
            } else if (option instanceof Some) {
                Some some = (Some)option;
                PhysicalData p = (PhysicalData)some.value();
                tuple32 = new Tuple3((Object)p.getLatitude(), (Object)p.getLongitude(), (Object)p.getDepth());
            } else {
                throw new MatchError((Object)option);
            }
            Tuple3 tuple33 = tuple32;
            if (tuple33 == null) {
                throw new MatchError((Object)tuple33);
            }
            Object lat = tuple33._1();
            Object lon = tuple33._2();
            Object depth = tuple33._3();
            tuple3 = new Tuple3(lat, lon, depth);
        } else {
            throw new MatchError((Object)tuple2);
        }
        Tuple3 tuple34 = tuple3;
        Object lat = tuple34._1();
        Object lon = tuple34._2();
        Object depth = tuple34._3();
        String line = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "\\t", "\\t", "\\t", "\\t", "\\t", "\\t", "\\t", "\\t", "\\t", "\\t", "\\t", "\\t", "\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{va.getName(), vf.getTimecode(), date, obs.getConceptName(), lat, lon, depth, BoxesRunTime.boxToDouble((double)dist), meas.getComment(), ass, img, observer, observationID}));
        writer$1.write(line);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private CanadianGridDistanceApp$() {
        MODULE$ = this;
        this.dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss'Z'");
    }
}

