/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.smith;

import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.net.URL;
import javax.imageio.ImageIO;
import org.mbari.smith.Camera;
import org.mbari.smith.DetritalPolygons;
import org.mbari.smith.Pixel;
import org.mbari.smith.VirtualPolygon;
import org.mbari.smith.VirtualPolygon$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Range;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import vars.ILink;
import vars.annotation.AreaMeasurement;
import vars.annotation.Association;
import vars.annotation.VideoFrame;

public final class CanadianGrid$ {
    public static CanadianGrid$ MODULE$;
    private final Logger log;

    static {
        new CanadianGrid$();
    }

    public Tuple2<Object, Object> imageDimensions(URL image) {
        this.log.debug("Reading " + image);
        return new Tuple2.mcII.sp(CanadianGrid$.img$1(image).getWidth(), CanadianGrid$.img$1(image).getHeight());
    }

    public double calculateArea(AreaMeasurement areaMeasurement, int imageWidth, int imageHeight, Camera camera) {
        Buffer coords = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(areaMeasurement.getCoordinates()).asScala();
        Buffer pixels = (Buffer)coords.map((Function1 & Serializable & scala.Serializable)p -> new Pixel(camera, imageWidth, imageHeight, Predef$.MODULE$.Integer2int((Integer)p.getX()), Predef$.MODULE$.Integer2int((Integer)p.getY())), Buffer$.MODULE$.canBuildFrom());
        int n = coords.size();
        Range i1 = RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), n);
        IndexedSeq i2 = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), n).$colon$plus((Object)BoxesRunTime.boxToInteger((int)0), IndexedSeq$.MODULE$.canBuildFrom());
        DoubleRef p1 = DoubleRef.create((double)0.0);
        DoubleRef p2 = DoubleRef.create((double)0.0);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), n).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            p1$1.elem += ((Pixel)pixels.apply(i1.apply$mcII$sp(i))).xDistance() * ((Pixel)pixels.apply(BoxesRunTime.unboxToInt((Object)i2.apply(i)))).yDistance();
            p2$1.elem += ((Pixel)pixels.apply(BoxesRunTime.unboxToInt((Object)i2.apply(i)))).xDistance() * ((Pixel)pixels.apply(i1.apply$mcII$sp(i))).yDistance();
        });
        return package$.MODULE$.abs((p1.elem - p2.elem) / (double)2);
    }

    public List<DetritalPolygons> toDetrialPolygons(List<VideoFrame> videoFrames) {
        List frameAreas = (List)videoFrames.map((Function1 & Serializable & scala.Serializable)vf -> MODULE$.toDetritalPolygon((VideoFrame)vf), List$.MODULE$.canBuildFrom());
        return ((List)frameAreas.flatten((Function1 & Serializable & scala.Serializable)xo -> Option$.MODULE$.option2Iterable(xo))).toList();
    }

    public Seq<AreaMeasurement> extractAreaMeasurements(VideoFrame videoFrame) {
        return (Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(videoFrame.getObservations()).asScala()).flatMap((Function1 & Serializable & scala.Serializable)obs -> (Set)((TraversableLike)JavaConverters$.MODULE$.asScalaSetConverter(obs.getAssociations()).asScala()).withFilter((Function1 & Serializable & scala.Serializable)ass -> BoxesRunTime.boxToBoolean((boolean)CanadianGrid$.$anonfun$extractAreaMeasurements$2(ass))).map((Function1 & Serializable & scala.Serializable)ass -> AreaMeasurement.fromLink((ILink)ass), Set$.MODULE$.canBuildFrom()), Buffer$.MODULE$.canBuildFrom());
    }

    public Option<DetritalPolygons> toDetritalPolygon(VideoFrame videoFrame) {
        ObjectRef fov = ObjectRef.create((Object)None$.MODULE$);
        ObjectRef detritus = ObjectRef.create((Object)new ListBuffer());
        this.extractAreaMeasurements(videoFrame).foreach((Function1 & Serializable & scala.Serializable)areaMeasurement -> {
            ListBuffer listBuffer;
            VirtualPolygon areaPolygon = VirtualPolygon$.MODULE$.apply((AreaMeasurement)areaMeasurement);
            if (areaMeasurement.getComment().contains("fov")) {
                fov$1.elem = Option$.MODULE$.apply((Object)areaPolygon);
                listBuffer = BoxedUnit.UNIT;
            } else {
                listBuffer = ((ListBuffer)detritus$1.elem).$plus$eq((Object)areaPolygon);
            }
            return listBuffer;
        });
        return ((Option)fov.elem).map((Function1 & Serializable & scala.Serializable)x$1 -> new DetritalPolygons(videoFrame, (VirtualPolygon)x$1, (List<VirtualPolygon>)((ListBuffer)detritus$1.elem).toList()));
    }

    private static final BufferedImage img$1(URL image$1) {
        return ImageIO.read(image$1);
    }

    public static final /* synthetic */ boolean $anonfun$extractAreaMeasurements$2(Association ass) {
        String string = ass.getLinkName();
        String string2 = "area measurement coordinates [x0 y0 ... xn yn; comment]";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private CanadianGrid$() {
        MODULE$ = this;
        this.log = LoggerFactory.getLogger(this.getClass());
    }
}

