/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.samples.integration;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.mbari.samples.integration.DatabaseUtility;

public class UpdateSampleKeywords {
    private DatabaseUtility databaseUtility = new DatabaseUtility();
    protected Connection con;
    private Collection keywords;
    private Collection seeds = new LinkedList();
    private PreparedStatement stmtDel;
    private PreparedStatement stmtIns;
    private PreparedStatement stmtUpd;

    public UpdateSampleKeywords() throws Exception {
        this.keywords = new LinkedList();
        try {
            this.con = this.databaseUtility.newConnection();
            this.stmtIns = this.con.prepareStatement("INSERT INTO VIMSkeywords (SampleID, KeywordString) VALUES (?,?)");
            this.stmtDel = this.con.prepareStatement("DELETE FROM VIMSkeywords WHERE SampleID = ?");
            this.stmtUpd = this.con.prepareStatement("UPDATE Sample SET KeywordLookupStatus = ? WHERE SampleID = ?");
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
            ex.printStackTrace();
            throw ex;
        }
    }

    public void cleanup() {
        this.seeds.clear();
        this.keywords.clear();
        try {
            this.con.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
            ex.printStackTrace();
        }
    }

    public static void main(String[] args) {
        int exitStatus = 0;
        if (args.length != 1) {
            System.err.println("Usage: UpdateSampleKeywords Sample_ID");
            System.err.println(" SampleID = SQL database ID of the Sample");
            System.exit(1);
        }
        UpdateSampleKeywords usk = null;
        try {
            usk = new UpdateSampleKeywords();
            int sampleID = Integer.parseInt(args[0]);
            int num = usk.populateSampleKeywords(sampleID);
            System.out.println(num + " keywords entered for SampleID: " + sampleID);
        }
        catch (Exception ex) {
            System.out.println("Exception: " + ex.getMessage());
            ex.printStackTrace();
            exitStatus = 1;
        }
        if (usk != null) {
            usk.cleanup();
        }
        System.exit(exitStatus);
    }

    public int populateSampleKeywords(int SampleId) throws Exception {
        int result = 0;
        this.seeds.clear();
        this.keywords.clear();
        try {
            this.stmtDel.setInt(1, SampleId);
            this.stmtDel.executeUpdate();
            Statement stmt = this.con.createStatement();
            ResultSet rs = stmt.executeQuery("SELECT SeedConcept FROM SeedVIMSConcepts WHERE SampleID = " + SampleId);
            while (rs.next()) {
                this.seeds.add(rs.getString(1));
            }
        }
        catch (SQLException ex) {
            System.err.println("Select SQLException: " + ex.getMessage());
            result = -100;
            throw ex;
        }
        int keywordStatus = 0;
        if (this.seeds.isEmpty()) {
            keywordStatus = 2;
        } else {
            LinkedList<String> tmpKeywords = new LinkedList<String>();
            this.keywords.clear();
            Iterator seedsIt = this.seeds.iterator();
            while (seedsIt.hasNext()) {
                tmpKeywords.clear();
                try {
                    String kwString = (String)seedsIt.next();
                    tmpKeywords.addAll(this.databaseUtility.getKeywords(kwString));
                    if (tmpKeywords.isEmpty()) {
                        keywordStatus = 2;
                        continue;
                    }
                    for (String strKeyword : tmpKeywords) {
                        if (this.keywords.contains(strKeyword)) continue;
                        this.keywords.add(strKeyword);
                    }
                    String strObject = "Object";
                    String strPhysicalObject = "Physical object";
                    LinkedList lkeywords = (LinkedList)this.keywords;
                    int i = lkeywords.indexOf(strObject);
                    if (i >= 0) {
                        lkeywords.remove(i);
                    }
                    if ((i = lkeywords.indexOf(strPhysicalObject)) < 0) continue;
                    lkeywords.remove(i);
                }
                catch (Exception ex) {
                    System.err.println("VimsException: " + ex.getMessage());
                    result = -100;
                    throw ex;
                }
            }
        }
        if (!this.keywords.isEmpty()) {
            try {
                this.stmtIns.setInt(1, SampleId);
                Iterator keyIt = this.keywords.iterator();
                while (keyIt.hasNext()) {
                    this.stmtIns.setString(2, (String)keyIt.next());
                    this.stmtIns.executeUpdate();
                    ++result;
                }
            }
            catch (SQLException ex) {
                System.err.println("SQLException: " + ex.getMessage());
                throw ex;
            }
        }
        try {
            this.stmtUpd.setInt(1, keywordStatus);
            this.stmtUpd.setInt(2, SampleId);
            this.stmtUpd.executeUpdate();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
            throw ex;
        }
        return result;
    }
}

