/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.samples.integration;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.LinkedList;
import org.mbari.samples.integration.UpdateSampleKeywords;

public class UpdateAllSampleKeywords
extends UpdateSampleKeywords {
    private Collection sampleIds = new LinkedList();

    @Override
    public void cleanup() {
        this.sampleIds.clear();
        super.cleanup();
    }

    public static void main(String[] args) {
        int exitStatus = 0;
        if (args.length != 0) {
            System.err.println("Usage: UpdateSampleKeywords");
            System.exit(1);
        }
        UpdateAllSampleKeywords usk = null;
        try {
            usk = new UpdateAllSampleKeywords();
            int num = usk.populateAllSampleKeywords();
            if (num < 0) {
                System.out.println(num + " Samples had problems");
            } else {
                System.out.println("UpdateAllSampleKeywords successful, " + num + " Samples updated!");
            }
        }
        catch (Exception ex) {
            System.out.println("Exception: " + ex.getMessage());
            ex.printStackTrace();
            exitStatus = 1;
        }
        if (usk != null) {
            usk.cleanup();
        }
        System.exit(exitStatus);
    }

    public int populateAllSampleKeywords() throws Exception {
        int result;
        this.sampleIds.clear();
        try {
            Statement stmt = this.con.createStatement();
            ResultSet rs = stmt.executeQuery("SELECT SampleID FROM Sample WHERE KeywordLookupStatus <> 0");
            while (rs.next()) {
                Integer newInteger = new Integer(rs.getInt(1));
                this.sampleIds.add(newInteger);
            }
        }
        catch (SQLException ex) {
            System.err.println("KeywordLookup SQLException: " + ex.getMessage());
            ex.printStackTrace();
            throw ex;
        }
        int numSuccess = 0;
        if (!this.sampleIds.isEmpty()) {
            for (Integer tmpInteger : this.sampleIds) {
                int sampleId = tmpInteger;
                try {
                    System.out.print("SampleID: " + sampleId);
                    int numKeywords = this.populateSampleKeywords(sampleId);
                    System.out.println("  - Keywords Found: " + numKeywords);
                    ++numSuccess;
                }
                catch (Exception ex) {
                    System.err.println("SampleID: " + sampleId + ", Exception: " + ex.getMessage());
                    ex.printStackTrace();
                }
            }
        }
        if ((result = numSuccess - this.sampleIds.size()) == 0) {
            result = this.sampleIds.size();
        }
        return result;
    }
}

