/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.samples.integration;

import com.google.inject.Injector;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.mbari.sql.IQueryable;
import org.mbari.sql.QueryableImpl;
import vars.ToolBelt;
import vars.knowledgebase.Concept;
import vars.knowledgebase.ConceptDAO;
import vars.knowledgebase.ConceptName;
import vars.knowledgebase.ui.StateLookup;

class DatabaseUtility {
    public final String jdbcDriver = "net.sourceforge.jtds.jdbc.Driver";
    public final String jdbcPassword = "samp";
    public final String jdbcUrl = "jdbc:jtds:sqlserver://perseus.shore.mbari.org:1433/MBARI_Samples";
    public final String jdbcUsername = "samp";
    public final IQueryable samplesDatabase = new QueryableImpl("jdbc:jtds:sqlserver://perseus.shore.mbari.org:1433/MBARI_Samples", "samp", "samp", "net.sourceforge.jtds.jdbc.Driver");
    protected final ToolBelt toolBelt;

    public DatabaseUtility() {
        Injector injector = StateLookup.GUICE_INJECTOR;
        this.toolBelt = (ToolBelt)injector.getInstance(ToolBelt.class);
    }

    public List<String> getKeywords(String conceptName) {
        LinkedList<String> keywords = new LinkedList<String>();
        ConceptDAO dao = this.toolBelt.getKnowledgebaseDAOFactory().newConceptDAO();
        for (Concept concept = dao.findByName(conceptName); concept != null; concept = concept.getParentConcept()) {
            Set conceptNames = concept.getConceptNames();
            for (ConceptName name : conceptNames) {
                StringBuilder sb = new StringBuilder(name.getName().replace('-', ' '));
                sb.setCharAt(0, Character.toUpperCase(sb.charAt(0)));
                keywords.add(sb.toString());
            }
        }
        return keywords;
    }

    public Connection newConnection() {
        Connection connection = null;
        try {
            connection = DriverManager.getConnection("jdbc:jtds:sqlserver://perseus.shore.mbari.org:1433/MBARI_Samples", "samp", "samp");
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return connection;
    }
}

