/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.biauv.integration;

import java.io.File;
import java.io.FileInputStream;
import java.io.Serializable;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mbari.biauv.integration.LogRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class LogRecordReader$ {
    public static LogRecordReader$ MODULE$;
    private final Logger log;

    static {
        new LogRecordReader$();
    }

    private Logger log() {
        return this.log;
    }

    public List<LogRecord> read(File file) {
        long startTime = System.nanoTime();
        this.log().debug("Reading " + file.getCanonicalPath());
        FileInputStream fileInputStream = new FileInputStream(file);
        FileChannel fileChannel = fileInputStream.getChannel();
        MappedByteBuffer mappedByteBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, fileChannel.size());
        mappedByteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        Tuple2<List<LogRecord>, Object> tuple2 = this.readHeader(mappedByteBuffer);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        List records = (List)tuple2._1();
        int position = tuple2._2$mcI$sp();
        Tuple2 tuple22 = new Tuple2((Object)records, (Object)BoxesRunTime.boxToInteger((int)position));
        Tuple2 tuple23 = tuple22;
        List records2 = (List)tuple23._1();
        int position2 = tuple23._2$mcI$sp();
        this.log().debug("Found " + records2.size() + " data types");
        records2.foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            Predef$.MODULE$.println((Object)x$2);
            return BoxedUnit.UNIT;
        });
        this.log().debug("Reading binary data, starting at byte " + position2);
        mappedByteBuffer.position(position2);
        int i = 0;
        try {
            while (true) {
                records2.foreach((Function1 & Serializable & scala.Serializable)r -> {
                    LogRecordReader$.$anonfun$read$2(mappedByteBuffer, r);
                    return BoxedUnit.UNIT;
                });
                ++i;
            }
        }
        catch (Throwable throwable) {
            this.log().debug("Done. Found " + i + " records");
            records2.foreach((Function1 & Serializable & scala.Serializable)r -> {
                r.data_$eq((List<Object>)r.data().reverse());
                return BoxedUnit.UNIT;
            });
            double elapsedTime = (double)(System.nanoTime() - startTime) / 1000.0 / 1000.0 / 1000.0;
            return records2;
        }
    }

    private Tuple2<List<LogRecord>, Object> readHeader(MappedByteBuffer mappedByteBuffer) {
        CharsetDecoder charsetDecoder = Charset.forName("ISO-8859-15").newDecoder();
        CharBuffer charBuffer = charsetDecoder.decode(mappedByteBuffer);
        Nil$ records = Nil$.MODULE$;
        Pattern linePattern = Pattern.compile(".*\r?\n");
        Matcher lineMatcher = linePattern.matcher(charBuffer);
        boolean bl = lineMatcher.find();
        int numberOfBytes = 0;
        while (bl) {
            String line = lineMatcher.group().toString();
            numberOfBytes += line.getBytes().length;
            this.log().debug("--- Parsing: " + line.replace('\r', ' ').replace('\n', ' '));
            String[] parts = line.split(" ");
            bl = !parts[1].startsWith("begin");
            if (!bl) continue;
            try {
                String[] otherParts = line.split(",");
                LogRecord logRecord = this.newLogRecord(parts[1], parts[2], otherParts[1], otherParts[2]);
                records = records.$colon$colon((Object)logRecord);
            }
            catch (Throwable throwable) {
                this.log().debug("!!! Invalid line");
            }
            bl = lineMatcher.find();
        }
        return new Tuple2((Object)records.reverse(), (Object)BoxesRunTime.boxToInteger((int)numberOfBytes));
    }

    private LogRecord newLogRecord(String format, String shortName, String longName, String units) {
        String string = format;
        String string2 = "float".equals(string) ? "Float" : ("integer".equals(string) ? "Int" : ("short".equals(string) ? "Short" : "Double"));
        String f = string2;
        String string3 = shortName;
        String string4 = "time".equals(string3) ? "seconds since 1970-01-01 00:00:00Z" : units.replaceAll("[\r\n]", "").trim();
        String u = string4;
        return new LogRecord(f, shortName, longName, u);
    }

    private static final double readValue$1(LogRecord logRecord, MappedByteBuffer mappedByteBuffer$1) {
        double d;
        String string = logRecord.format();
        if ("Float".equals(string)) {
            d = mappedByteBuffer$1.getFloat();
        } else if ("Int".equals(string)) {
            d = mappedByteBuffer$1.getInt();
        } else if ("Short".equals(string)) {
            d = mappedByteBuffer$1.getShort();
        } else if ("Double".equals(string)) {
            d = mappedByteBuffer$1.getDouble();
        } else {
            throw new MatchError((Object)string);
        }
        return d;
    }

    public static final /* synthetic */ void $anonfun$read$2(MappedByteBuffer mappedByteBuffer$1, LogRecord r) {
        double d = LogRecordReader$.readValue$1(r, mappedByteBuffer$1);
        r.data_$eq((List<Object>)r.data().$colon$colon((Object)BoxesRunTime.boxToDouble((double)d)));
    }

    private LogRecordReader$() {
        MODULE$ = this;
        this.log = LoggerFactory.getLogger(this.getClass());
    }
}

