/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.biauv.integration;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.Serializable;
import org.mbari.biauv.integration.LogRecord;
import org.mbari.biauv.integration.LogRecordReader$;
import org.mbari.biauv.integration.MergeData;
import org.mbari.math.Matlib;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple4;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class IOUtilities$ {
    public static IOUtilities$ MODULE$;

    static {
        new IOUtilities$();
    }

    public void main(String[] args) {
        Tuple4<String, File, File, File> tuple4;
        if (args.length != 1 && args.length != 3 && args.length != 4) {
            Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("\n                | Generate a camera data file from an BIAUV mission for loading images\n                | into VARS\n                |\n                | Usage: generate-camdata.scala [missiondir]\n                |        generate-camdata.scala [navigation log] [camera log] [ouput file]\n                |        generate-camdata.scala [navigation log] [camera log] [ouput file] [mission name]\n                |\n                | Inputs:\n                |        missiondir = The path to a mission directory\n                |        navigation log = Path and/or name of the navigation.log to use\n                |        camera log = Path and/or name of the camera.log to use\n                |        output file = Path and/or name of the file to create\n                |        mission name = The name of the mission\n            ")).stripMargin());
            System.exit(-1);
        }
        if ((tuple4 = this.parseArgs(args)) == null) {
            throw new MatchError(tuple4);
        }
        String missionName = (String)tuple4._1();
        File navigationFile = (File)tuple4._2();
        File cameraFile = (File)tuple4._3();
        File targetFile = (File)tuple4._4();
        Tuple4 tuple42 = new Tuple4((Object)missionName, (Object)navigationFile, (Object)cameraFile, (Object)targetFile);
        Tuple4 tuple43 = tuple42;
        String missionName2 = (String)tuple43._1();
        File navigationFile2 = (File)tuple43._2();
        File cameraFile2 = (File)tuple43._3();
        File targetFile2 = (File)tuple43._4();
        MergeData mergeData = this.extractLogRecords(navigationFile2, cameraFile2);
        BufferedWriter writer = new BufferedWriter(new FileWriter(targetFile2));
        writer.write("# Data file for photographs from Mission " + missionName2 + "\n");
        writer.write("# All units are in SI, with angles in radians, unless otherwise noted.\n");
        writer.write("# UnixTime\tPhoto No.\tLat(deg)\tLon(deg)\tDepth\tAltitude\tYaw\tPitch\tRoll\tFOVheight\tFOVwidth\n");
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), mergeData.time().length).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            String msg = new StringOps(Predef$.MODULE$.augmentString("%15.2f\t%4.0f\t%13.8f\t%13.8f\t%7.3f\t%7.3f\t%7.4f\t%7.4f\t%7.4f\t%5.2f\t%5.2f\n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)mergeData.time()[i]), BoxesRunTime.boxToDouble((double)mergeData.photoNumber()[i]), BoxesRunTime.boxToDouble((double)mergeData.latitude()[i]), BoxesRunTime.boxToDouble((double)mergeData.longitude()[i]), BoxesRunTime.boxToDouble((double)mergeData.depth()[i]), BoxesRunTime.boxToDouble((double)mergeData.altitude()[i]), BoxesRunTime.boxToDouble((double)mergeData.yaw()[i]), BoxesRunTime.boxToDouble((double)mergeData.pitch()[i]), BoxesRunTime.boxToDouble((double)mergeData.roll()[i]), BoxesRunTime.boxToDouble((double)mergeData.viewHeight()[i]), BoxesRunTime.boxToDouble((double)mergeData.viewWidth()[i])}));
            writer.write(msg);
        });
        writer.close();
    }

    public MergeData extractLogRecords(File navigationLog, File cameraLog) {
        List<LogRecord> navigationData = LogRecordReader$.MODULE$.read(navigationLog);
        List<LogRecord> cameraData = LogRecordReader$.MODULE$.read(cameraLog);
        double[] navTime = this.extractArray(navigationData, "time");
        double[] mAltitude = this.extractArray(navigationData, "mAltitude");
        double[] mPhi = this.extractArray(navigationData, "mPhi");
        double[] mTheta = this.extractArray(navigationData, "mTheta");
        double[] mPsi = this.extractArray(navigationData, "mPsi");
        double[] cameraTime = this.extractArray(cameraData, "time");
        double[] cameraPhotoNumber = this.extractArray(cameraData, "cam.number");
        double[] cameraLatitude = (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(this.extractArray(cameraData, "cam.latitude"))).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x$2 -> x$2 * 180.0 / Math.PI, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        double[] cameraLongitude = (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(this.extractArray(cameraData, "cam.longitude"))).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x$3 -> x$3 * 180.0 / Math.PI, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        double[] cameraDepth = this.extractArray(cameraData, "cam.depth");
        double[] cameraAltitude = (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(Matlib.interpolate((double[])navTime, (double[])mAltitude, (double[])cameraTime))).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x$4 -> x$4 / package$.MODULE$.cos(0.5235987755982988), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        double[] cameraRoll = Matlib.interpolate((double[])navTime, (double[])mPhi, (double[])cameraTime);
        double[] cameraPitch = Matlib.interpolate((double[])navTime, (double[])mTheta, (double[])cameraTime);
        double[] cameraYaw = Matlib.interpolate((double[])navTime, (double[])mPsi, (double[])cameraTime);
        double focalLength = 28.0;
        double[] viewHeight = (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(cameraAltitude)).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x$5 -> x$5 * 24.0 / focalLength, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        double[] viewWidth = (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(cameraAltitude)).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x$6 -> x$6 * 36.0 / focalLength, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        return new MergeData(cameraTime, cameraPhotoNumber, cameraLatitude, cameraLongitude, cameraDepth, cameraAltitude, cameraYaw, cameraPitch, cameraRoll, viewHeight, viewWidth);
    }

    private Tuple4<String, File, File, File> parseArgs(String[] args) {
        Tuple4 tuple4;
        if (args.length == 1) {
            File missionDir = new File(args[0]);
            String missionName = missionDir.getName();
            File navigationFile = new File(missionDir, "navigation.log");
            File cameraFile = new File(missionDir, "camera.log");
            File targetFile = new File(missionDir, "camera.txt");
            tuple4 = new Tuple4((Object)missionName, (Object)navigationFile, (Object)cameraFile, (Object)targetFile);
        } else {
            File navigationFile = new File(args[0]);
            File cameraFile = new File(args[1]);
            File targetFile = new File(args[2]);
            String missionName = args.length == 4 ? args[3] : "UNKNOWN";
            tuple4 = new Tuple4((Object)missionName, (Object)navigationFile, (Object)cameraFile, (Object)targetFile);
        }
        return tuple4;
    }

    public double[] extractArray(List<LogRecord> records, String name) {
        double[] dArray;
        Predef$.MODULE$.println((Object)("Extracting " + name));
        Option option = records.find((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)IOUtilities$.$anonfun$extractArray$1(name, x$7)));
        if (option instanceof Some) {
            Some some = (Some)option;
            LogRecord x = (LogRecord)some.value();
            dArray = (double[])Predef$.MODULE$.genericArrayOps(x.data().toArray(ClassTag$.MODULE$.AnyVal())).map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToDouble((double)IOUtilities$.$anonfun$extractArray$2(x$8)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        } else if (None$.MODULE$.equals(option)) {
            Predef$.MODULE$.println((Object)("Unable to find LogRecord.shortName == " + name));
            dArray = (double[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Double());
        } else {
            throw new MatchError((Object)option);
        }
        return dArray;
    }

    public static final /* synthetic */ boolean $anonfun$extractArray$1(String name$1, LogRecord x$7) {
        String string = x$7.shortName();
        String string2 = name$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ double $anonfun$extractArray$2(Object x$8) {
        return BoxesRunTime.unboxToDouble((Object)x$8);
    }

    private IOUtilities$() {
        MODULE$ = this;
    }
}

