/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.swing.text;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;
import org.mbari.text.IgnoreCaseToStringComparator;

public class AutoCompleteDocument
extends PlainDocument {
    private static final long serialVersionUID = 984417310787419236L;
    private List dictionary = new ArrayList();
    private Comparator comparator;
    private JTextComponent component;

    public AutoCompleteDocument(JTextComponent field, Collection aDictionary, Comparator comparator) {
        this.component = field;
        this.dictionary.addAll(aDictionary);
        this.comparator = comparator;
        Collections.sort(this.dictionary, comparator);
    }

    public AutoCompleteDocument(JTextComponent field, String[] aDictionary, Comparator comparator) {
        this(field, Arrays.asList(aDictionary), comparator);
    }

    public void addDictionaryEntry(String item) {
        this.dictionary.add(item);
    }

    public String autoComplete(String text) {
        int idx = Collections.binarySearch(this.dictionary, text, this.comparator);
        if (idx < -1) {
            if (idx < 0) {
                idx = -1 * idx - 1;
            }
            if (idx >= this.dictionary.size()) {
                idx = this.dictionary.size() - 1;
            }
        }
        String word = (String)this.dictionary.get(idx);
        return word.substring(text.length());
    }

    public static JTextField createAutoCompleteTextField(String[] dictionary) {
        JTextField field = new JTextField();
        AutoCompleteDocument doc = new AutoCompleteDocument((JTextComponent)field, dictionary, (Comparator)new IgnoreCaseToStringComparator());
        field.setDocument(doc);
        return field;
    }

    @Override
    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        super.insertString(offs, str, a);
        String word = this.autoComplete(this.getText(0, this.getLength()));
        if (word != null) {
            super.insertString(offs + str.length(), word, a);
            this.component.setCaretPosition(offs + str.length());
            this.component.moveCaretPosition(this.getLength());
        }
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("Auto complete demo");
        frame.setDefaultCloseOperation(3);
        String[] dict = new String[]{"auto", "automobile", "autocrat", "graduation"};
        JTextField field = AutoCompleteDocument.createAutoCompleteTextField(dict);
        BoxLayout layout = new BoxLayout(frame.getContentPane(), 0);
        frame.getContentPane().setLayout(layout);
        frame.getContentPane().add(new JLabel("Text Field: "));
        frame.getContentPane().add(field);
        frame.pack();
        frame.setVisible(true);
    }
}

