/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.swing;

import java.util.Collection;
import java.util.Comparator;
import org.mbari.swing.SortedComboBoxModel;
import org.mbari.text.DefaultToStringConverter;
import org.mbari.text.IgnoreCaseToStringComparator;
import org.mbari.text.ObjectToStringConverter;

public class SearchableComboBoxModel<T>
extends SortedComboBoxModel<T> {
    private final ObjectToStringConverter converter;
    private boolean useStartsWith;

    public SearchableComboBoxModel() {
        this((Comparator)new IgnoreCaseToStringComparator());
    }

    public SearchableComboBoxModel(Comparator comparator) {
        this(comparator, new DefaultToStringConverter());
    }

    public SearchableComboBoxModel(Collection objects, Comparator comparator) {
        this(objects, comparator, new DefaultToStringConverter());
    }

    public SearchableComboBoxModel(Comparator comparator, ObjectToStringConverter converter) {
        super(comparator);
        this.converter = converter;
    }

    public SearchableComboBoxModel(Collection objects, Comparator comparator, ObjectToStringConverter converter) {
        super(objects, comparator);
        this.converter = converter;
    }

    private int getStartIndexUsingCurrent() {
        Object item = this.getSelectedItem();
        int startIndex = 0;
        if (item != null) {
            startIndex = this.getItemIndex(item) + 1;
        }
        if (startIndex == this.getSize()) {
            startIndex = 0;
        }
        return startIndex;
    }

    private boolean performStringMatch(String value, String lookFor) {
        if (this.useStartsWith) {
            return value.startsWith(lookFor);
        }
        return -1 < value.indexOf(lookFor);
    }

    private int searchForItem(String s, int startIndex, boolean wrap) {
        int j;
        int size = this.getSize();
        int lastIndex = size - 1;
        if (startIndex > lastIndex) {
            startIndex = wrap ? 0 : lastIndex;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        int index = -1;
        for (j = startIndex; j < size; ++j) {
            if (!this.performStringMatch(this.converter.convert(this.getElementAt(j)), s)) continue;
            index = j;
            break;
        }
        if (index == -1 && wrap) {
            for (j = 0; j < startIndex; ++j) {
                if (!this.performStringMatch(this.converter.convert(this.getElementAt(j)), s)) continue;
                index = j;
                break;
            }
        }
        return index;
    }

    public int searchForItemContaining(String s) {
        return this.searchForItemContaining(s, 0);
    }

    public int searchForItemContaining(String s, boolean wrap) {
        return this.searchForItemContaining(s, this.getStartIndexUsingCurrent(), wrap);
    }

    public int searchForItemContaining(String s, int startIndex) {
        return this.searchForItemContaining(s, startIndex, false);
    }

    public int searchForItemContaining(String s, int startIndex, boolean wrap) {
        this.useStartsWith = false;
        return this.searchForItem(s, startIndex, wrap);
    }

    public int searchForItemStartingWith(String s) {
        return this.searchForItemStartingWith(s, 0);
    }

    public int searchForItemStartingWith(String s, boolean wrap) {
        return this.searchForItemStartingWith(s, this.getStartIndexUsingCurrent(), wrap);
    }

    public int searchForItemStartingWith(String s, int startIndex) {
        return this.searchForItemStartingWith(s, startIndex, false);
    }

    public int searchForItemStartingWith(String s, int startIndex, boolean wrap) {
        this.useStartsWith = true;
        return this.searchForItem(s, startIndex, wrap);
    }
}

