/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.swing;

import java.awt.Graphics2D;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.ProgressMonitor;
import javax.swing.SwingWorker;
import org.mbari.awt.event.ActionAdapter;
import org.mbari.awt.event.ActionRunnable;
import org.mbari.swing.JImageCanvas;
import org.mbari.swing.JImageFrame;
import org.mbari.swing.actions.SaveFramegrabsAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JImageUrlFrame
extends JImageFrame {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private URL imageUrl;
    private JMenuBar theMenuBar;

    public JImageUrlFrame() throws HeadlessException {
        this.initialize();
    }

    public JImageUrlFrame(URL url) throws HeadlessException {
        this();
        this.setImageUrl(url);
    }

    public URL getImageUrl() {
        return this.imageUrl;
    }

    private JMenuBar getTheMenuBar() {
        if (this.theMenuBar == null) {
            this.theMenuBar = new JMenuBar();
            JMenu fileMenu = new JMenu("File");
            this.theMenuBar.add(fileMenu);
            JMenuItem saveItem = new JMenuItem(new SaveImageAction());
            fileMenu.add(saveItem);
        }
        return this.theMenuBar;
    }

    protected void initialize() {
        this.setDefaultCloseOperation(2);
        this.setJMenuBar(this.getTheMenuBar());
    }

    public void setImageUrl(URL newImageUrl) {
        new ImageLoader(newImageUrl).execute();
    }

    public static void main(String[] args) throws Exception {
        URL url1 = args.getClass().getResource("/images/BrianSchlining.jpg");
        URL url2 = args.getClass().getResource("/images/no_image.jpg");
        JImageUrlFrame imageFrame = new JImageUrlFrame();
        imageFrame.setDefaultCloseOperation(3);
        imageFrame.setVisible(true);
        JImageCanvas imageCanvas = (JImageCanvas)imageFrame.getImageDisplayComponent();
        imageFrame.setImageUrl(url1);
    }

    class SaveImageAction
    extends ActionAdapter {
        private final SaveFramegrabsAction action;
        private JFileChooser chooser;

        public SaveImageAction() {
            super("Save Image");
            this.action = new SaveFramegrabsAction();
        }

        @Override
        public void doAction() {
            int option = this.getChooser().showOpenDialog(JImageUrlFrame.this);
            if (option == 0) {
                this.action.setSaveLocation(this.getChooser().getSelectedFile());
                URL[] urls = new URL[]{JImageUrlFrame.this.imageUrl};
                this.action.setUrls(urls);
                this.action.setProgressMonitor(new ProgressMonitor(JImageUrlFrame.this, "Downloading images", "", 0, urls.length));
                ActionRunnable ar = new ActionRunnable(this.action);
                ar.start();
            }
        }

        private JFileChooser getChooser() {
            if (this.chooser == null) {
                this.chooser = new JFileChooser();
                this.chooser.setFileSelectionMode(1);
            }
            return this.chooser;
        }
    }

    private class ImageLoader
    extends SwingWorker<BufferedImage, Object> {
        final URL url;

        public ImageLoader(URL url) {
            this.url = url;
        }

        @Override
        protected BufferedImage doInBackground() throws Exception {
            JImageUrlFrame.this.log.debug("Reading image from " + this.url);
            return ImageIO.read(this.url);
        }

        @Override
        protected void done() {
            try {
                Image newImage = (Image)this.get();
                JImageUrlFrame.this.log.debug("Image " + this.url + " [" + newImage.getWidth(JImageUrlFrame.this) + " x " + newImage.getHeight(JImageUrlFrame.this) + " pixels] has been loaded");
                JImageUrlFrame.this.imageUrl = this.url;
                JImageUrlFrame.this.setImage(newImage);
            }
            catch (Exception e) {
                BufferedImage image = new BufferedImage(800, 200, 1);
                Graphics2D g = (Graphics2D)image.getGraphics();
                g.setPaint(JImageUrlFrame.this.getBackground());
                g.fillRect(0, 0, image.getWidth(), image.getHeight());
                g.setPaint(JImageUrlFrame.this.getForeground());
                g.drawString("Failed to read: " + this.url, 1, 100);
                g.dispose();
                JImageUrlFrame.this.setImage(image);
                JImageUrlFrame.this.log.debug("Failed to read image", (Throwable)e);
            }
        }
    }
}

