/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;

public class JImageCanvas
extends JComponent {
    public static final String PROP_IMAGE = "image";
    private static final long serialVersionUID = -6750506357985486937L;
    private Image image;

    public JImageCanvas() {
        this(null);
    }

    public JImageCanvas(Image image) {
        this.setBackground(Color.BLACK);
        this.setImage(image);
    }

    public Point2D convertToComponent(Point2D imagePoint) {
        Point2D.Double point = null;
        if (this.image != null) {
            int imageWidth = this.image.getWidth(this);
            int imageHeight = this.image.getHeight(this);
            if (imagePoint.getX() >= 0.0 && imagePoint.getX() <= (double)imageWidth && imagePoint.getY() >= 0.0 && imagePoint.getY() <= (double)imageHeight) {
                Rectangle2D r = this.getImageRectangle();
                double scale = (double)this.image.getWidth(this) / r.getWidth();
                double sx = imagePoint.getX() / scale;
                double sy = imagePoint.getY() / scale;
                double x = r.getX() + sx;
                double y = r.getY() + sy;
                point = new Point2D.Double(x, y);
            }
        }
        return point;
    }

    public Point2D convertToImage(Point2D componentPoint) {
        Point2D.Double point = null;
        if (this.image != null && this.getBounds().contains(componentPoint)) {
            Rectangle2D r = this.getImageRectangle();
            double scale = r.getWidth() / (double)this.image.getWidth(this);
            double x = componentPoint.getX() - r.getX();
            double y = componentPoint.getY() - r.getY();
            double sx = x / scale;
            double sy = y / scale;
            point = new Point2D.Double(sx, sy);
        }
        return point;
    }

    public double getImageScale() {
        return this.image == null ? 1.0 : this.getImageRectangle().getWidth() / (double)this.image.getWidth(this);
    }

    public Image getImage() {
        return this.image;
    }

    public int getImageHeight() {
        return this.image == null ? 0 : this.image.getHeight(this);
    }

    public Rectangle2D getImageRectangle() {
        if (this.image == null) {
            return null;
        }
        double componentWidth = this.getWidth();
        double componentHeight = this.getHeight();
        double imageWidth = this.image.getWidth(this);
        double imageHeight = this.image.getHeight(this);
        double wImageWidth = imageWidth;
        double wImageHeight = imageHeight;
        double hImageWidth = 0.0;
        double hImageHeight = 0.0;
        double newImageWidth = 0.0;
        double newImageHeight = 0.0;
        if (imageWidth > 0.0 && imageHeight > 0.0) {
            if (imageWidth == componentWidth && imageHeight == componentHeight) {
                wImageWidth = imageWidth;
                wImageHeight = imageHeight;
            }
            if (imageWidth != componentWidth) {
                wImageWidth = componentWidth;
                wImageHeight = imageHeight * componentWidth / imageWidth;
            }
            if (imageHeight != componentHeight) {
                hImageHeight = componentHeight;
                hImageWidth = imageWidth * componentHeight / imageHeight;
            }
            if (wImageHeight > componentHeight) {
                newImageHeight = hImageHeight;
                newImageWidth = hImageWidth;
            } else {
                newImageHeight = wImageHeight;
                newImageWidth = wImageWidth;
            }
        }
        double x = (componentWidth - newImageWidth) / 2.0;
        double y = (componentHeight - newImageHeight) / 2.0;
        return new Rectangle2D.Double(x, y, newImageWidth, newImageHeight);
    }

    public int getImageWidth() {
        return this.image == null ? 0 : this.image.getWidth(this);
    }

    public boolean isAborted() {
        int infoFlags = this.checkImage(this.image, this);
        return (infoFlags & 0x80) != 0;
    }

    @Override
    protected void paintComponent(Graphics g) {
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.image != null) {
            Rectangle r = this.getImageRectangle().getBounds();
            g.drawImage(this.image, r.x, r.y, r.width, r.height, this);
        }
        super.paintComponent(g);
    }

    public void setImage(Image image) {
        Image oldImage = this.image;
        this.image = image;
        if (image != null) {
            this.setPreferredSize(new Dimension(image.getWidth(this), image.getHeight(this)));
        }
        this.firePropertyChange(PROP_IMAGE, oldImage, image);
        this.repaint();
    }
}

