/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.swing;

import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Comparator;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.InputMap;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import org.mbari.swing.SortedComboBoxModel;
import org.mbari.text.IgnoreCaseToStringComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FancyComboBox
extends JComboBox {
    private static final long serialVersionUID = -7372167388980529692L;
    private static final Logger log = LoggerFactory.getLogger(FancyComboBox.class);
    private static final String downKey = "selectNextRow";
    private static final String upKey = "selectPreviousRow";
    private static KeyStroke up = KeyStroke.getKeyStroke(38, 0);
    private static KeyStroke cmdUp = KeyStroke.getKeyStroke(38, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
    private static KeyStroke kpUp = KeyStroke.getKeyStroke(224, 0);
    private static KeyStroke kpDown = KeyStroke.getKeyStroke(225, 0);
    private static KeyStroke down = KeyStroke.getKeyStroke(40, 0);
    private static KeyStroke cmdDown = KeyStroke.getKeyStroke(40, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
    private static KeyStroke cmdW = KeyStroke.getKeyStroke(87, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());

    public FancyComboBox() {
        this.setEditable(true);
        this.setModel((ComboBoxModel)new SortedComboBoxModel(null));
        this.setEditor(new SearchAheadEditor());
    }

    public FancyComboBox(Comparator comparator) {
        this();
        this.setComparator(comparator);
    }

    public void addEditorActionListener(ActionListener listener) {
        this.editor.addActionListener(listener);
    }

    public void addEditorFocusListener(FocusListener listener) {
        this.editor.getEditorComponent().addFocusListener(listener);
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("FancyComoBox Demo");
        frame.setDefaultCloseOperation(3);
        FancyComboBox cb = new FancyComboBox(new IgnoreCaseToStringComparator());
        SortedComboBoxModel model = (SortedComboBoxModel)cb.getModel();
        ArrayList<String> data = new ArrayList<String>();
        data.add("auto");
        data.add("autocrat");
        data.add("automobile");
        data.add("graduation");
        model.addAll(data);
        BoxLayout layout = new BoxLayout(frame.getContentPane(), 0);
        frame.getContentPane().setLayout(layout);
        frame.getContentPane().add(new JLabel("Text Field: "));
        frame.getContentPane().add(cb);
        frame.pack();
        frame.setVisible(true);
    }

    public void setComparator(Comparator comparator) {
        ((SortedComboBoxModel)this.getModel()).setComparator(comparator);
    }

    @Override
    public void setEditor(ComboBoxEditor editor) {
        if (!(editor instanceof SearchAheadEditor)) {
            log.debug("The ComboBoxEditor must be an instance of SearchAheadEditor");
        }
        super.setEditor(editor);
    }

    public void setModel(ComboBoxModel model) {
        if (!(model instanceof SortedComboBoxModel)) {
            log.debug("The model is now a " + model.getClass().getName() + ". It should be a SortedComboBoxModel");
        }
        super.setModel(model);
    }

    private class SearchAheadTextField
    extends JTextField {
        private static final long serialVersionUID = -8851277261871110367L;

        SearchAheadTextField() {
            this.setOpaque(true);
            InputMap inputMap = this.getInputMap();
            inputMap.put(KeyStroke.getKeyStroke(8, 0), inputMap.get(KeyStroke.getKeyStroke(37, 0)));
            inputMap.put(KeyStroke.getKeyStroke(32, 0), inputMap.get(KeyStroke.getKeyStroke(39, 0)));
            inputMap.put(KeyStroke.getKeyStroke(127, 0), "none");
            inputMap.put(cmdUp, "none");
            inputMap.put(cmdDown, "none");
            ActionMap actionMap = this.getActionMap();
            AbstractAction upAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FancyComboBox fc = FancyComboBox.this;
                    fc.setPopupVisible(true);
                    int idx = fc.getSelectedIndex();
                    if (idx >= 0) {
                        idx = idx == 0 && fc.getModel().getSize() > 0 ? fc.getModel().getSize() - 1 : --idx;
                        fc.setSelectedIndex(idx);
                        fc.repaint();
                    }
                }
            };
            AbstractAction downAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FancyComboBox fc = FancyComboBox.this;
                    fc.setPopupVisible(true);
                    int idx = fc.getSelectedIndex();
                    if (idx >= 0) {
                        idx = idx < fc.getModel().getSize() - 1 ? ++idx : 0;
                        fc.setSelectedIndex(idx);
                        fc.repaint();
                    }
                }
            };
            inputMap.put(up, FancyComboBox.upKey);
            inputMap.put(kpUp, FancyComboBox.upKey);
            inputMap.put(down, FancyComboBox.downKey);
            inputMap.put(kpDown, FancyComboBox.downKey);
            actionMap.put(FancyComboBox.downKey, downAction);
            actionMap.put(FancyComboBox.upKey, upAction);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent event) {
                    if (SearchAheadTextField.this.getSelectionEnd() != SearchAheadTextField.this.getText().length()) {
                        SearchAheadTextField.this.highlightText();
                    }
                }
            });
            this.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent event) {
                    if (SearchAheadTextField.this.getCaretPosition() < SearchAheadTextField.this.getText().length()) {
                        SearchAheadTextField.this.highlightText();
                    }
                }
            });
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    SearchAheadTextField.this.setCaretPosition(SearchAheadTextField.this.getText().length());
                }
            });
        }

        private void highlightText() {
            int holdPosition = this.getCaretPosition();
            this.setCaretPosition(this.getText().length());
            this.moveCaretPosition(holdPosition);
        }

        @Override
        public void replaceSelection(String content) {
            SortedComboBoxModel model = (SortedComboBoxModel)FancyComboBox.this.getModel();
            Comparator<String> comparator = model.getComparator();
            StringBuffer buf = new StringBuffer(this.getText().substring(0, this.getSelectionStart()));
            buf.append(content);
            buf.append(this.getText().substring(this.getSelectionEnd()));
            String lookFor = buf.toString();
            int itemIndex = model.getItemIndex(lookFor);
            if (itemIndex < 0) {
                itemIndex = -1 * itemIndex - 1;
            }
            if (itemIndex < model.getSize()) {
                String selection = model.getElementAt(itemIndex).toString();
                boolean match = false;
                if (comparator != null) {
                    int endIdx = selection.length() > lookFor.length() ? lookFor.length() : selection.length();
                    String select = selection.substring(0, endIdx);
                    match = comparator.compare(select, lookFor) == 0;
                } else {
                    match = selection.startsWith(lookFor);
                }
                if (match) {
                    model.setSelectedItem(selection);
                    this.setCaretPosition(selection.length());
                    this.moveCaretPosition(lookFor.length());
                }
            }
        }
    }

    private class SearchAheadEditor
    implements ComboBoxEditor {
        private final JTextField editor;

        private SearchAheadEditor() {
            this.editor = new SearchAheadTextField();
        }

        @Override
        public void addActionListener(ActionListener l) {
            this.editor.addActionListener(l);
        }

        @Override
        public Component getEditorComponent() {
            return this.editor;
        }

        @Override
        public Object getItem() {
            return this.editor.getText();
        }

        @Override
        public void removeActionListener(ActionListener l) {
            this.editor.removeActionListener(l);
        }

        @Override
        public void selectAll() {
            this.editor.selectAll();
        }

        @Override
        public void setItem(Object obj) {
            if (obj != null) {
                this.editor.setText(obj.toString());
            }
        }
    }
}

