/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.sql;

import java.io.IOException;
import java.io.Writer;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class QueryResults {
    private static final Object NO_VALUE = "!_!!_!!!___NO_VALUE___!!!_!!_!";
    private Map<String, List<Object>> resultsMap = new TreeMap<String, List<Object>>();
    private Map<String, Map<Integer, Set<Object>>> duplicateMap;

    public QueryResults(Map<String, List<Object>> data) {
        this.resultsMap.putAll(data);
    }

    /*
     * WARNING - void declaration
     */
    public QueryResults(ResultSet resultSet) throws SQLException {
        ArrayList<String> columnNames = new ArrayList<String>();
        ResultSetMetaData metaData = resultSet.getMetaData();
        int colCount = metaData.getColumnCount();
        String[] returnTypes = new String[colCount];
        for (int i = 1; i <= colCount; ++i) {
            columnNames.add(metaData.getColumnLabel(i));
            returnTypes[i - 1] = metaData.getColumnClassName(i).toLowerCase();
        }
        for (String string : columnNames) {
            this.resultsMap.put(string, new ArrayList());
        }
        ArrayList<List> dataStores = new ArrayList<List>();
        for (String colName : columnNames) {
            dataStores.add(this.getResults(colName));
        }
        while (resultSet.next()) {
            void var7_11;
            boolean bl = false;
            while (var7_11 < colCount) {
                List data = (List)dataStores.get((int)var7_11);
                if (returnTypes[var7_11].equals("oracle.sql.timestamp")) {
                    data.add(resultSet.getTimestamp((int)(var7_11 + true)));
                } else {
                    data.add(resultSet.getObject((int)(var7_11 + true)));
                }
                ++var7_11;
            }
        }
    }

    public void coalesce(String key) {
        this.duplicateMap = new HashMap<String, Map<Integer, Set<Object>>>();
        List keyColumn = this.getResults(key);
        Object[] objects = keyColumn.toArray(new Object[keyColumn.size()]);
        for (int row0 = 0; row0 < objects.length; ++row0) {
            int row1;
            Object object = objects[row0];
            if (NO_VALUE.equals(object)) continue;
            while ((row1 = keyColumn.lastIndexOf(object)) > row0) {
                this.storeCoalescedValues(row0, row1);
                objects[row1] = NO_VALUE;
            }
        }
        this.combineCoalescedValues();
        this.removeDuplicates();
    }

    public int columnCount() {
        return this.resultsMap.keySet().size();
    }

    private void combineCoalescedValues() {
        Set<String> columnNames = this.duplicateMap.keySet();
        for (String columnName : columnNames) {
            Map<Integer, Set<Object>> map = this.duplicateMap.get(columnName);
            Set<Integer> rows = map.keySet();
            for (Object e : rows) {
                Integer row = (Integer)e;
                TreeSet rowValues = new TreeSet(map.get(row));
                Iterator k = rowValues.iterator();
                String value = k.next().toString();
                while (k.hasNext()) {
                    value = value + ", " + k.next();
                }
                this.resultsMap.get(columnName).set(row, value);
            }
        }
    }

    public boolean containsColumnName(Object columnName) {
        return this.resultsMap.containsKey(columnName);
    }

    public Set getColumnNames() {
        return this.resultsMap.keySet();
    }

    public Object[][] getDataArray() {
        Set<String> keySet = this.resultsMap.keySet();
        int cols = keySet.size();
        String key0 = keySet.iterator().next();
        List<Object> item = this.resultsMap.get(key0);
        int rows = item.size();
        Object[][] data = new Object[rows][cols];
        int col = 0;
        for (String key : keySet) {
            List<Object> dataInColumn = this.resultsMap.get(key);
            for (int row = 0; row < dataInColumn.size(); ++row) {
                data[row][col] = dataInColumn.get(row);
            }
            ++col;
        }
        return data;
    }

    public List getResults(String columnName) {
        Set<String> columnNames = this.resultsMap.keySet();
        List<Object> list = null;
        for (String column : columnNames) {
            if (!columnName.equalsIgnoreCase(column)) continue;
            list = this.resultsMap.get(column);
            break;
        }
        return list;
    }

    public Map<String, List<Object>> getResultsMap() {
        return this.resultsMap;
    }

    private void removeDuplicates() {
        ArrayList<Object> noValueList = new ArrayList<Object>();
        noValueList.add(NO_VALUE);
        Collection<List<Object>> dataLists = this.resultsMap.values();
        for (List<Object> data : dataLists) {
            data.removeAll(noValueList);
        }
    }

    public int rowCount() {
        int rows = 0;
        Iterator<List<Object>> i = this.resultsMap.values().iterator();
        if (i.hasNext()) {
            rows = i.next().size();
        }
        return rows;
    }

    private void storeCoalescedValues(int row0, int row1) {
        Set<String> keys = this.resultsMap.keySet();
        for (String columnName : keys) {
            List<Object> data = this.resultsMap.get(columnName);
            Object obj0 = data.get(row0);
            Object obj1 = data.get(row1);
            if (obj0 != null && obj1 != null && !obj0.equals(obj1)) {
                Integer rowKey;
                Set<Object> set;
                Map<Integer, Set<Object>> map = this.duplicateMap.get(columnName);
                if (map == null) {
                    map = new HashMap<Integer, Set<Object>>();
                    this.duplicateMap.put(columnName, map);
                }
                if ((set = map.get(rowKey = Integer.valueOf(row0))) == null) {
                    set = new HashSet<Object>();
                    map.put(rowKey, set);
                }
                set.add(obj0);
                set.add(obj1);
            }
            data.set(row1, NO_VALUE);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        Set<String> keySet = this.resultsMap.keySet();
        for (String key : keySet) {
            sb.append(key).append("\t");
        }
        if (sb.length() > 0) {
            sb.delete(sb.length() - 1, sb.length());
        }
        sb.append("\n");
        Object[][] data = this.getDataArray();
        int rows = data.length;
        if (rows > 0) {
            int cols = data[0].length;
            for (int row = 0; row < rows; ++row) {
                for (int col = 0; col < cols; ++col) {
                    Object value = data[row][col];
                    if (value == null) {
                        value = " ";
                    }
                    sb.append(value);
                    if (col < cols - 1) {
                        sb.append("\t");
                        continue;
                    }
                    sb.append("\n");
                }
            }
        }
        return sb.toString();
    }

    public void writeFormattedResults(Writer writer) throws IOException {
        Set<String> keySet = this.resultsMap.keySet();
        Iterator<String> i = keySet.iterator();
        while (i.hasNext()) {
            String key = i.next();
            writer.write(key);
            if (!i.hasNext()) continue;
            writer.write("\t");
        }
        writer.write("\n");
        Object[][] data = this.getDataArray();
        int rows = data.length;
        if (rows > 0) {
            int cols = data[0].length;
            for (int row = 0; row < rows; ++row) {
                for (int col = 0; col < cols; ++col) {
                    Object value = data[row][col];
                    if (value == null) {
                        value = " ";
                    }
                    writer.write(value.toString());
                    if (col < cols - 1) {
                        writer.write("\t");
                        continue;
                    }
                    writer.write("\n");
                }
            }
        }
    }
}

