/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.model.tidal;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TidePredictor {
    private String tideLocation = null;
    private String tideLocationUrlFragment = null;
    private Date startDateTime = null;
    private Date endDateTime = null;
    private TimeZone timezone = TimeZone.getDefault();
    private int numberOfMinutesBetweenDataPoints = 30;
    private String tideLocationListUrlString = null;
    private String baseUrlTidePredictorString = null;
    private TreeMap<Date, Double> tideData = new TreeMap();
    private Double maxTide = Double.MIN_VALUE;
    private Double minTide = Double.MAX_VALUE;
    private TreeMap<Date, String> tideEvents = new TreeMap();
    private TreeMap<Date, String> coverageMap = new TreeMap();
    private boolean busyRetrievingData = false;
    private static final Logger logger = LoggerFactory.getLogger(TidePredictor.class);

    public TidePredictor() {
        logger.debug("Base TidePredictor constructor called");
        Calendar aBriefMomentInTime = Calendar.getInstance();
        this.startDateTime = aBriefMomentInTime.getTime();
        logger.debug("Default start time is " + this.startDateTime);
        aBriefMomentInTime.add(10, 24);
        this.endDateTime = aBriefMomentInTime.getTime();
        logger.debug("Default end time is " + this.endDateTime);
        InputStream propStream = this.getClass().getResourceAsStream("/org/mbari/model/tidal/tidal-predictor.properties");
        logger.debug("Tried to get input stream from props file, how did I do? propStream=" + propStream);
        Properties tidePredictorProps = new Properties();
        try {
            tidePredictorProps.load(propStream);
        }
        catch (Throwable t) {
            logger.error("Throwable caught trying to read properties: " + t.getMessage(), (Object)false);
        }
        logger.debug("Done trying to load properties");
        this.tideLocationListUrlString = tidePredictorProps.getProperty("tideLocationUrlString");
        logger.debug("Tide location URL string read from properties is " + this.tideLocationListUrlString);
        this.baseUrlTidePredictorString = tidePredictorProps.getProperty("baseUrlTidePredictorString");
        logger.debug("Base Url = " + this.baseUrlTidePredictorString);
    }

    public TidePredictor(int numberOfMinutesBetweenTideDataPoints) {
        this();
        this.numberOfMinutesBetweenDataPoints = numberOfMinutesBetweenTideDataPoints;
    }

    public TidePredictor(String locationName, Date startDateTime, Date endDateTime) throws IllegalArgumentException, IOException {
        this();
        this.setTideLocation(locationName);
        if (startDateTime != null && endDateTime != null) {
            this.setStartAndEndDateTimes(startDateTime, endDateTime);
        }
    }

    public TidePredictor(String locationName, Date startDateTime, Date endDateTime, int numberOfMinutesBetweenDataPoints) throws IllegalArgumentException, IOException {
        this();
        this.setTideLocation(locationName);
        this.numberOfMinutesBetweenDataPoints = numberOfMinutesBetweenDataPoints;
        if (startDateTime != null && endDateTime != null) {
            this.setStartAndEndDateTimes(startDateTime, endDateTime);
        }
    }

    public Date getEndDateTime() {
        return this.endDateTime;
    }

    public Date getStartDateTime() {
        return this.startDateTime;
    }

    public void setStartAndEndDateTimes(Date startDateTime, Date endDateTime) throws IllegalArgumentException {
        if (startDateTime == null || endDateTime == null) {
            throw new IllegalArgumentException("Start and end dates must be specified");
        }
        if (startDateTime.after(endDateTime)) {
            throw new IllegalArgumentException("The specified start date must be before the specified end date");
        }
        this.startDateTime = startDateTime;
        this.endDateTime = endDateTime;
        this.populateTideData();
    }

    public TimeZone getTimezone() {
        return this.timezone;
    }

    public void setTimezone(TimeZone timezone) {
        this.timezone = timezone;
    }

    public String getTideLocation() {
        return this.tideLocation;
    }

    public void setTideLocation(String tideLocation) throws IllegalArgumentException, IOException {
        if (this.tideLocation == null || !this.tideLocation.equals(tideLocation)) {
            this.resetTidePredictor();
            if (tideLocation != null && !tideLocation.equals("")) {
                HashMap<String, String> locations = this.getLikeTideLocationsFromService(tideLocation);
                if (locations == null || locations.size() == 0) {
                    throw new IllegalArgumentException("No matching location was found for '" + tideLocation + "'");
                }
                if (locations.size() > 1) {
                    throw new IllegalArgumentException("More than one location was found with that name, please be more specific");
                }
                this.tideLocation = locations.keySet().iterator().next();
                this.tideLocationUrlFragment = locations.get(this.tideLocation);
            } else {
                throw new IllegalArgumentException("Incoming tideLocation cannot be null");
            }
        }
    }

    public String getTideLocationUrlFragment() {
        return this.tideLocationUrlFragment;
    }

    public int getNumberOfMinutesBetweenDataPoints() {
        return this.numberOfMinutesBetweenDataPoints;
    }

    public boolean isBusyRetrievingData() {
        return this.busyRetrievingData;
    }

    public Double getMaxTide() {
        if (this.maxTide.equals(Double.MIN_VALUE)) {
            return null;
        }
        return this.maxTide;
    }

    public Double getMinTide() {
        if (this.minTide.equals(Double.MAX_VALUE)) {
            return null;
        }
        return this.minTide;
    }

    public TreeMap<Date, Double> getTideData() {
        return this.tideData;
    }

    public SortedMap<Date, Double> getTideDataPointsOverDateRange(Date startDate, Date endDate) throws IllegalArgumentException {
        if (this.startDateTime.after(startDate) || endDate.before(endDate)) {
            throw new IllegalArgumentException("The sub range you specified is outside of the range set on the TidePredictor.");
        }
        return this.tideData.subMap(startDate, endDate);
    }

    public TreeMap<Date, String> getTideEvents() {
        return this.tideEvents;
    }

    public SortedMap<Date, String> getTideEventsOverDateRange(Date startDate, Date endDate) throws IllegalArgumentException {
        if (this.startDateTime.after(startDate) || endDate.before(endDate)) {
            throw new IllegalArgumentException("The sub range you specified is outside of the range set on the TidePredictor.");
        }
        return this.tideEvents.subMap(startDate, endDate);
    }

    public HashMap<String, String> getLikeTideLocationsFromService(String likeString) {
        logger.debug("Will look for similar locations at: " + this.tideLocationListUrlString);
        HashMap<String, String> tideLocationsAndUrlFragements = new HashMap<String, String>();
        URL tideLocationListUrl = null;
        try {
            logger.debug("Going to try and find the similar locations from the URL " + this.tideLocationListUrlString);
            tideLocationListUrl = new URL(this.tideLocationListUrlString);
        }
        catch (MalformedURLException ex) {
            logger.error("MalformedURLException " + ex.getMessage());
        }
        BufferedReader in = null;
        try {
            in = new BufferedReader(new InputStreamReader(tideLocationListUrl.openStream()));
        }
        catch (IOException e) {
            logger.error("IOException trying to read location list from URL: " + e.getMessage());
        }
        Pattern pattern = Pattern.compile(".*<a href=\"tideshow.cgi\\?site=(\\S+)\\&units=f\">(.*" + likeString + ".*)</a>.*");
        String inputLine = null;
        try {
            while ((inputLine = in.readLine()) != null) {
                Matcher m = pattern.matcher(inputLine);
                if (!m.matches()) continue;
                tideLocationsAndUrlFragements.put(m.group(2), m.group(1));
            }
        }
        catch (IOException e) {
            logger.error("IOException caught reading from the location list URL: " + e.getMessage());
        }
        return tideLocationsAndUrlFragements;
    }

    private void resetTidePredictor() {
        this.tideLocation = null;
        this.tideLocationUrlFragment = null;
        this.busyRetrievingData = false;
        this.maxTide = Double.MIN_VALUE;
        this.minTide = Double.MAX_VALUE;
        this.tideData = new TreeMap();
        this.tideEvents = new TreeMap();
        this.coverageMap = new TreeMap();
    }

    private void populateTideData() {
        if (this.tideLocation == null || this.tideLocation.equals("") || this.startDateTime == null || this.endDateTime == null || this.tideLocationUrlFragment == null || this.tideLocationUrlFragment.equals("")) {
            throw new IllegalArgumentException("Not all the parameters were set so tide data could not be retrieved.");
        }
        if (!this.isDateRangeCovered(this.startDateTime, this.endDateTime)) {
            this.busyRetrievingData = true;
            try {
                HashMap<Date, Double> moreTideData = this.readTideDataFromService();
                this.addTideDataAndUpdateCoverage(moreTideData);
                HashMap<Date, String> moreTideEvents = this.readTideEventsFromService();
                this.addTideEvents(moreTideEvents);
            }
            catch (Throwable t) {
                logger.error("Throwable caught trying to read tide data and events from URL: " + t.getMessage());
            }
            this.busyRetrievingData = false;
        }
    }

    public boolean isDateRangeCovered(Date startDate, Date endDate) {
        boolean dateRangeCovered = false;
        if (this.coverageMap != null && this.coverageMap.size() > 0) {
            LinkedList<Date> coverageDates = new LinkedList<Date>(this.coverageMap.keySet());
            Collections.sort(coverageDates);
            int startInsertion = Collections.binarySearch(coverageDates, startDate);
            boolean startIsExactMatch = false;
            if (startInsertion >= 0) {
                startIsExactMatch = true;
            }
            int endInsertion = Collections.binarySearch(coverageDates, endDate);
            boolean endIsExactMatch = false;
            if (endInsertion >= 0) {
                endIsExactMatch = true;
            }
            if (startIsExactMatch && startInsertion % 2 == 1) {
                return false;
            }
            if (!startIsExactMatch && (startInsertion + 1) * -1 % 2 == 0) {
                return false;
            }
            if (endIsExactMatch && endInsertion % 2 == 0) {
                return false;
            }
            if (!endIsExactMatch && (endInsertion + 1) * -1 % 2 == 0) {
                return false;
            }
            if (startIsExactMatch && startInsertion % 2 == 0) {
                int indexDifference = 0;
                indexDifference = endIsExactMatch ? endInsertion - startInsertion : (endInsertion + 1) * -1 - startInsertion;
                return indexDifference <= 1;
            }
            if (!startIsExactMatch && (startInsertion + 1) * -1 % 2 == 1) {
                int indexDifference = 0;
                indexDifference = endIsExactMatch ? endInsertion - (startInsertion + 1) * -1 : (endInsertion + 1) * -1 - (startInsertion + 1) * -1;
                return indexDifference == 0;
            }
        } else {
            return false;
        }
        return dateRangeCovered;
    }

    private HashMap<Date, Double> readTideDataFromService() {
        logger.debug("readTideDataFromService called and params are currently :");
        logger.debug("-> Location = " + this.tideLocation);
        logger.debug("-> Location URL Fragment = " + this.tideLocationUrlFragment);
        logger.debug("-> Start Date = " + this.startDateTime);
        logger.debug("-> End Date = " + this.endDateTime);
        logger.debug("-> Number of minutes between points = " + this.numberOfMinutesBetweenDataPoints);
        HashMap<Date, Double> dataFromServices = new HashMap<Date, Double>();
        Calendar dateRangeStartCal = Calendar.getInstance();
        dateRangeStartCal.setTime(this.startDateTime);
        Calendar dateRangeEndCal = Calendar.getInstance();
        dateRangeEndCal.setTime(this.endDateTime);
        dateRangeStartCal.add(12, -2 * this.numberOfMinutesBetweenDataPoints);
        dateRangeEndCal.add(12, 2 * this.numberOfMinutesBetweenDataPoints);
        logger.debug("Opened the query window up to search between " + dateRangeStartCal.getTime() + " to " + dateRangeEndCal.getTime());
        String startYear = dateRangeStartCal.get(1) + "";
        String startMonth = dateRangeStartCal.get(2) + 1 + "";
        String startDay = dateRangeStartCal.get(5) + "";
        String startHour = dateRangeStartCal.get(11) + "";
        String startMin = dateRangeStartCal.get(12) + "";
        int numberOfDays = (dateRangeEndCal.get(1) - dateRangeStartCal.get(1)) * 365 + (dateRangeEndCal.get(6) - dateRangeStartCal.get(6));
        String glen = numberOfDays + "";
        URL tideDataUrl = null;
        try {
            tideDataUrl = new URL("http://tbone.biol.sc.edu/tide/tideshow.cgi?tplotdir=horiz;gx=640;gy=240;caltype=ndp;type=mrare;interval=00%3A30;glen=" + glen + ";" + "fontsize=%2B0;" + "units=feet;" + "cleanout=1;" + "year=" + startYear + ";" + "month=" + startMonth + ";" + "day=" + startDay + ";" + "hour=" + startHour + ";" + "min=" + startMin + ";" + "tzone=utc;" + "ampm24=24;" + "colortext=black;" + "colordatum=white;" + "colormsl=yellow;" + "colortics=red;" + "colorday=skyblue;" + "colornight=deep-%3Cbr%20%2F%3Eskyblue;" + "colorebb=seagreen;" + "colorflood=blue;" + "site=" + this.tideLocationUrlFragment);
            logger.debug("readTideDataFromService: URL to use: " + tideDataUrl);
        }
        catch (MalformedURLException ex) {
            logger.error("MalforedURLException creating the URL to read tide data: " + ex.getMessage());
        }
        BufferedReader in = null;
        try {
            in = new BufferedReader(new InputStreamReader(tideDataUrl.openStream()));
        }
        catch (IOException e) {
            logger.error("IOException caught trying to open buffered reader to URL for tide data: " + e.getMessage());
        }
        Pattern pattern = Pattern.compile("^(\\d{4})-(\\d{2})-(\\d{2})\\s+(\\d{2}):(\\d{2})\\s+(\\S+)\\s+(-*\\d+\\.\\d+)$");
        try {
            String inputLine = null;
            String year = null;
            String month = null;
            String day = null;
            String hour = null;
            String minute = null;
            String zone = null;
            String dataString = null;
            while ((inputLine = in.readLine()) != null) {
                Matcher m = pattern.matcher(inputLine);
                if (!m.matches()) continue;
                year = m.group(1);
                month = m.group(2);
                day = m.group(3);
                hour = m.group(4);
                minute = m.group(5);
                zone = m.group(6);
                dataString = m.group(7);
                Calendar dataPointCalendar = Calendar.getInstance();
                String timeZoneID = dataPointCalendar.getTimeZone().getID();
                dataPointCalendar.setTimeZone(TimeZone.getTimeZone("UTC"));
                dataPointCalendar.set(1, Integer.parseInt(year));
                dataPointCalendar.set(2, Integer.parseInt(month) - 1);
                dataPointCalendar.set(5, Integer.parseInt(day));
                dataPointCalendar.set(11, Integer.parseInt(hour));
                dataPointCalendar.set(12, Integer.parseInt(minute));
                dataPointCalendar.set(13, 0);
                dataPointCalendar.getTime();
                Double tideDataPoint = null;
                try {
                    tideDataPoint = new Double(dataString);
                }
                catch (NumberFormatException e) {
                    logger.error("Read tide data point " + dataString + " but could not convert that to a Double: " + e.getMessage());
                }
                if (tideDataPoint == null) continue;
                dataFromServices.put(dataPointCalendar.getTime(), tideDataPoint);
                if (tideDataPoint > this.maxTide) {
                    this.maxTide = tideDataPoint;
                }
                if (!(tideDataPoint < this.minTide)) continue;
                this.minTide = tideDataPoint;
            }
        }
        catch (IOException e) {
            logger.error("IOException caught trying to read line from URL " + e.getMessage());
        }
        logger.debug("Done with query and found " + dataFromServices.size() + " data points in the query results.");
        logger.debug("After query:");
        logger.debug("-> Minimum Tide = " + this.minTide);
        logger.debug("-> Maximum Tide = " + this.maxTide);
        return dataFromServices;
    }

    private void addTideDataAndUpdateCoverage(HashMap<Date, Double> moreTideData) {
        if (moreTideData != null && moreTideData.size() > 0) {
            if (this.tideData == null || this.tideData.size() <= 0) {
                this.tideData = new TreeMap();
                this.tideData.putAll(moreTideData);
                this.coverageMap = new TreeMap();
                this.coverageMap.put(this.startDateTime, "START");
                this.coverageMap.put(this.endDateTime, "END");
            } else {
                LinkedList<Date> coverageDates = new LinkedList<Date>(this.coverageMap.keySet());
                Collections.sort(coverageDates);
                for (Date dataDate : moreTideData.keySet()) {
                    if (Collections.binarySearch(coverageDates, dataDate) >= 0 || (Collections.binarySearch(coverageDates, dataDate) + 1) * -1 % 2 != 0) continue;
                    this.tideData.put(dataDate, moreTideData.get(dataDate));
                }
                this.updateCoverageMap(this.startDateTime, this.endDateTime);
            }
        }
    }

    private void updateCoverageMap(Date startDate, Date endDate) {
        LinkedList<Date> coverageDates = new LinkedList<Date>(this.coverageMap.keySet());
        Collections.sort(coverageDates);
        if (Collections.binarySearch(coverageDates, startDate) > 0) {
            this.coverageMap.remove(startDate);
        }
        this.coverageMap.put(startDate, "START");
        if (Collections.binarySearch(coverageDates, endDate) > 0) {
            this.coverageMap.remove(endDate);
        }
        this.coverageMap.put(endDate, "END");
        coverageDates = new LinkedList<Date>(this.coverageMap.keySet());
        Collections.sort(coverageDates);
        List datesBetween = coverageDates.subList(Collections.binarySearch(coverageDates, startDate), Collections.binarySearch(coverageDates, endDate));
        for (Date date : datesBetween) {
            if (date.equals(startDate) || date.equals(endDate)) continue;
            this.coverageMap.remove(date);
        }
        boolean coverageAligned = false;
        while (!coverageAligned) {
            LinkedList<Date> tempCoverageDates = new LinkedList<Date>(this.coverageMap.keySet());
            Collections.sort(coverageDates);
            int index = 0;
            int coverageMapSize = tempCoverageDates.size();
            for (Date tempDate : tempCoverageDates) {
                String startOrEnd = this.coverageMap.get(tempDate);
                if (index % 2 == 0) {
                    if (startOrEnd.equals("END")) {
                        this.coverageMap.remove(tempCoverageDates.get(index - 1));
                        break;
                    }
                } else if (startOrEnd.equals("START")) {
                    this.coverageMap.remove(tempDate);
                    break;
                }
                ++index;
            }
            if (index != coverageMapSize) continue;
            coverageAligned = true;
        }
    }

    private HashMap<Date, String> readTideEventsFromService() {
        logger.debug("readTideEventsFromService called and params are currently :");
        logger.debug("-> Location = " + this.tideLocation);
        logger.debug("-> Location URL Fragment = " + this.tideLocationUrlFragment);
        logger.debug("-> Start Date = " + this.startDateTime);
        logger.debug("-> End Date = " + this.endDateTime);
        logger.debug("-> Number of minutes between points = " + this.numberOfMinutesBetweenDataPoints);
        HashMap<Date, String> eventsReadFromService = new HashMap<Date, String>();
        Calendar dateRangeStartCal = Calendar.getInstance();
        dateRangeStartCal.setTime(this.startDateTime);
        Calendar dateRangeEndCal = Calendar.getInstance();
        dateRangeEndCal.setTime(this.endDateTime);
        dateRangeStartCal.add(10, -168);
        dateRangeEndCal.add(10, 168);
        logger.debug("Opened the query window up to search between " + dateRangeStartCal.getTime() + " to " + dateRangeEndCal.getTime());
        String startYear = dateRangeStartCal.get(1) + "";
        String startMonth = dateRangeStartCal.get(2) + 1 + "";
        String startDay = dateRangeStartCal.get(5) + "";
        String startHour = dateRangeStartCal.get(11) + "";
        String startMin = dateRangeStartCal.get(12) + "";
        int numberOfDays = (dateRangeEndCal.get(1) - dateRangeStartCal.get(1)) * 365 + (dateRangeEndCal.get(6) - dateRangeStartCal.get(6));
        String glen = numberOfDays + "";
        URL tideEventUrl = null;
        try {
            tideEventUrl = new URL("http://tbone.biol.sc.edu/tide/tideshow.cgi?tplotdir=horiz;gx=640;gy=240;caltype=ndp;interval=00%3A30;glen=" + glen + ";" + "fontsize=%2B0;" + "units=feet;" + "cleanout=1;" + "year=" + startYear + ";" + "month=" + startMonth + ";" + "day=" + startDay + ";" + "hour=" + startHour + ";" + "min=" + startMin + ";" + "tzone=utc;" + "ampm24=24;" + "colortext=black;" + "colordatum=white;" + "colormsl=yellow;" + "colortics=red;" + "colorday=skyblue;" + "colornight=deep-%3Cbr%20%2F%3Eskyblue;" + "colorebb=seagreen;" + "colorflood=blue;" + "site=" + this.tideLocationUrlFragment);
            logger.debug("readTideEventsFromService: URL to use: " + tideEventUrl);
        }
        catch (MalformedURLException ex) {
            logger.error("MalforedURLException trying to create URL to read tide events" + ex.getMessage());
        }
        BufferedReader in = null;
        try {
            in = new BufferedReader(new InputStreamReader(tideEventUrl.openStream()));
        }
        catch (IOException e) {
            logger.error("IOException caught trying to open buffered reader to URL for tide events: " + e.getMessage());
        }
        Pattern pattern = Pattern.compile("^(\\d{4})-(\\d{2})-(\\d{2})\\s+(\\d{2}):(\\d{2})\\s+(\\S+)\\s+(Sunrise|Sunset|Moonrise|Moonset|New Moon|Full Moon|First Quarter|Last Quarter)$");
        try {
            String inputLine = null;
            String year = null;
            String month = null;
            String day = null;
            String hour = null;
            String minute = null;
            String zone = null;
            String eventString = null;
            while ((inputLine = in.readLine()) != null) {
                Matcher m = pattern.matcher(inputLine);
                if (!m.matches()) continue;
                year = m.group(1);
                month = m.group(2);
                day = m.group(3);
                hour = m.group(4);
                minute = m.group(5);
                zone = m.group(6);
                eventString = m.group(7);
                Calendar eventCalendar = Calendar.getInstance();
                String timeZoneID = eventCalendar.getTimeZone().getID();
                eventCalendar.setTimeZone(TimeZone.getTimeZone("UTC"));
                eventCalendar.set(1, Integer.parseInt(year));
                eventCalendar.set(2, Integer.parseInt(month) - 1);
                eventCalendar.set(5, Integer.parseInt(day));
                eventCalendar.set(11, Integer.parseInt(hour));
                eventCalendar.set(12, Integer.parseInt(minute));
                eventCalendar.set(13, 0);
                eventCalendar.getTime();
                eventsReadFromService.put(eventCalendar.getTime(), eventString);
            }
        }
        catch (IOException e) {
            logger.error("IOException caught trying to read line from URL " + e.getMessage());
        }
        logger.debug("Done with query and found " + eventsReadFromService.size() + " events in the query results.");
        return eventsReadFromService;
    }

    private void addTideEvents(HashMap<Date, String> moreTideEvents) {
        if (moreTideEvents != null && moreTideEvents.size() > 0) {
            if (this.tideEvents == null || this.tideEvents.size() <= 0) {
                this.tideEvents = new TreeMap();
                this.tideEvents.putAll(moreTideEvents);
            } else {
                LinkedList<Date> coverageDates = new LinkedList<Date>(this.coverageMap.keySet());
                Collections.sort(coverageDates);
                for (Date eventDate : moreTideEvents.keySet()) {
                    if (Collections.binarySearch(coverageDates, eventDate) >= 0 || (Collections.binarySearch(coverageDates, eventDate) + 1) * -1 % 2 != 0) continue;
                    this.tideEvents.put(eventDate, moreTideEvents.get(eventDate));
                }
            }
        }
    }
}

