/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.math;

import org.mbari.math.Matlib;

public class DoubleMath {
    public static final double TWO_PI = Math.PI * 2;
    public static final double TAU = Math.PI * 2;

    public static boolean isEven(double x) {
        return DoubleMath.rem(x, 2.0) == 0.0;
    }

    public static double mod(double x, double y) {
        double m = x;
        if (y != 0.0) {
            m = x - y * Math.floor(x / y);
        }
        return m;
    }

    public static double normalizeRadianAngle(double angleRadians) {
        if (angleRadians < 0.0) {
            while (angleRadians < Math.PI * -2) {
                angleRadians += Math.PI * 2;
            }
            angleRadians = Math.PI * 2 + angleRadians;
        } else {
            while (angleRadians > Math.PI * 2) {
                angleRadians -= Math.PI * 2;
            }
        }
        return angleRadians;
    }

    public static double rem(double x, double y) {
        double m = x;
        if (y != 0.0) {
            m = x - y * Matlib.fix(x / y);
        }
        return m;
    }

    public static int sign(double x) {
        int s = 0;
        if (x > 0.0) {
            s = 1;
        } else if (x < 0.0) {
            s = -1;
        }
        return s;
    }
}

