/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.geometry;

import org.mbari.geometry.Point3D;

public class CameraPoint<T extends Number>
extends Point3D<T> {
    private final T heading;
    private final T pitch;
    private final T roll;

    public CameraPoint(T x, T y, T z, T pitch, T roll, T heading) {
        super(x, y, z);
        this.pitch = pitch;
        this.roll = roll;
        this.heading = heading;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CameraPoint other = (CameraPoint)obj;
        if (!super.equals(obj)) {
            return false;
        }
        if (!(this.pitch == other.pitch || this.pitch != null && this.pitch.equals(other.pitch))) {
            return false;
        }
        if (!(this.roll == other.roll || this.roll != null && this.roll.equals(other.roll))) {
            return false;
        }
        return this.heading == other.heading || this.heading != null && this.heading.equals(other.heading);
    }

    public T getHeading() {
        return this.heading;
    }

    public T getPitch() {
        return this.pitch;
    }

    public T getRoll() {
        return this.roll;
    }

    @Override
    public int hashCode() {
        int hash = 5;
        hash = 43 * hash + (this.pitch != null ? this.pitch.hashCode() : 0);
        hash = 43 * hash + (this.roll != null ? this.roll.hashCode() : 0);
        hash = 43 * hash + (this.heading != null ? this.heading.hashCode() : 0);
        return hash + super.hashCode();
    }
}

