/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.expd.math;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class NearestNeighbor {
    public static int[] apply(double[] x, double[] xi, double epsilon) {
        if (x == null) {
            throw new IllegalArgumentException("The x array can not be null");
        }
        if (xi == null) {
            throw new IllegalArgumentException("The xi array can not be null");
        }
        int[] idx = new int[xi.length];
        for (int i = 0; i < xi.length; ++i) {
            idx[i] = NearestNeighbor.apply(x, xi[i], epsilon);
        }
        return idx;
    }

    private static int apply(double[] x, double i, double epsilon) {
        int n = Arrays.binarySearch(x, i);
        if (n < 0) {
            double db;
            int upper;
            int j = -n - 1;
            int lower = j - 1;
            if (lower < 0) {
                lower = 0;
            }
            if ((upper = j) >= x.length) {
                upper = x.length - 1;
            }
            double a = x[lower];
            double b = x[upper];
            double da = Math.abs(a - i);
            n = da <= (db = Math.abs(b - i)) && da <= epsilon ? lower : (db <= epsilon ? upper : -1);
        }
        return n;
    }

    public static int[] apply(long[] x, long[] xi, long epsilon) {
        if (x == null) {
            throw new IllegalArgumentException("The x array can not be null");
        }
        if (xi == null) {
            throw new IllegalArgumentException("The xi array can not be null");
        }
        int[] idx = new int[xi.length];
        for (int i = 0; i < xi.length; ++i) {
            idx[i] = NearestNeighbor.apply(x, xi[i], epsilon);
        }
        return idx;
    }

    private static int apply(long[] x, long i, long epsilon) {
        int n = Arrays.binarySearch(x, i);
        if (n < 0) {
            long db;
            int upper;
            int j = -n - 1;
            int lower = j - 1;
            if (lower < 0) {
                lower = 0;
            }
            if ((upper = j) >= x.length) {
                upper = x.length - 1;
            }
            long a = x[lower];
            long b = x[upper];
            long da = Math.abs(a - i);
            n = da <= (db = Math.abs(b - i)) && da <= epsilon ? lower : (db <= epsilon ? upper : -1);
        }
        return n;
    }

    public static <A> List<A> collate(List<A> x, int[] idx) {
        ArrayList<A> data = new ArrayList<A>();
        for (int i = 0; i < idx.length; ++i) {
            int j = idx[i];
            if (j == -1) {
                data.add(null);
                continue;
            }
            data.add(x.get(j));
        }
        return data;
    }
}

