/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.expd.actions;

import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.mbari.expd.UberDatum;
import org.mbari.expd.actions.CollateFunction;
import org.mbari.expd.math.NearestNeighbor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollateByDateFunction
implements CollateFunction<Date> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public Map<Date, UberDatum> apply(Collection<Date> dateList, Collection<UberDatum> uberDataList, long offsetMillisec) {
        long[] uberDatumAsMillis;
        LinkedHashMap<Date, UberDatum> data = new LinkedHashMap<Date, UberDatum>();
        List dates = dateList.stream().filter(d -> d != null).sorted().collect(Collectors.toList());
        long[] epochMillis = dates.stream().mapToLong(Date::getTime).toArray();
        List uberData = uberDataList.stream().filter(u -> u != null).filter(u -> u.getNavigationDatum() != null).filter(u -> u.getNavigationDatum().getDate() != null).sorted((u1, u2) -> u1.getNavigationDatum().getDate().compareTo(u2.getNavigationDatum().getDate())).collect(Collectors.toList());
        if (uberData.isEmpty()) {
            uberData = uberDataList.stream().filter(u -> u != null).filter(u -> u.getCameraDatum() != null).filter(u -> u.getCameraDatum().getDate() != null).collect(Collectors.toList());
            uberDatumAsMillis = uberData.stream().mapToLong(u -> u.getCameraDatum().getDate().getTime()).toArray();
        } else {
            uberDatumAsMillis = uberData.stream().mapToLong(u -> u.getNavigationDatum().getDate().getTime()).toArray();
        }
        if (!uberData.isEmpty()) {
            int[] idx = NearestNeighbor.apply(uberDatumAsMillis, epochMillis, offsetMillisec);
            for (int i = 0; i < idx.length; ++i) {
                UberDatum ud;
                UberDatum uberDatum = ud = idx[i] == -1 ? null : (UberDatum)uberData.get(idx[i]);
                if (ud == null && this.log.isDebugEnabled()) {
                    this.log.debug("No EXPD Data was found for {}", dates.get(i));
                }
                data.put((Date)dates.get(i), ud);
            }
        } else {
            this.log.info("No Navigation or Camera data was found to merge collate with");
        }
        return data;
    }
}

