/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.expd.actions;

import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.mbari.expd.CameraDatum;
import org.mbari.expd.UberDatum;
import org.mbari.expd.actions.CollateFunction;
import org.mbari.expd.math.NearestNeighbor;
import org.mbari.movie.Timecode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollateByAlternateTimecodeFunction
implements CollateFunction<String> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private Predicate<UberDatum> noNullTimecode = ud -> {
        CameraDatum cd = ud.getCameraDatum();
        return cd != null && cd.getAlternativeTimecode() != null;
    };
    private final Comparator<UberDatum> uberDatumComparator = (u1, u2) -> u1.getCameraDatum().getAlternativeTimecode().compareTo(u2.getCameraDatum().getAlternativeTimecode());

    @Override
    public Map<String, UberDatum> apply(Collection<String> timecodeList, Collection<UberDatum> uberDataList, long offsetMillisec) {
        LinkedHashMap<String, UberDatum> data = new LinkedHashMap<String, UberDatum>();
        List timecodeStrings = timecodeList.stream().filter(s -> s != null).sorted().collect(Collectors.toList());
        double[] timecodesAsMillis = timecodeStrings.stream().map(Timecode::new).mapToDouble(t -> t.getFrames() / t.getFrameRate() * 1000.0).toArray();
        List uberData = uberDataList.stream().filter(u -> u != null).filter(this.noNullTimecode).sorted(this.uberDatumComparator).collect(Collectors.toList());
        double[] uberDatumAsMillis = uberData.stream().map(u -> new Timecode(u.getCameraDatum().getAlternativeTimecode())).mapToDouble(t -> t.getFrames() / t.getFrameRate() * 1000.0).toArray();
        int[] idx = NearestNeighbor.apply(uberDatumAsMillis, timecodesAsMillis, (double)offsetMillisec);
        for (int i = 0; i < idx.length; ++i) {
            UberDatum ud;
            UberDatum uberDatum = ud = idx[i] == -1 ? null : (UberDatum)uberData.get(idx[i]);
            if (ud == null && this.log.isDebugEnabled()) {
                this.log.debug("No EXPD Data was found for {}", timecodeStrings.get(i));
            }
            data.put((String)timecodeStrings.get(i), ud);
        }
        return data;
    }
}

