/*
 * Decompiled with CFR 0.152.
 */
package vars.testing;

import java.util.Date;
import vars.knowledgebase.Concept;
import vars.knowledgebase.ConceptMetadata;
import vars.knowledgebase.ConceptName;
import vars.knowledgebase.ConceptNameTypes;
import vars.knowledgebase.ConceptTypes;
import vars.knowledgebase.History;
import vars.knowledgebase.KnowledgebaseFactory;
import vars.knowledgebase.LinkRealization;
import vars.knowledgebase.LinkTemplate;
import vars.knowledgebase.Media;
import vars.knowledgebase.MediaTypes;
import vars.knowledgebase.Usage;

public class KnowledgebaseTestObjectFactory {
    private final KnowledgebaseFactory factory;

    public KnowledgebaseTestObjectFactory(KnowledgebaseFactory factory) {
        this.factory = factory;
    }

    private static long randomNumber(long min, long max) {
        long range = max - min;
        long value = (long)(Math.random() * (double)range + (double)min);
        return value;
    }

    public Concept makeObjectGraph(int i) {
        return this.makeObjectGraph("TEST", i);
    }

    public Concept makeConcept(String name) {
        Concept c = this.factory.newConcept();
        ConceptName cn1 = this.factory.newConceptName();
        cn1.setName(name + "-primary");
        cn1.setNameType(ConceptNameTypes.PRIMARY.getName());
        c.addConceptName(cn1);
        ConceptName cn2 = this.factory.newConceptName();
        cn2.setName(name + "-common");
        cn2.setNameType(ConceptNameTypes.COMMON.getName());
        c.addConceptName(cn2);
        ConceptName cn3 = this.factory.newConceptName();
        cn3.setName(name + "-synonym");
        cn3.setNameType(ConceptNameTypes.SYNONYM.getName());
        c.addConceptName(cn3);
        c.setNodcCode("dunno");
        c.setOriginator("Unit test");
        c.setRankLevel("1");
        c.setRankName("phylum");
        c.setReference("Some reference");
        c.setStructureType(ConceptTypes.TAXONOMY.getName());
        return c;
    }

    public History makeHistory() {
        History h = this.factory.newHistory();
        h.setCreationDate(new Date());
        h.setAction("ADD");
        h.setComment("test");
        h.setCreatorName("testy-the-testor");
        h.setField("TEST");
        h.setNewValue("NEW VALUE");
        h.setOldValue("OLD VALUE");
        return h;
    }

    public Media makeMedia() {
        Media m = this.factory.newMedia();
        m.setCaption("Caption " + KnowledgebaseTestObjectFactory.randomNumber(0L, 99999999L));
        m.setCredit("Credit " + KnowledgebaseTestObjectFactory.randomNumber(0L, 9999999L));
        m.setUrl("filename" + KnowledgebaseTestObjectFactory.randomNumber(0L, 99999999L));
        m.setType(MediaTypes.IMAGE.getType());
        m.setPrimary(true);
        return m;
    }

    public Usage makeUsage() {
        Usage u = this.factory.newUsage();
        u.setEmbargoExpirationDate(new Date());
        u.setSpecification("Specification can be a looooooong message." + KnowledgebaseTestObjectFactory.randomNumber(0L, 99999999L));
        return u;
    }

    public LinkTemplate makeLinkTemplate() {
        LinkTemplate lt = this.factory.newLinkTemplate();
        lt.setLinkName("link-template");
        lt.setLinkValue("0");
        lt.setToConcept("self");
        return lt;
    }

    public LinkRealization makeLinkRealization() {
        LinkRealization lr = this.factory.newLinkRealization();
        lr.setLinkName("link-realization");
        lr.setLinkValue(KnowledgebaseTestObjectFactory.randomNumber(0L, 9999L) + "");
        lr.setToConcept("self");
        return lr;
    }

    public Concept makeObjectGraph(String name, int depth) {
        Concept root = this.makeFancyConcept(name, depth);
        for (int i = 0; i < depth; ++i) {
            Concept child = this.makeObjectGraph(name + "_" + i + "_" + KnowledgebaseTestObjectFactory.randomNumber(0L, 1000L), depth - 1);
            root.addChildConcept(child);
        }
        return root;
    }

    public Concept makeFancyConcept(String name, int x) {
        Concept c = this.makeConcept(name);
        ConceptMetadata cm = c.getConceptMetadata();
        cm.setUsage(this.makeUsage());
        for (int i = 0; i < x; ++i) {
            cm.addHistory(this.makeHistory());
            cm.addLinkRealization(this.makeLinkRealization());
            cm.addLinkTemplate(this.makeLinkTemplate());
            cm.addMedia(this.makeMedia());
        }
        return c;
    }
}

