/*
 * Decompiled with CFR 0.152.
 */
package vars.testing;

import java.text.NumberFormat;
import java.util.Date;
import org.mbari.movie.Timecode;
import vars.annotation.AnnotationFactory;
import vars.annotation.Association;
import vars.annotation.CameraData;
import vars.annotation.CameraDeployment;
import vars.annotation.FormatCodes;
import vars.annotation.Observation;
import vars.annotation.PhysicalData;
import vars.annotation.VideoArchive;
import vars.annotation.VideoArchiveSet;
import vars.annotation.VideoFrame;

public class AnnotationTestObjectFactory {
    private final AnnotationFactory factory;
    public static final long TEST_EPOCH = 1063391106296L;

    public AnnotationTestObjectFactory(AnnotationFactory factory) {
        this.factory = factory;
    }

    private static long randomNumber(long min, long max) {
        long range = max - min;
        long value = (long)(Math.random() * (double)range + (double)min);
        return value;
    }

    private static Timecode makeTimecode() {
        long hour = AnnotationTestObjectFactory.randomNumber(0L, 12L);
        long minute = AnnotationTestObjectFactory.randomNumber(0L, 59L);
        long second = AnnotationTestObjectFactory.randomNumber(0L, 59L);
        long frame = AnnotationTestObjectFactory.randomNumber(0L, 29L);
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMinimumIntegerDigits(2);
        return new Timecode(nf.format(hour) + ":" + nf.format(minute) + ":" + nf.format(second) + ":" + nf.format(frame));
    }

    public VideoArchiveSet makeVideoArchiveSet() {
        String trackingNumber = AnnotationTestObjectFactory.randomNumber(0L, 10000L) + "";
        String shipName = "TEST";
        String platformName = "TEST";
        char formatCode = FormatCodes.DETAILED.getCode();
        VideoArchiveSet vas = this.factory.newVideoArchiveSet();
        vas.setTrackingNumber(trackingNumber);
        vas.setShipName(shipName);
        vas.setPlatformName(platformName);
        vas.setFormatCode(formatCode);
        vas.setStartDate(new Date(AnnotationTestObjectFactory.randomNumber(0L, 1063391106296L)));
        vas.setEndDate(new Date(AnnotationTestObjectFactory.randomNumber(1063391106296L, new Date().getTime())));
        return vas;
    }

    public VideoArchive makeVideoArchive() {
        String name = "T" + Integer.valueOf((int)AnnotationTestObjectFactory.randomNumber(1L, 1500000L));
        Timecode timeCode = AnnotationTestObjectFactory.makeTimecode();
        VideoArchive va = this.factory.newVideoArchive();
        va.setStartTimecode(timeCode.toString());
        va.setName(name);
        return va;
    }

    public CameraDeployment makeCameraPlatformDeployment() {
        int seqNumber = (int)AnnotationTestObjectFactory.randomNumber(1L, 3000L);
        Date start = new Date(AnnotationTestObjectFactory.randomNumber(0L, 1063391106296L));
        Date end = new Date(AnnotationTestObjectFactory.randomNumber(1063391106296L, new Date().getTime()));
        CameraDeployment cd = this.factory.newCameraDeployment();
        cd.setChiefScientistName("MBARI Scientest");
        cd.setStartDate(start);
        cd.setEndDate(end);
        cd.setSequenceNumber(seqNumber);
        return cd;
    }

    public VideoFrame makeVideoFrame() {
        long recordedEpoch = AnnotationTestObjectFactory.randomNumber(1063391106296L, new Date().getTime());
        VideoFrame videoFrame = this.factory.newVideoFrame();
        videoFrame.setRecordedDate(new Date(recordedEpoch));
        videoFrame.setTimecode(AnnotationTestObjectFactory.makeTimecode().toString());
        videoFrame.setInSequence(true);
        videoFrame.setAlternateTimecode(AnnotationTestObjectFactory.makeTimecode().toString());
        PhysicalData physicalData = videoFrame.getPhysicalData();
        physicalData.setDepth(new Float((float)AnnotationTestObjectFactory.randomNumber(0L, 90000L) / 100.0f));
        physicalData.setLatitude(new Double((float)AnnotationTestObjectFactory.randomNumber(0L, 9000L) / 100.0f));
        physicalData.setLongitude(new Double((float)AnnotationTestObjectFactory.randomNumber(0L, -18000L) / 100.0f));
        physicalData.setLight(new Float((float)AnnotationTestObjectFactory.randomNumber(0L, 10000L) / 100.0f));
        physicalData.setOxygen(new Float((float)AnnotationTestObjectFactory.randomNumber(0L, 1000L) / 100.0f));
        physicalData.setSalinity(new Float((float)AnnotationTestObjectFactory.randomNumber(320000L, 360000L) / 10000.0f));
        physicalData.setTemperature(new Float((float)AnnotationTestObjectFactory.randomNumber(30000L, 150000L) / 10000.0f));
        physicalData.setAltitude(new Float((float)AnnotationTestObjectFactory.randomNumber(0L, 90000L) / 100.0f));
        CameraData camera = videoFrame.getCameraData();
        camera.setName("Test");
        camera.setDirection("cruise");
        camera.setFieldWidth(new Double(AnnotationTestObjectFactory.randomNumber(0L, 100L)));
        camera.setFocus((int)AnnotationTestObjectFactory.randomNumber(0L, 10L));
        camera.setIris((int)AnnotationTestObjectFactory.randomNumber(0L, 5L));
        camera.setImageReference("http://www.mbari.org/IMG" + AnnotationTestObjectFactory.randomNumber(0L, 10000L) + ".jpg");
        camera.setZoom((int)AnnotationTestObjectFactory.randomNumber(0L, 10L));
        return videoFrame;
    }

    public Observation makeObservation(String conceptName) {
        Observation observation = this.factory.newObservation();
        observation.setObserver("Testy the Tester");
        observation.setConceptName(conceptName);
        observation.setObservationDate(new Date());
        observation.setNotes("Test tes test test");
        return observation;
    }

    public Association makeAssociation() {
        Association association = this.factory.newAssociation();
        association.setLinkName("pop-count");
        association.setLinkValue(AnnotationTestObjectFactory.randomNumber(1L, 1000L) + "");
        association.setToConcept("nil");
        return association;
    }

    public VideoArchiveSet makeObjectGraph(String prefix) {
        return this.makeObjectGraph(prefix, 2);
    }

    public VideoArchiveSet makeObjectGraph(String prefix, int depth) {
        VideoArchiveSet vas = this.makeVideoArchiveSet();
        String shortPrefix = prefix;
        vas.setShipName(shortPrefix);
        vas.setPlatformName(shortPrefix);
        for (int n = 0; n < depth; ++n) {
            int i;
            VideoArchive va = this.makeVideoArchive();
            va = this.makeVideoArchive();
            vas.addVideoArchive(va);
            for (i = 0; i < depth; ++i) {
                CameraDeployment cpd = this.makeCameraPlatformDeployment();
                cpd.setChiefScientistName(prefix + "_scientist_" + n + "_" + i);
                vas.addCameraDeployment(cpd);
            }
            for (i = 0; i < depth; ++i) {
                VideoFrame vf = this.makeVideoFrame();
                va.addVideoFrame(vf);
                for (int j = 0; j < depth; ++j) {
                    Observation obs = this.makeObservation(prefix + "_observation_" + n + "_" + i + "_" + j);
                    vf.addObservation(obs);
                    for (int k = 0; k < depth; ++k) {
                        Association a = this.makeAssociation();
                        a.setLinkName(prefix);
                        a.setLinkValue(n + "_" + i + "_" + j + "_" + k);
                        obs.addAssociation(a);
                    }
                }
            }
        }
        return vas;
    }
}

