/*
 * Decompiled with CFR 0.152.
 */
package vars.knowledgebase;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import vars.knowledgebase.Concept;
import vars.knowledgebase.ConceptMetadata;
import vars.knowledgebase.ConceptName;
import vars.knowledgebase.ConceptNameTypes;
import vars.knowledgebase.SimpleConceptMetadataBean;

public class SimpleConceptBean
implements Concept {
    private Set<ConceptName> conceptNames = new HashSet<ConceptName>();
    private List<Concept> childConcepts = new ArrayList<Concept>();
    private Concept parentConcept;
    private ConceptMetadata conceptMetadata = new SimpleConceptMetadataBean(this);

    public SimpleConceptBean() {
    }

    public SimpleConceptBean(ConceptName conceptName) {
        conceptName.setNameType(ConceptNameTypes.PRIMARY.toString());
        this.addConceptName(conceptName);
    }

    @Override
    public void addChildConcept(Concept child) {
        this.childConcepts.add(child);
    }

    @Override
    public void addConceptName(ConceptName conceptName) {
        this.conceptNames.add(conceptName);
    }

    @Override
    public List<Concept> getChildConcepts() {
        return this.childConcepts;
    }

    @Override
    public ConceptMetadata getConceptMetadata() {
        return this.conceptMetadata;
    }

    @Override
    public ConceptName getConceptName(String name) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Set<ConceptName> getConceptNames() {
        return this.conceptNames;
    }

    @Override
    public String getNodcCode() {
        return "NOT IMPLEMENTED";
    }

    @Override
    public String getOriginator() {
        return "NOT IMPLEMENTED";
    }

    @Override
    public Concept getParentConcept() {
        return this.parentConcept;
    }

    @Override
    public ConceptName getPrimaryConceptName() {
        ConceptName primaryName = null;
        for (ConceptName cn : this.conceptNames) {
            if (!cn.getNameType().equalsIgnoreCase(ConceptNameTypes.PRIMARY.toString())) continue;
            primaryName = cn;
            break;
        }
        return primaryName;
    }

    @Override
    public String getRankLevel() {
        return "NOT IMPLEMENTED";
    }

    @Override
    public String getRankName() {
        return "NOT IMPLEMENTED";
    }

    @Override
    public String getReference() {
        return "NOT IMPLEMENTED";
    }

    @Override
    public Concept getRootConcept() {
        Concept gotRoot = this;
        while (gotRoot.getParentConcept() != null) {
            gotRoot = gotRoot.getParentConcept();
        }
        return gotRoot;
    }

    @Override
    public String getStructureType() {
        return "NOT IMPLEMENTED";
    }

    @Override
    public boolean hasChildConcepts() {
        return this.childConcepts.size() > 0;
    }

    @Override
    public boolean hasDescendent(String child) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean hasDetails() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean hasParent() {
        return this.parentConcept != null;
    }

    @Override
    public void removeChildConcept(Concept childConcept) {
        this.childConcepts.remove(childConcept);
        ((SimpleConceptBean)childConcept).setParentConcept(null);
    }

    @Override
    public void removeConceptName(ConceptName conceptName) {
        this.conceptNames.remove(conceptName);
        conceptName.setConcept(null);
    }

    @Override
    public void setNodcCode(String nodcCode) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setOriginator(String originator) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setRankLevel(String rankLevel) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setRankName(String rankName) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setReference(String reference) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setStructureType(String structureType) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void loadLazyRelations() {
    }

    protected void setParentConcept(Concept parentConcept) {
        this.parentConcept = parentConcept;
    }

    @Override
    public void setTaxonomyType(String taxonomyType) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getTaxonomyType() {
        return "NOT IMPLEMENTED";
    }

    @Override
    public Object getPrimaryKey() {
        return null;
    }
}

