/*
 * Decompiled with CFR 0.152.
 */
package vars.knowledgebase;

import com.google.inject.Inject;
import java.util.Date;
import vars.UserAccount;
import vars.knowledgebase.Concept;
import vars.knowledgebase.ConceptName;
import vars.knowledgebase.History;
import vars.knowledgebase.KnowledgebaseFactory;
import vars.knowledgebase.LinkRealization;
import vars.knowledgebase.LinkTemplate;
import vars.knowledgebase.Media;

public class HistoryFactory {
    private final KnowledgebaseFactory knowledgebaseFactory;

    @Inject
    public HistoryFactory(KnowledgebaseFactory knowledgebaseFactory) {
        this.knowledgebaseFactory = knowledgebaseFactory;
    }

    private History newHistory(UserAccount userAccount, String action, String fieldName, String oldValue, String newValue) {
        History history = this.knowledgebaseFactory.newHistory();
        history.setCreatorName(userAccount.getUserName());
        history.setCreationDate(new Date());
        history.setAction(action);
        history.setField(fieldName);
        history.setOldValue(oldValue);
        history.setNewValue(newValue);
        return history;
    }

    public History add(UserAccount userAccount, ConceptName conceptName) {
        return this.newHistory(userAccount, "ADD", "ConceptName", null, conceptName.getName());
    }

    public History add(UserAccount userAccount, Concept concept) {
        return this.newHistory(userAccount, "ADD", "Concept.child", null, concept.getPrimaryConceptName().getName());
    }

    public History add(UserAccount userAccount, LinkRealization linkRealization) {
        return this.newHistory(userAccount, "ADD", "LinkRealization", null, linkRealization.stringValue());
    }

    public History add(UserAccount userAccount, LinkTemplate linkTemplate) {
        return this.newHistory(userAccount, "ADD", "LinkTemplate", null, linkTemplate.stringValue());
    }

    public History add(UserAccount userAccount, Media media) {
        return this.newHistory(userAccount, "ADD", "Media", null, media.getUrl());
    }

    public History delete(UserAccount userAccount, ConceptName conceptName) {
        return this.newHistory(userAccount, "DELETE", "ConceptName", conceptName.getName(), null);
    }

    public History delete(UserAccount userAccount, Concept concept) {
        return this.newHistory(userAccount, "DELETE", "Concept.child", concept.getPrimaryConceptName().getName(), null);
    }

    public History delete(UserAccount userAccount, LinkRealization linkRealization) {
        return this.newHistory(userAccount, "DELETE", "LinkRealization", linkRealization.stringValue(), null);
    }

    public History delete(UserAccount userAccount, LinkTemplate linkTemplate) {
        return this.newHistory(userAccount, "DELETE", "LinkTemplate", linkTemplate.stringValue(), null);
    }

    public History delete(UserAccount userAccount, Media media) {
        return this.newHistory(userAccount, "DELETE", "Media", media.getUrl(), null);
    }

    public History replaceParentConcept(UserAccount userAccount, Concept oldParent, Concept newParent) {
        return this.newHistory(userAccount, "REPLACE", "Concept.parent", oldParent.getPrimaryConceptName().getName(), newParent.getPrimaryConceptName().getName());
    }

    public History replaceOriginator(UserAccount userAccount, String oldOrig, String newOrig) {
        return this.newHistory(userAccount, "REPLACE", "Originator", oldOrig, newOrig);
    }

    public History replaceRankName(UserAccount userAccount, String oldRankName, String newRankName) {
        return this.newHistory(userAccount, "REPLACE", "RankName", oldRankName, newRankName);
    }

    public History replaceRankLevel(UserAccount userAccount, String oldRankLevel, String newRankLevel) {
        return this.newHistory(userAccount, "REPLACE", "RankLevel", oldRankLevel, newRankLevel);
    }

    public History replaceStructureType(UserAccount userAccount, String oldSt, String newSt) {
        return this.newHistory(userAccount, "REPLACE", "StructureType", oldSt, newSt);
    }

    public History replaceReference(UserAccount userAccount, String oldRef, String newRef) {
        return this.newHistory(userAccount, "REPLACE", "Reference", oldRef, newRef);
    }

    public History replaceConceptName(UserAccount userAccount, ConceptName oldName, ConceptName newName) {
        return this.newHistory(userAccount, "REPLACE", "ConceptName", oldName.stringValue(), newName.stringValue());
    }

    public History replacePrimaryConceptName(UserAccount userAccount, ConceptName oldName, ConceptName newName) {
        return this.newHistory(userAccount, "REPLACE", "Concept.primaryConceptName", oldName.getName(), newName.getName());
    }

    public History replaceNodcCode(UserAccount userAccount, String oldCode, String newCode) {
        return this.newHistory(userAccount, "REPLACE", "NodcCode", oldCode, newCode);
    }

    public History replaceLinkTemplate(UserAccount userAccount, LinkTemplate oldValue, LinkTemplate newValue) {
        return this.newHistory(userAccount, "REPLACE", "LinkTemplate", oldValue.stringValue(), newValue.stringValue());
    }

    public History replaceLinkRealization(UserAccount userAccount, LinkRealization oldValue, LinkRealization newValue) {
        return this.newHistory(userAccount, "REPLACE", "LinkRealization", oldValue.stringValue(), newValue.stringValue());
    }
}

