/*
 * Decompiled with CFR 0.152.
 */
package vars.annotation.functions;

import com.google.common.base.Preconditions;
import java.awt.Polygon;
import java.awt.geom.Area;
import java.awt.geom.PathIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.mbari.geometry.Point2D;
import vars.ILink;
import vars.annotation.AreaMeasurement;
import vars.annotation.functions.LinkToAWTPolygonFn;

public class TrimAreaMeasurementsFn
implements Function<ILink, Optional<ILink>> {
    private final Area acceptableBounds;
    private final Function<ILink, Polygon> toPolygon = new LinkToAWTPolygonFn();

    public TrimAreaMeasurementsFn(List<Point2D<Integer>> bounds) {
        Preconditions.checkArgument((bounds != null ? 1 : 0) != 0, (Object)"The bounds can not be null");
        Preconditions.checkArgument((!bounds.isEmpty() ? 1 : 0) != 0, (Object)"The bounds can not be empty");
        Polygon boundingPolygon = new Polygon();
        bounds.stream().forEach(p -> boundingPolygon.addPoint((Integer)p.getX(), (Integer)p.getY()));
        this.acceptableBounds = new Area(boundingPolygon);
    }

    @Override
    public Optional<ILink> apply(ILink link) {
        if (AreaMeasurement.IS_AREA_MEASUREMENT_PREDICATE.test(link)) {
            Polygon polygon = this.toPolygon.apply(link);
            Area area = new Area(polygon);
            area.intersect(this.acceptableBounds);
            Polygon trimmedPolygon = this.areaToPolygon(area);
            if (trimmedPolygon.npoints >= 3) {
                AreaMeasurement trimmedAreaMeasurement = this.polygonToAreaMeasurement(trimmedPolygon);
                return Optional.of(trimmedAreaMeasurement.toLink());
            }
            return Optional.empty();
        }
        return Optional.of(link);
    }

    private Polygon areaToPolygon(Area area) {
        PathIterator i = area.getPathIterator(null);
        float[] floats = new float[6];
        Polygon polygon = new Polygon();
        while (!i.isDone()) {
            int type = i.currentSegment(floats);
            int x = (int)floats[0];
            int y = (int)floats[1];
            if (type != 4) {
                polygon.addPoint(x, y);
            }
            i.next();
        }
        return polygon;
    }

    private AreaMeasurement polygonToAreaMeasurement(Polygon polygon) {
        int n = polygon.npoints;
        int[] xs = polygon.xpoints;
        int[] ys = polygon.ypoints;
        ArrayList<Point2D<Integer>> points = new ArrayList<Point2D<Integer>>();
        for (int i = 0; i < n; ++i) {
            points.add((Point2D<Integer>)new Point2D((Number)xs[i], (Number)ys[i]));
        }
        return new AreaMeasurement(points);
    }
}

