/*
 * Decompiled with CFR 0.152.
 */
package vars.annotation;

import com.google.common.collect.ImmutableMap;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import org.mbari.geometry.Point2D;
import org.mbari.gis.util.GISUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vars.VARSException;
import vars.annotation.CameraData;
import vars.annotation.Observation;
import vars.annotation.VideoFrame;

public class ObservationsSpatialLocations {
    private final VideoFrame videoFrame;
    private Integer widthInPixels;
    private Integer heightInPixels;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private Map spatialLocations;

    public ObservationsSpatialLocations(VideoFrame videoFrame) {
        this.videoFrame = videoFrame;
    }

    public void process() {
        if (this.spatialLocations == null) {
            HashMap<Observation, Point2D<Double>> points = new HashMap<Observation, Point2D<Double>>();
            for (Observation observation : this.videoFrame.getObservations()) {
                points.put(observation, this.process(observation));
            }
            this.spatialLocations = ImmutableMap.copyOf(points);
        }
    }

    public Point2D<Double> process(Observation observation) {
        try {
            this.processImageReference();
        }
        catch (IOException ex) {
            return new Point2D((Number)Double.NaN, (Number)Double.NaN);
        }
        Integer m = this.widthInPixels;
        Integer n = this.heightInPixels;
        if (m == null || n == null) {
            throw new VARSException("Missing the size of a dimension (in pixels) for " + observation);
        }
        int u = (int)Math.round(observation.getX());
        int v = (int)Math.round(observation.getY());
        CameraData cameraData = this.videoFrame.getCameraData();
        double w = cameraData.getViewWidth().floatValue();
        double h = cameraData.getViewHeight().floatValue();
        double x = cameraData.getX().floatValue();
        double y = cameraData.getY().floatValue();
        double m0 = (double)m.intValue() / 2.0;
        double n0 = (double)n.intValue() / 2.0;
        double du0 = (double)u - m0;
        double dv0 = n0 - (double)v;
        double dx1 = du0 * w / (double)m.intValue();
        double dy1 = dv0 * h / (double)n.intValue();
        double phi = Math.atan2(dy1, dx1);
        double theta = phi - (double)cameraData.getHeading().floatValue();
        double r = Math.sqrt(dx1 * dx1 + dy1 * dy1);
        double xInMeters = x + r * Math.cos(theta);
        double yInMeters = y + r * Math.sin(theta);
        if (this.log.isDebugEnabled()) {
            this.log.debug("SpatialLocation: " + this + "\n\tImage:\n\t\tDimensions:                                [" + m + "px x " + n + "px]\n\t\tSize:                                      [" + w + "m x " + h + "m]\n\t\tDistance from center to origin:            [" + x + "m, " + y + "m]\n\t\tHeading:                                    " + Math.toDegrees(cameraData.getHeading().floatValue()) + " degrees\n\tAnnotation:\n\t\tPixel:                                     [" + u + ", " + v + "]\n\t\tDistance from center to annotation:        [" + dx1 + "m, " + dy1 + "m]\n\t\tDistance from origin to annotation:        [" + xInMeters + "m, " + yInMeters + "m]\n\t\tDistance from center to annotation:         " + r + "m\n\t\tMath angle from center to annotation:       " + Math.toDegrees(theta) + "\n\t\tgeographic angle from center to annotation: " + Math.toDegrees(GISUtilities.mathToGeo((double)theta)) + "\n\t");
        }
        return new Point2D((Number)xInMeters, (Number)yInMeters);
    }

    private void processImageReference() throws IOException {
        String imageReference;
        if (this.widthInPixels == null && this.heightInPixels == null && (imageReference = this.videoFrame.getCameraData().getImageReference()) != null) {
            URL imageUrl = new URL(imageReference);
            BufferedImage image = ImageIO.read(imageUrl);
            this.widthInPixels = image.getWidth();
            this.heightInPixels = image.getHeight();
        }
    }

    public Integer getHeightInPixels() {
        this.process();
        return this.heightInPixels;
    }

    public Integer getWidthInPixels() {
        this.process();
        return this.widthInPixels;
    }

    public Map<Observation, Point2D<Double>> getSpatialLocations() {
        this.process();
        return this.spatialLocations;
    }
}

