/*
 * Decompiled with CFR 0.152.
 */
package vars.annotation;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.mbari.geometry.Point2D;
import vars.ILink;
import vars.LinkBean;
import vars.annotation.Observation;

public class AreaMeasurement {
    public static final String AREA_MEASUREMENT_LINKNAME = "area measurement coordinates [x0 y0 ... xn yn; comment]";
    public static final Predicate<ILink> IS_AREA_MEASUREMENT_PREDICATE = input -> AREA_MEASUREMENT_LINKNAME.equalsIgnoreCase(input.getLinkName());
    public static final Function<ILink, AreaMeasurement> LINK_TO_AREA_MEASUREMENT_TRANSFORM = input -> AreaMeasurement.fromLink(input);
    private String comment;
    private final List<Point2D<Integer>> coordinates;

    public AreaMeasurement(List<Point2D<Integer>> coordinates) {
        this(coordinates, null);
    }

    public AreaMeasurement(List<Point2D<Integer>> coordinates, String comment) {
        Preconditions.checkArgument((coordinates.size() > 2 ? 1 : 0) != 0, (Object)("Area measurement requires at least 3 points (found " + coordinates.size() + ")"));
        if (coordinates.get(0).equals(coordinates.get(coordinates.size() - 1))) {
            coordinates = coordinates.subList(0, coordinates.size() - 1);
        }
        this.coordinates = ImmutableList.copyOf(coordinates);
        this.comment = comment;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AreaMeasurement that = (AreaMeasurement)o;
        return this.coordinates.equals(that.coordinates);
    }

    public static AreaMeasurement fromLink(ILink link) {
        String[] coordsAndComment = link.getLinkValue().split(";");
        String comment = coordsAndComment.length == 2 ? coordsAndComment[1] : null;
        Preconditions.checkArgument((coordsAndComment.length > 0 ? 1 : 0) != 0, (Object)("No data was found in " + link));
        String[] parts = coordsAndComment[0].split(" ");
        Preconditions.checkArgument((parts.length >= 6 ? 1 : 0) != 0, (Object)"The Association does not contain 3 or more pixel coordinates");
        Preconditions.checkArgument((parts.length % 2 == 0 ? 1 : 0) != 0, (Object)"The Association does not contain X-Y coordinate pairs");
        ArrayList<Point2D<Integer>> points = new ArrayList<Point2D<Integer>>();
        for (int idx = 0; idx < parts.length; ++idx) {
            Integer x = Integer.valueOf(parts[idx]);
            Integer y = Integer.valueOf(parts[++idx]);
            points.add((Point2D<Integer>)new Point2D((Number)x, (Number)y));
        }
        return new AreaMeasurement(points, comment);
    }

    public static Collection<AreaMeasurement> fromObservation(Observation observation) {
        return observation.getAssociations().stream().filter(IS_AREA_MEASUREMENT_PREDICATE).map(LINK_TO_AREA_MEASUREMENT_TRANSFORM).collect(Collectors.toList());
    }

    public String getComment() {
        return this.comment;
    }

    public List<Point2D<Integer>> getCoordinates() {
        return this.coordinates;
    }

    public int hashCode() {
        return this.coordinates.hashCode();
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public ILink toLink() {
        String c = Strings.isNullOrEmpty((String)this.comment) ? "" : "; " + this.comment;
        StringBuilder sb = new StringBuilder();
        for (Point2D<Integer> p : this.coordinates) {
            sb.append(p.getX()).append(" ").append(p.getY()).append(" ");
        }
        String linkValue = sb.toString().substring(0, sb.length() - 1) + c;
        return new LinkBean(AREA_MEASUREMENT_LINKNAME, "self", linkValue);
    }

    public String toString() {
        return "AreaMeasurement{coordinates=" + this.coordinates + '}';
    }
}

