/*
 * Decompiled with CFR 0.152.
 */
package vars;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vars.CacheClearedEvent;
import vars.CacheClearedListener;
import vars.PersistenceCacheProvider;
import vars.annotation.AnnotationObject;
import vars.knowledgebase.KnowledgebaseObject;

public class PersistenceCache {
    private final List<CacheClearedListener> clearCacheListeners = Collections.synchronizedList(new ArrayList());
    private final PersistenceCacheProvider provider;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    @Inject
    public PersistenceCache(PersistenceCacheProvider provider) {
        this.provider = provider;
    }

    public void addCacheClearedListener(CacheClearedListener listener) {
        this.clearCacheListeners.add(listener);
    }

    public void clear() {
        this.log.debug("Clearing persistence cache");
        this.notifyCacheClearedListenersBeforeClear();
        this.provider.clear();
        this.notifyCacheClearedListenersAfterClear();
    }

    public void evict(AnnotationObject object) {
        this.provider.evict(object);
    }

    public void evict(KnowledgebaseObject object) {
        this.provider.evict(object);
    }

    private void notifyCacheClearedListenersAfterClear() {
        CacheClearedEvent event = new CacheClearedEvent(this);
        ArrayList<CacheClearedListener> listeners = new ArrayList<CacheClearedListener>(this.clearCacheListeners);
        for (CacheClearedListener listener : listeners) {
            listener.afterClear(event);
        }
    }

    private void notifyCacheClearedListenersBeforeClear() {
        CacheClearedEvent event = new CacheClearedEvent(this);
        ArrayList<CacheClearedListener> listeners = new ArrayList<CacheClearedListener>(this.clearCacheListeners);
        for (CacheClearedListener listener : listeners) {
            listener.beforeClear(event);
        }
    }

    public void removeCacheClearedListener(CacheClearedListener listener) {
        this.clearCacheListeners.remove(listener);
    }
}

