/*
 * Decompiled with CFR 0.152.
 */
package vars;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import java.util.Collection;
import java.util.Comparator;
import vars.ILink;
import vars.LinkComparator;

public class LinkUtilities {
    private static final Comparator<ILink> COMPARATOR = new LinkComparator();

    public static String formatAsLongString(ILink link) {
        StringBuilder sb = new StringBuilder();
        String fromConcept = link.getFromConcept();
        fromConcept = fromConcept == null ? "nil" : fromConcept;
        sb.append(fromConcept).append(" | ");
        sb.append(link.getLinkName()).append(" | ");
        sb.append(link.getToConcept()).append(" | ");
        sb.append(link.getLinkValue());
        return sb.toString();
    }

    public static String formatAsString(ILink link) {
        StringBuilder sb = new StringBuilder();
        sb.append(link.getLinkName()).append(" | ");
        sb.append(link.getToConcept()).append(" | ");
        sb.append(link.getLinkValue());
        return sb.toString();
    }

    public static Collection<ILink> findMatchingLinksIn(Collection<ILink> links, final ILink templateLink) {
        return Collections2.filter(links, (Predicate)new Predicate<ILink>(){

            public boolean apply(ILink input) {
                return COMPARATOR.compare(input, templateLink) == 0;
            }
        });
    }
}

